/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui;

import com.sap.engine.gui.CEscapeDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextFieldsDialog
extends CEscapeDialog
implements ActionListener,
DocumentListener {
    protected String OK_CMD = "OK";
    protected String CANCEL_CMD = "CANCEL";
    protected String[] labelNames;
    protected String[] textFieldTexts;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JTextField[] textFields;
    protected boolean isOK = false;

    public TextFieldsDialog(Frame owner, String title, String[] labelNames, String[] textFieldTexts) {
        super(owner, title, true);
        this.labelNames = labelNames;
        this.textFieldTexts = textFieldTexts;
        this.initView();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public TextFieldsDialog(Frame owner, String title, String[] labelNames) {
        this(owner, title, labelNames, null);
    }

    protected void initView() {
        int i;
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout());
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand(this.OK_CMD);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand(this.CANCEL_CMD);
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        JPanel fieldsPanel = new JPanel();
        fieldsPanel.setBorder(BorderFactory.createEtchedBorder());
        fieldsPanel.setLayout(new GridBagLayout());
        this.textFields = new JTextField[this.labelNames.length];
        int i2 = 0;
        while (i2 < this.textFields.length) {
            this.textFields[i2] = new JTextField();
            this.textFields[i2].setPreferredSize(new Dimension(150, 20));
            this.textFields[i2].getDocument().addDocumentListener(this);
            ++i2;
        }
        if (this.textFieldTexts != null) {
            i = 0;
            while (i < this.textFields.length) {
                this.textFields[i].setText(this.textFieldTexts[i]);
                if (this.textFieldTexts[i].length() == 0) {
                    this.okButton.setEnabled(false);
                } else {
                    this.okButton.setEnabled(true);
                }
                ++i;
            }
        } else {
            this.okButton.setEnabled(false);
        }
        i = 0;
        while (i < this.labelNames.length) {
            JLabel label = new JLabel(this.labelNames[i]);
            fieldsPanel.add((Component)label, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            fieldsPanel.add((Component)this.textFields[i], new GridBagConstraints(1, i, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            ++i;
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)fieldsPanel, "Center");
        this.getContentPane().add((Component)buttonsPanel, "South");
    }

    public boolean showDialog() {
        ((Component)this).setVisible(true);
        return this.isOK;
    }

    public String[] getResults() {
        String[] results = new String[this.textFields.length];
        int i = 0;
        while (i < this.textFields.length) {
            results[i] = this.textFields[i].getText();
            ++i;
        }
        return results;
    }

    public void performEnterAction(KeyEvent e) {
        this.okButton.doClick();
    }

    public void actionPerformed(ActionEvent e) {
        String actionCmd = e.getActionCommand();
        if (actionCmd.equals(this.OK_CMD)) {
            this.isOK = true;
            ((Component)this).setVisible(false);
            return;
        }
        if (actionCmd.equals(this.CANCEL_CMD)) {
            ((Component)this).setVisible(false);
            return;
        }
    }

    public void insertUpdate(DocumentEvent e) {
        boolean allFull = true;
        int i = 0;
        while (i < this.textFields.length) {
            if (this.textFields[i].getText().length() == 0) {
                allFull = false;
                break;
            }
            this.okButton.setEnabled(allFull);
            ++i;
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (e.getDocument().getLength() == 0) {
            this.okButton.setEnabled(false);
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }
}

