/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui;

import javax.swing.JProgressBar;

public class ProgressBarThread
extends Thread {
    public static final int FINISHED = 0;
    public static final int RUNNING = 1;
    public static final int ERROR = 2;
    protected JProgressBar progressBar;
    protected boolean toBeKilled;
    protected double progress;
    protected int status;
    private boolean forceKill = false;
    private int multiplayer = 1;
    private int maxMultiplayer = 1;
    private boolean progresGO;

    public ProgressBarThread(JProgressBar progressBar) {
        this.progressBar = progressBar;
        this.toBeKilled = false;
        this.status = 1;
    }

    public void kill() {
        this.toBeKilled = true;
    }

    public void forcedKill() {
        this.forceKill = true;
    }

    public void run() {
        while (!this.toBeKilled) {
            int progress = this.getProgress();
            this.progressBar.setValue(progress);
            this.progressBar.setString(progress + "%");
            this.progressBar.setStringPainted(true);
            this.progressBar.repaint();
            this.progressBar.validate();
            this.progressBar.update(this.progressBar.getGraphics());
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this.forceKill) {
            this.progressBar.setValue(100);
            this.progressBar.setString("100%");
            this.progressBar.repaint();
            this.progressBar.validate();
            this.forceKill = false;
        }
    }

    public int getProgress() {
        if (this.progress >= 100.0) {
            this.status = 0;
        } else {
            this.calculate();
        }
        return (int)this.progress;
    }

    protected void calculate() {
        if (this.progress < 100.0 && this.progresGO) {
            double step = (100.0 - this.progress) / 100.0 / (double)this.multiplayer;
            this.progress += step;
        }
    }

    public void nextPhase(int phase) {
    }

    public void initPhase() {
    }

    public void setMultiplayer(int multi) {
        this.multiplayer = multi;
        if (this.maxMultiplayer == 3) {
            if (this.multiplayer == 2) {
                if (this.progress < 33.0) {
                    this.progress = 33.0;
                }
            } else if (this.multiplayer == 1 && this.progress < 66.0) {
                this.progress = 66.0;
            }
        } else if (this.maxMultiplayer == 2 && this.multiplayer == 1 && this.progress < 50.0) {
            this.progress = 50.0;
        }
    }

    public void setProgress(int p) {
        this.progress = p;
    }

    public void stopProgress() {
        this.progresGO = false;
    }

    public void startProgress() {
        this.progresGO = true;
    }

    public void setMAXMultiplayer(int multi) {
        this.maxMultiplayer = multi;
        this.setMultiplayer(multi);
    }
}

