/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui;

import com.sap.engine.gui.lf.LookAndFeelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class LogMessageDialog
extends JDialog
implements ActionListener,
LookAndFeelListener {
    private JButton okButton;
    private JButton detailButton;
    private JScrollPane messageScrollPane;
    private JPanel messagePanel;
    private JScrollPane detailScrollPane;
    private JPanel detailPanel;
    private JPanel scrollPanel;
    private JPanel buttonsPanel;
    private JPanel mainPanel;
    private JPanel detailTextPanel;
    private String detail;
    private JLabel iconLabel;
    private JPanel iconPanel;
    private Frame parentFrame;
    private static final int ERROR = 0;
    private static final int WARNING = 1;
    private static final int INFORMATION = 2;
    private String detailsStr = "LogDetails";
    private String noDetailsStr = "No Details";
    Border borderIconPanel = BorderFactory.createEmptyBorder(10, 10, 5, 10);
    Border etchedBorder = BorderFactory.createEtchedBorder();
    Border messageBorder = BorderFactory.createTitledBorder(this.etchedBorder, "Message");
    Border detailsBorder = BorderFactory.createTitledBorder(this.etchedBorder, "Details");
    Icon errorIcon = new ImageIcon(this.getClass().getResource("messagedialog/error.gif"));
    Icon warningIcon = new ImageIcon(this.getClass().getResource("messagedialog/warn.gif"));
    Icon informIcon = new ImageIcon(this.getClass().getResource("messagedialog/inform.gif"));
    protected static LogMessageDialog aMessageDialog;
    JTextArea messageTextArea;
    JTextArea detailTextArea;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    int width = 450;
    int height_1 = 250;
    int height_2 = 450;

    protected LogMessageDialog() {
        this.jbInit();
    }

    protected LogMessageDialog(Frame parentFrame) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.jbInit();
    }

    public static LogMessageDialog getInstance(Frame parentFrame) {
        if (aMessageDialog == null) {
            aMessageDialog = new LogMessageDialog(parentFrame);
        }
        return aMessageDialog;
    }

    void jbInit() {
        this.scrollPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.mainPanel = new JPanel(new BorderLayout());
        this.detailTextPanel = new JPanel(new BorderLayout());
        this.messageTextArea = new JTextArea();
        this.detailTextArea = new JTextArea();
        this.iconPanel = new JPanel(new BorderLayout());
        this.iconLabel = new JLabel();
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setOpaque(false);
        this.detailTextArea.setEditable(false);
        this.detailTextArea.setOpaque(false);
        this.scrollPanel.setLayout(this.gridBagLayout1);
        this.iconPanel.add((Component)this.iconLabel, "North");
        this.iconPanel.setBorder(this.borderIconPanel);
        this.messageScrollPane = new JScrollPane(this.messageTextArea);
        this.messageScrollPane.setPreferredSize(new Dimension(250, 60));
        this.messagePanel = new JPanel(new BorderLayout());
        this.messagePanel.setBorder(this.messageBorder);
        this.messagePanel.add((Component)this.messageScrollPane, "Center");
        this.messageScrollPane.getViewport().add((Component)this.messageTextArea, null);
        this.okButton = new JButton();
        this.detailButton = new JButton();
        this.okButton.setText("Ok");
        this.okButton.addActionListener(this);
        this.detailButton.setText(this.detailsStr);
        this.detailButton.addActionListener(this);
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(this.detailButton);
        this.detailScrollPane = new JScrollPane(this.detailTextArea);
        this.detailScrollPane.setPreferredSize(new Dimension(250, 60));
        this.detailPanel = new JPanel(new BorderLayout());
        this.detailPanel.setBorder(this.detailsBorder);
        this.detailPanel.add((Component)this.detailScrollPane, "Center");
        this.detailScrollPane.getViewport().add((Component)this.detailTextArea, null);
        this.scrollPanel.add((Component)this.messagePanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.3, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.scrollPanel.add((Component)this.detailPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.7, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.scrollPanel, "Center");
        this.mainPanel.add((Component)this.buttonsPanel, "South");
        this.mainPanel.add((Component)this.iconPanel, "West");
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setWrapStyleWord(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.okButton) {
            this.okButton_actionPerformed();
        } else if (obj == this.detailButton) {
            this.detailButton_actionPerformed();
        }
    }

    void okButton_actionPerformed() {
        ((Component)this).setVisible(false);
    }

    void detailButton_actionPerformed() {
        String details = this.detailTextArea.getText();
        if (details.equals("")) {
            this.detailPanel.setVisible(true);
            this.detailScrollPane.setVisible(true);
            this.detailTextArea.setText(this.detail);
            this.detailButton.setText(this.noDetailsStr);
            ((Component)this).setSize(new Dimension(this.width, this.height_2));
        } else {
            this.detailPanel.setVisible(false);
            this.detailScrollPane.setVisible(false);
            this.detail = details;
            this.detailTextArea.setText("");
            this.detailButton.setText(this.detailsStr);
            ((Component)this).setSize(new Dimension(this.width, this.height_1));
        }
        this.detailTextArea.setEditable(false);
        this.messageScrollPane.validate();
        this.detailScrollPane.validate();
        this.validate();
        this.setLocationRelativeTo(this.parentFrame);
    }

    private void preShowDialog(String message, String detailFile, int type, boolean loadLogFile) {
        String detail = "";
        if (type == 0) {
            this.setTitle("Error");
            this.iconLabel.setIcon(this.errorIcon);
        } else if (type == 1) {
            this.setTitle("Warning");
            this.iconLabel.setIcon(this.warningIcon);
        } else if (type == 2) {
            this.setTitle("Information");
            this.iconLabel.setIcon(this.informIcon);
        }
        this.detailButton.setEnabled(true);
        if (detailFile != null) {
            detail = loadLogFile ? this.loadLogFile(detailFile) : detailFile;
        } else {
            this.detailButton.setEnabled(false);
        }
        this.detailTextArea.setText("");
        this.messageTextArea.setText(message);
        this.messageScrollPane.validate();
        this.detailScrollPane.validate();
        this.validate();
        if (detail != null && detail != "") {
            this.detailPanel.setVisible(false);
            this.detailScrollPane.setVisible(false);
            this.detailButton.setEnabled(true);
            this.detail = detail;
        } else {
            detail = null;
            this.detailPanel.setVisible(false);
            this.detailScrollPane.setVisible(false);
            this.detailButton.setEnabled(false);
        }
        ((Component)this).setSize(new Dimension(this.width, this.height_1));
        this.setLocationRelativeTo(this.parentFrame);
        this.detailButton.setText(this.detailsStr);
        this.messageTextArea.setEditable(false);
        this.detailTextArea.setEditable(false);
        ((Component)this).setVisible(true);
    }

    public void showErrorDialog(String message, String detailFile) {
        this.preShowDialog(message, detailFile, 0, true);
    }

    public void showErrorDialogNoLogFile(String message, String detailFile) {
        this.preShowDialog(message, detailFile, 0, false);
    }

    public void showWarningDialog(String message, String detailFile) {
        this.preShowDialog(message, detailFile, 1, true);
    }

    public void showWarningDialogNoLogFile(String message, String detailFile) {
        this.preShowDialog(message, detailFile, 1, false);
    }

    public void showInformDialog(String message, String detailFile) {
        this.preShowDialog(message, detailFile, 2, true);
    }

    public void showInformDialogNoLogFile(String message, String detailFile) {
        this.preShowDialog(message, detailFile, 2, false);
    }

    private String loadLogFile(String fileName) {
        String res = "";
        String line = null;
        if (!new File(fileName).exists()) {
            res = "Could not display log. Log file " + fileName + " not found.";
            return res;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
            line = reader.readLine();
            while (line != null) {
                res = res + line + "\n";
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return res;
    }

    public void lookAndFeelChanged() {
        SwingUtilities.updateComponentTreeUI(this);
    }
}

