/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui;

import com.sap.engine.gui.CLookAndFeelPanel;
import com.sap.engine.gui.LookAndFeelHandler;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CLookAndFeelManager
extends CLookAndFeelPanel {
    JDialog lfDialog;
    Frame parentFrame;
    static Hashtable lookAndFeels;

    public CLookAndFeelManager(Frame frame) {
        this.lfDialog = new JDialog(frame, "Choose Look And Feel", true);
        this.lfDialog.getContentPane().add((Component)this, "Center");
        ((Component)this.lfDialog).setSize(250, 150);
        this.lfDialog.addWindowListener(new WinHandler());
        this.parentFrame = frame;
    }

    public static void installDefaultLookAndFeel(String className, LookAndFeel defLF) {
        lookAndFeels.put(className, defLF);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Ok")) {
            int ind = this.lookfeelComboBox.getSelectedIndex();
            if (ind < 0) {
                this.resetComboBox();
            } else {
                try {
                    String lfClassName = this.lfInfo[ind].getClassName();
                    LookAndFeel lf = (LookAndFeel)lookAndFeels.get(lfClassName);
                    if (lf == null) {
                        lf = (LookAndFeel)Class.forName(lfClassName).newInstance();
                        lookAndFeels.put(lfClassName, lf);
                    }
                    UIManager.setLookAndFeel(lfClassName);
                    LookAndFeelHandler.fireLookAndFeelChanged();
                }
                catch (Exception ex) {
                    this.resetComboBox();
                }
            }
        } else if (cmd.equals("Cancel")) {
            this.resetComboBox();
        }
        this.lfDialog.dispose();
        if (cmd.equals("Ok")) {
            SwingUtilities.updateComponentTreeUI(this.lfDialog);
        }
    }

    public void chooseLookAndFeel() {
        this.lfDialog.setLocationRelativeTo(this.parentFrame);
        this.lfDialog.show();
    }

    static {
        try {
            lookAndFeels = new Hashtable();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class WinHandler
    extends WindowAdapter {
        WinHandler() {
        }

        public void windowClosing(WindowEvent e) {
            CLookAndFeelManager.this.resetComboBox();
            CLookAndFeelManager.this.lfDialog.dispose();
        }
    }
}

