/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.webapp.ddp;

import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.j2ee.core.utils.ddp.DdpDescriptor;
import com.tssap.j2ee.core.webapp.context.FilterContext;
import com.tssap.j2ee.core.webapp.context.ServletContext;
import com.tssap.j2ee.internal.core.util.DomUtils;
import com.tssap.j2ee.internal.core.webapp.WebAppChildOrder;
import java.util.List;
import org.w3c.dom.Element;

public class IpDdpExecutive
implements DdpDescriptor.Executive {
    public static final String DEFAULT_VALUE = "";

    public void apply(Object entity, Object value, DdpDescriptor descriptor) {
        String[] childOrder;
        Element host;
        Object source;
        ServletContext context;
        if (entity instanceof ServletContext) {
            context = (ServletContext)entity;
            source = context.getSource();
            if (!(source instanceof Element)) {
                return;
            }
            host = (Element)source;
            childOrder = WebAppChildOrder.SERVLET;
        } else if (entity instanceof FilterContext) {
            context = (FilterContext)entity;
            source = context.getSource();
            if (!(source instanceof Element)) {
                return;
            }
            host = (Element)source;
            childOrder = WebAppChildOrder.FILTER;
        } else {
            return;
        }
        DomUtils.removeChildNodes((Element)host, (String)"init-param");
        if (!(value instanceof List)) {
            return;
        }
        List params = (List)value;
        int i = params.size() - 1;
        while (i >= 0) {
            StringArrayList param = (StringArrayList)params.get(i);
            if (!param.isEmpty()) {
                String paramName = param.getString(0);
                String paramDescription = null;
                if (param.size() > 1) {
                    paramDescription = param.getString(1);
                }
                String paramValue = null;
                if (param.size() > 2) {
                    paramValue = param.getString(2);
                }
                if (paramValue == null) {
                    paramValue = DEFAULT_VALUE;
                }
                this.createIp(host, childOrder, paramName, paramValue, paramDescription);
            }
            --i;
        }
    }

    private Element createIp(Element host, String[] childOrder, String name, String value, String description) {
        Element ip = DomUtils.createChildElement((Element)host, (String[])childOrder, (String)"init-param");
        DomUtils.setChildTextNodeValue((Element)ip, (String[])WebAppChildOrder.INIT_PARAM, (String)"param-name", (String)name);
        DomUtils.setChildTextNodeValue((Element)ip, (String[])WebAppChildOrder.INIT_PARAM, (String)"param-value", (String)value);
        if (description != null) {
            DomUtils.setChildTextNodeValue((Element)ip, (String[])WebAppChildOrder.INIT_PARAM, (String)"description", (String)description);
        }
        return ip;
    }
}

