/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.webapp;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.webapp.WebAppMetaInfo;
import com.tssap.j2ee.core.webapp.WebResourceCollection;
import com.tssap.j2ee.internal.core.descriptor.DescribedDescriptorEntityImpl;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import com.tssap.j2ee.internal.core.webapp.SecurityConstraintImpl;
import com.tssap.j2ee.internal.core.webapp.WebAppChildOrder;
import java.util.ArrayList;
import org.w3c.dom.Element;

final class WebResourceCollectionImpl
extends DescribedDescriptorEntityImpl
implements WebResourceCollection {
    public WebResourceCollectionImpl(SecurityConstraintImpl parent, Element element) {
        super((DescriptorEntityImpl)parent, element);
    }

    public String toString() {
        return "WebResourceCollection \"" + this.getName() + "\"";
    }

    public void delete() {
        if (!this.edit(null)) {
            return;
        }
        final String oldName = this.getName();
        this.modify(new Runnable(){

            public void run() {
                WebResourceCollectionImpl.super.delete();
                WebResourceCollectionImpl.this.getSecurityConstraintImpl().updateWebResourceCollection(oldName);
            }
        });
    }

    public String getName() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"web-resource-name");
    }

    public boolean canSetName(String name) {
        if (DescriptorEntityImpl.isNull((String)name)) {
            return false;
        }
        if (name.equals(this.getName())) {
            return true;
        }
        return this.getSecurityConstraintImpl().getWebResourceCollection(name) == null;
    }

    public void setName(String name) {
        if (!this.canSetName(name)) {
            throw new IllegalArgumentException(name);
        }
        String oldName = this.getName();
        if (DescriptorEntityImpl.equals((Object)oldName, (Object)name)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])WebAppChildOrder.WEB_RESOURCE_COLLECTION, (String)"web-resource-name", (String)name);
        this.getSecurityConstraintImpl().updateWebResourceCollection(oldName);
        this.changed((DescriptorEntity)this);
    }

    public String[] getUrlPatterns() {
        Element[] patterns = DomUtils.getChildElements((Element)this.getElement(), (String)"url-pattern");
        if (patterns == null || patterns.length == 0) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>(patterns.length);
        int i = 0;
        while (i < patterns.length) {
            String value = DomUtils.getTextNodeValue((Element)patterns[i]);
            if (!DescriptorEntityImpl.isNull((String)value)) {
                values.add(value);
            }
            ++i;
        }
        return values.toArray(new String[values.size()]);
    }

    public boolean canSetUrlPatterns(String[] patterns) {
        if (patterns == null) {
            return true;
        }
        int i = 0;
        while (i < patterns.length) {
            if (DescriptorEntityImpl.isNull((String)patterns[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setUrlPatterns(String[] patterns) {
        if (!this.canSetUrlPatterns(patterns)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.removeChildNodes((Element)this.getElement(), (String)"url-pattern");
        if (patterns != null) {
            int i = 0;
            while (i < patterns.length) {
                DomUtils.createChildTextNode((Element)this.getElement(), (String[])WebAppChildOrder.WEB_RESOURCE_COLLECTION, (String)"url-pattern").setNodeValue(patterns[i]);
                ++i;
            }
        }
        this.changed((DescriptorEntity)this);
    }

    public String[] getHttpMethods() {
        Element[] methods = DomUtils.getChildElements((Element)this.getElement(), (String)"http-method");
        if (methods == null || methods.length == 0) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>(methods.length);
        int i = 0;
        while (i < methods.length) {
            String value = DomUtils.getTextNodeValue((Element)methods[i]);
            if (!DescriptorEntityImpl.isNull((String)value)) {
                values.add(value);
            }
            ++i;
        }
        return values.toArray(new String[values.size()]);
    }

    public boolean canSetHttpMethods(String[] methods) {
        if (methods == null) {
            return true;
        }
        int i = 0;
        while (i < methods.length) {
            String method = methods[i];
            if (DescriptorEntityImpl.isNull((String)method) || !WebAppMetaInfo.isValidHttpMethod((String)method)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setHttpMethods(String[] methods) {
        if (!this.canSetHttpMethods(methods)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.removeChildNodes((Element)this.getElement(), (String)"http-method");
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                DomUtils.createChildTextNode((Element)this.getElement(), (String[])WebAppChildOrder.WEB_RESOURCE_COLLECTION, (String)"http-method").setNodeValue(methods[i]);
                ++i;
            }
        }
        this.changed((DescriptorEntity)this);
    }

    protected String[] getChildOrder() {
        return WebAppChildOrder.WEB_RESOURCE_COLLECTION;
    }

    private SecurityConstraintImpl getSecurityConstraintImpl() {
        return (SecurityConstraintImpl)this.getParent();
    }
}

