/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.webapp;

import com.tssap.j2ee.core.descriptor.DescriptorDocument;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.utils.ReadOnlinessValidator;
import com.tssap.j2ee.core.web.IFilter;
import com.tssap.j2ee.core.web.IJSP;
import com.tssap.j2ee.core.web.IServlet;
import com.tssap.j2ee.core.web.ISourceWebElement;
import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.core.web.IWebElementAcceptor;
import com.tssap.j2ee.core.web.IWebElementDelta;
import com.tssap.j2ee.core.web.IWebListener;
import com.tssap.j2ee.core.web.IWebModelListener;
import com.tssap.j2ee.core.web.WebModelChangedEvent;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.j2ee.core.webapp.AssembledInfoFinder;
import com.tssap.j2ee.core.webapp.ClassReferencer;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class WebModelSynchronizer
implements IWebModelListener,
IResourceChangeListener {
    private HashMap myAddedToRemovedPaths;
    private HashSet myRemovedPaths;
    private boolean myUpdateCommandPending;
    private static final String JSP_FILE_EXTENSION = "jsp";

    public WebModelSynchronizer() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            try {
                if (this.myAddedToRemovedPaths == null) {
                    this.myAddedToRemovedPaths = new HashMap();
                }
                if (this.myRemovedPaths == null) {
                    this.myRemovedPaths = new HashSet();
                }
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        return WebModelSynchronizer.this.visitResourceDelta(delta);
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (this.myAddedToRemovedPaths.size() + this.myRemovedPaths.size() > 0 && !this.myUpdateCommandPending) {
                this.myUpdateCommandPending = true;
                ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

                    public void run() {
                        WebModelSynchronizer webModelSynchronizer = WebModelSynchronizer.this;
                        synchronized (webModelSynchronizer) {
                            WebModelSynchronizer.this.renameProcessedJSPs();
                            WebModelSynchronizer.this.removeProcessedJSPs();
                            WebModelSynchronizer.this.myAddedToRemovedPaths = null;
                            WebModelSynchronizer.this.myRemovedPaths = null;
                            WebModelSynchronizer.this.myUpdateCommandPending = false;
                        }
                    }
                });
            }
        }
    }

    private boolean visitResourceDelta(IResourceDelta delta) {
        IResource changedResource = delta.getResource();
        IPath resourcePath = changedResource.getProjectRelativePath();
        switch (changedResource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                return WebProject.getInstance((IProject)changedResource.getProject()) != null;
            }
            case 2: {
                if (!"webContent".equals(resourcePath.segment(0))) {
                    return false;
                }
                switch (delta.getKind()) {
                    case 1: {
                        return false;
                    }
                    case 2: {
                        if ((delta.getFlags() & 0x2000) != 0) {
                            this.processMovedResource(delta);
                            return false;
                        }
                        return true;
                    }
                    case 4: {
                        return true;
                    }
                }
                return false;
            }
            case 1: {
                if (!"webContent".equals(resourcePath.segment(0))) {
                    return false;
                }
                if (!JSP_FILE_EXTENSION.equals(changedResource.getFileExtension())) {
                    return false;
                }
                switch (delta.getKind()) {
                    case 1: 
                    case 4: {
                        return false;
                    }
                    case 2: {
                        if ((delta.getFlags() & 0x2000) != 0) {
                            this.processMovedResource(delta);
                            break;
                        }
                        this.processDeletedResources(delta);
                    }
                }
                return false;
            }
        }
        return false;
    }

    private void processMovedResource(IResourceDelta movedDelta) {
        IResource removedPart = movedDelta.getResource();
        IResource addedPart = removedPart.getWorkspace().getRoot().findMember(movedDelta.getMovedToPath());
        if (addedPart == null || removedPart.getType() != addedPart.getType()) {
            return;
        }
        try {
            MovedJSPCollector collector = new MovedJSPCollector(addedPart, removedPart);
            addedPart.accept((IResourceVisitor)collector);
            this.myAddedToRemovedPaths.putAll(collector.getAddedToRemovedPaths());
        }
        catch (CoreException e) {
            e.printStackTrace();
            return;
        }
    }

    private void processDeletedResources(IResourceDelta removedDelta) {
        IResource removed = removedDelta.getResource();
        this.myRemovedPaths.add(removed.getFullPath());
    }

    private void removeProcessedJSPs() {
        Iterator it = this.myRemovedPaths.iterator();
        while (it.hasNext()) {
            IPath next = (IPath)it.next();
            Servlet[] jsps = AssembledInfoFinder.findAssembledJSPs((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile(next));
            if (jsps == null || !this.validateEdit((DescriptorEntity[])jsps)) continue;
            int i = 0;
            while (i < jsps.length) {
                jsps[i].delete();
                ++i;
            }
        }
    }

    private void renameProcessedJSPs() {
        Iterator it = this.myAddedToRemovedPaths.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            IPath added = (IPath)next.getKey();
            IPath removed = (IPath)next.getValue();
            Servlet[] jsps = AssembledInfoFinder.findAssembledJSPs((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile(removed));
            this.rename(jsps, ResourcesPlugin.getWorkspace().getRoot().getFile(added));
        }
    }

    public void webModelChanged(final WebModelChangedEvent evt) {
        ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

            public void run() {
                WebModelSynchronizer.this.process(evt.getDelta());
            }
        });
    }

    private void process(IWebElementDelta delta) {
        this.processRenamed(delta.getRenamedElements());
        if (delta.getProject().getProject().isAccessible()) {
            this.processRemoved(delta.getRemovedElements());
        }
    }

    private void processRenamed(IWebElement[][] renamed) {
        int i = 0;
        while (i < renamed[0].length) {
            IWebElement removed = renamed[0][i];
            IWebElement added = renamed[1][i];
            this.rename(removed, added);
            ++i;
        }
    }

    private void rename(IWebElement removed, final IWebElement added) {
        removed.dispatch((IWebElementAcceptor)new IWebElementAcceptor.Stub(){

            public void consider(IFilter filter) {
                WebModelSynchronizer.this.rename((ClassReferencer[])AssembledInfoFinder.findAssembledFilters((IFilter)filter, (boolean)true), (ISourceWebElement)added);
            }

            public void consider(IWebListener listener) {
                WebModelSynchronizer.this.rename((ClassReferencer[])AssembledInfoFinder.findAssembledListeners((IWebListener)listener, (boolean)true), (ISourceWebElement)added);
            }

            public void consider(IServlet servlet) {
                WebModelSynchronizer.this.rename(AssembledInfoFinder.findAssembledServlets((IServlet)servlet, (boolean)true), (IServlet)added);
            }

            public void consider(IJSP jsp) {
            }
        });
    }

    private void rename(ClassReferencer[] filtersOrListeners, ISourceWebElement added) {
        if (filtersOrListeners == null || !this.validateEdit((DescriptorEntity[])filtersOrListeners)) {
            return;
        }
        int i = 0;
        while (i < filtersOrListeners.length) {
            if (filtersOrListeners[i].canSetClassName(added.getTypeName())) {
                filtersOrListeners[i].setClassName(added.getTypeName());
            }
            ++i;
        }
    }

    private void rename(Servlet[] servlets, IServlet added) {
        if (servlets == null || !this.validateEdit((DescriptorEntity[])servlets)) {
            return;
        }
        int i = 0;
        while (i < servlets.length) {
            if (servlets[i].canSetSource(added.getTypeName(), null)) {
                servlets[i].setSource(added.getTypeName(), null);
            }
            ++i;
        }
    }

    private void rename(Servlet[] servlets, IFile added) {
        if (servlets == null || !this.validateEdit((DescriptorEntity[])servlets)) {
            return;
        }
        int i = 0;
        while (i < servlets.length) {
            if (servlets[i].canSetSource(null, added.getProjectRelativePath().toString())) {
                servlets[i].setSource(null, added.getProjectRelativePath().toString());
            }
            ++i;
        }
    }

    private void processRemoved(IWebElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            IWebElement next = elements[i];
            DescriptorEntity[] assembledElements = AssembledInfoFinder.findAssembledWebObjects((IWebElement)next, (boolean)true);
            if (assembledElements != null && this.validateEdit(assembledElements)) {
                int j = 0;
                while (j < assembledElements.length) {
                    assembledElements[j].delete();
                    ++j;
                }
            }
            ++i;
        }
    }

    private boolean validateEdit(DescriptorEntity[] entities) {
        if (entities == null || entities.length == 0) {
            return true;
        }
        HashSet<IFile> resources = new HashSet<IFile>();
        int i = 0;
        while (i < entities.length) {
            resources.add(entities[i].getDocument().getFile());
            ++i;
        }
        IFile[] files = ((AbstractCollection)resources).toArray(new IFile[resources.size()]);
        if (!new ReadOnlinessValidator(files).canModify()) {
            return false;
        }
        return WebModelSynchronizer.ensureAllSaved(entities);
    }

    private static boolean ensureAllSaved(DescriptorEntity[] entities) {
        HashSet<DescriptorDocument> allDescriptors = new HashSet<DescriptorDocument>();
        int i = 0;
        while (i < entities.length) {
            allDescriptors.add(entities[i].getDocument());
            ++i;
        }
        Iterator it = allDescriptors.iterator();
        while (it.hasNext()) {
            DescriptorDocument element = (DescriptorDocument)it.next();
            if (element.ensureSaved(false)) continue;
            return false;
        }
        return true;
    }

    private static class MovedJSPCollector
    implements IResourceVisitor {
        private HashMap myAddedJSPPathsToRemovedPaths = new HashMap();
        private IPath myAddedPart;
        private IPath myRemovedPart;

        public MovedJSPCollector(IResource addedPart, IResource removedPart) {
            this.myAddedPart = addedPart.getFullPath();
            this.myRemovedPart = removedPart.getFullPath();
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource == null) {
                return false;
            }
            if (resource.getType() == 2) {
                return true;
            }
            if (!WebModelSynchronizer.JSP_FILE_EXTENSION.equals(resource.getFileExtension())) {
                return false;
            }
            IPath fullPath = resource.getFullPath();
            if (this.myAddedPart.isPrefixOf(fullPath)) {
                int matchingSegments = fullPath.matchingFirstSegments(this.myAddedPart);
                this.myAddedJSPPathsToRemovedPaths.put(fullPath, this.myRemovedPart.append(fullPath.removeFirstSegments(matchingSegments)));
            }
            return false;
        }

        public HashMap getAddedToRemovedPaths() {
            return this.myAddedJSPPathsToRemovedPaths;
        }
    }
}

