/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.webapp;

import com.tssap.j2ee.core.descriptor.DescriptorDeltaListener;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.utils.FileUtils;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.WebAppProject;
import com.tssap.j2ee.internal.core.webapp.WebAppImpl;
import com.tssap.j2ee.internal.core.webapp.WebAppImplPlugin;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.util.UpdateCommand;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;

public final class WebAppProjectImpl
extends WebAppProject {
    private Map myWebApps = new HashMap();
    private IResourceChangeListener myResourceChangeListener;
    private IResourceDeltaVisitor myResourceDeltaVisitor;
    private static final String TEMPLATE_PATH = "templates/web.xml";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String WEB_APP_DTD = "<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\">";
    private static final String DEFAULT_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\"><web-app></web-app>";
    private static String ourTemplate;

    public void setProject(IProject project) {
        super.setProject(project);
        this.myWebApps.clear();
        String fixedLocation = WebAppProjectImpl.getFixedLocation();
        WebAppImplPlugin.logInfo("Fixed location [" + fixedLocation + "]");
        if (fixedLocation != null) {
            IFile file = project.getFile(fixedLocation);
            if (file.exists()) {
                WebAppImplPlugin.logInfo("Fixed descriptor file found [" + file.getFullPath() + "]");
                this.addWebApp(file);
            }
        } else {
            try {
                IJavaProject javaProject = this.getJavaProject();
                final IPath output = javaProject == null ? null : javaProject.getOutputLocation();
                project.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) {
                        IFolder folder;
                        if (!resource.isAccessible()) {
                            return false;
                        }
                        if (resource instanceof IFolder && output != null && output.equals((Object)(folder = (IFolder)resource).getFullPath())) {
                            return false;
                        }
                        if (resource instanceof IFile && "web.xml".equals(resource.getName())) {
                            WebAppImplPlugin.logInfo("Descriptor file found [" + resource.getFullPath() + "]");
                            WebAppProjectImpl.this.addWebApp((IFile)resource);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException ce) {
                WebAppImplPlugin.logError("Exception while reading descriptor files in the project [" + project + "]", ce);
            }
        }
    }

    protected WebApp addWebApp(IFile file) {
        WebAppImpl webApp = (WebAppImpl)((Object)this.myWebApps.remove(WebAppProjectImpl.getLocation(file)));
        if (!file.isAccessible()) {
            return null;
        }
        if (webApp == null) {
            webApp = new WebAppImpl(file, this);
        } else {
            webApp.reload();
        }
        this.myWebApps.put(WebAppProjectImpl.getLocation(file), webApp);
        return webApp;
    }

    public WebApp getWebApp(IFile file) {
        WebAppImpl webApp = (WebAppImpl)((Object)this.myWebApps.get(WebAppProjectImpl.getLocation(file)));
        if (webApp == null) {
            return null;
        }
        if (webApp.isFileModified()) {
            webApp = (WebAppImpl)this.addWebApp(file);
        }
        return webApp;
    }

    public WebApp[] getWebApps() {
        if (this.myWebApps.isEmpty()) {
            return null;
        }
        ArrayList webApps = new ArrayList(this.myWebApps.values());
        int i = webApps.size() - 1;
        while (i >= 0) {
            WebAppImpl webApp = (WebAppImpl)((Object)webApps.get(i));
            if (webApp.isFileModified()) {
                this.addWebApp(webApp.getFile());
            }
            --i;
        }
        webApps = new ArrayList(this.myWebApps.values());
        return webApps.toArray(new WebApp[webApps.size()]);
    }

    public boolean canCreateWebApp(IFile file) {
        if (file.exists()) {
            return false;
        }
        IContainer folder = file.getParent();
        if (!folder.isAccessible() || folder.isReadOnly()) {
            return false;
        }
        WebApp webApp = this.getWebApp(file);
        return webApp == null;
    }

    public WebApp createWebApp(IFile file) {
        if (!this.canCreateWebApp(file)) {
            throw new IllegalArgumentException();
        }
        ByteArrayInputStream source = new ByteArrayInputStream(this.getTemplate().getBytes());
        try {
            file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            WebAppImplPlugin.logError("Unable to create file [" + file + "]", ce);
            return null;
        }
        return this.addWebApp(file);
    }

    public WebProject[] getReferencedWebProjects() {
        ArrayList webProjects = new ArrayList();
        this.addWebProject(this.getProject(), webProjects);
        try {
            IProject[] projects = this.getProject().getReferencedProjects();
            if (projects != null && projects.length > 0) {
                int i = 0;
                while (i < projects.length) {
                    this.addWebProject(projects[i], webProjects);
                    ++i;
                }
            }
        }
        catch (CoreException ce) {
            WebAppImplPlugin.logError("Unable to retrieve referenced projects", ce);
        }
        return webProjects.toArray(new WebProject[webProjects.size()]);
    }

    protected void addWebProject(IProject project, Collection webProjects) {
        if (project == null || !project.isAccessible()) {
            return;
        }
        try {
            WebProject webProject;
            if (project.hasNature("com.tssap.j2ee.core.web.webNature") && (webProject = WebProject.getInstance((IProject)project)) != null) {
                webProjects.add(webProject);
            }
        }
        catch (CoreException ce) {
            WebAppImplPlugin.logError("Unable to retrieve referenced web project for the [" + project + "]", ce);
        }
    }

    public void addDescriptorDeltaListener(DescriptorDeltaListener listener) {
        super.addDescriptorDeltaListener(listener);
        this.registerResourceChangeListener();
    }

    public void removeDescriptorDeltaListener(DescriptorDeltaListener listener) {
        super.removeDescriptorDeltaListener(listener);
        if (!this.hasDescriptorDeltaListeners()) {
            this.unregisterResourceChangeListener();
            this.myResourceChangeListener = null;
        }
    }

    private void fileAdded(IFile file) {
        WebApp webApp = this.addWebApp(file);
        if (webApp != null) {
            WebAppImplPlugin.logInfo("Descriptor added [" + file + "]");
            this.descriptorEntityAdded((DescriptorEntity)webApp);
            this.clearDescriptorDeltaFired();
        }
    }

    private void fileRemoved(IFile file) {
        WebApp cachedWebApp = (WebApp)this.myWebApps.remove(WebAppProjectImpl.getLocation(file));
        if (cachedWebApp != null) {
            WebAppImplPlugin.logInfo("Descriptor removed [" + file + "]");
            this.descriptorEntityRemoved((DescriptorEntity)cachedWebApp);
            this.clearDescriptorDeltaFired();
        }
    }

    private void fileChanged(IFile file) {
        WebApp cachedWebApp = this.getWebApp(file);
        WebApp webApp = this.addWebApp(file);
        if (cachedWebApp != null) {
            if (webApp != null) {
                WebAppImplPlugin.logInfo("Descriptor changed [" + file + "]");
                this.descriptorEntityTotallyChanged((DescriptorEntity)webApp);
                this.clearDescriptorDeltaFired();
            } else {
                WebAppImplPlugin.logInfo("Descriptor removed [" + file + "], it became invalid");
                this.descriptorEntityRemoved((DescriptorEntity)cachedWebApp);
                this.clearDescriptorDeltaFired();
            }
        } else if (webApp != null) {
            WebAppImplPlugin.logInfo("Descriptor added [" + file + "], it was invalid before");
            this.descriptorEntityAdded((DescriptorEntity)webApp);
            this.clearDescriptorDeltaFired();
        }
    }

    private void registerResourceChangeListener() {
        this.myResourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IProject project = WebAppProjectImpl.this.getProject();
                if (project == null || !project.isAccessible()) {
                    return;
                }
                if (1 == event.getType()) {
                    try {
                        if (WebAppProjectImpl.this.myResourceDeltaVisitor == null) {
                            WebAppProjectImpl.this.myResourceDeltaVisitor = new WebAppResourceDeltaVisitor();
                            WebAppImplPlugin.logInfo("Resource delta visitor instantiated");
                        }
                        event.getDelta().accept(WebAppProjectImpl.this.myResourceDeltaVisitor);
                    }
                    catch (CoreException ce) {
                        WebAppImplPlugin.logError("Exception while processing resource delta", ce);
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.myResourceChangeListener);
        WebAppImplPlugin.logInfo("Resource delta listener registered");
    }

    private void unregisterResourceChangeListener() {
        if (this.myResourceChangeListener == null) {
            return;
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.myResourceChangeListener);
        WebAppImplPlugin.logInfo("Resource delta listener unregistered");
    }

    private static String getLocation(IFile file) {
        return file.getProjectRelativePath().toString();
    }

    protected String getTemplate() {
        if (ourTemplate == null) {
            ourTemplate = FileUtils.getFileContents((String)TEMPLATE_PATH, (String)DEFAULT_TEMPLATE, (Plugin)WebAppImplPlugin.getDefault());
        }
        return ourTemplate;
    }

    public static String getFixedLocation() {
        WebAppImplPlugin plugin = WebAppImplPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        String key = plugin.getDescriptor().getUniqueIdentifier() + "/fixed";
        String value = Platform.getDebugOption((String)key);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        if ("web.xml".equals(value)) {
            return "web.xml";
        }
        if (!value.endsWith("/web.xml") && !value.endsWith("\\web.xml")) {
            return null;
        }
        return value;
    }

    protected String[] getRequiredLibraries() {
        return new String[0];
    }

    static /* synthetic */ void access$500(WebAppProjectImpl x0, IFile x1) {
        x0.fileAdded(x1);
    }

    static /* synthetic */ void access$600(WebAppProjectImpl x0, IFile x1) {
        x0.fileChanged(x1);
    }

    static /* synthetic */ void access$700(WebAppProjectImpl x0, IFile x1) {
        x0.fileRemoved(x1);
    }

    private class WebAppResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private final String myFixedLocation = WebAppProjectImpl.getFixedLocation();

        private WebAppResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource instanceof IWorkspaceRoot) {
                return true;
            }
            if (!WebAppProjectImpl.this.getProject().equals((Object)resource.getProject())) {
                return false;
            }
            if (this.myFixedLocation != null) {
                if (!(resource instanceof IFile)) {
                    return true;
                }
                IFile file = (IFile)resource;
                if (this.myFixedLocation.equals(file.getProjectRelativePath().toString())) {
                    this.process(delta);
                }
            } else {
                try {
                    IFolder folder;
                    IPath output;
                    IJavaProject javaProject = WebAppProjectImpl.this.getJavaProject();
                    IPath iPath = output = javaProject == null ? null : javaProject.getOutputLocation();
                    if (resource instanceof IFolder && output != null && output.equals((Object)(folder = (IFolder)resource).getFullPath())) {
                        return false;
                    }
                }
                catch (CoreException ce) {
                    return false;
                }
                if (!(resource instanceof IFile)) {
                    return true;
                }
                IFile file = (IFile)resource;
                if (!"web.xml".equals(file.getName())) {
                    return true;
                }
                this.process(delta);
            }
            return true;
        }

        private void process(IResourceDelta delta) {
            if (WebAppProjectImpl.super.isDescriptorDeltaFired()) {
                WebAppProjectImpl.super.clearDescriptorDeltaFired();
                return;
            }
            int kind = delta.getKind();
            IFile file = (IFile)delta.getResource();
            ModelAccess.runCommandLater((Runnable)new UpdateCommand(this, kind, file){
                private final /* synthetic */ int val$kind;
                private final /* synthetic */ IFile val$file;
                private final /* synthetic */ WebAppResourceDeltaVisitor this$1;
                {
                    this.this$1 = this$1;
                    this.val$kind = val$kind;
                    this.val$file = val$file;
                }

                public void run() {
                    if ((this.val$kind & 1) > 0) {
                        WebAppProjectImpl.access$500(WebAppResourceDeltaVisitor.access$400(this.this$1), this.val$file);
                    } else if ((this.val$kind & 4) > 0) {
                        WebAppProjectImpl.access$600(WebAppResourceDeltaVisitor.access$400(this.this$1), this.val$file);
                    } else if ((this.val$kind & 2) > 0) {
                        WebAppProjectImpl.access$700(WebAppResourceDeltaVisitor.access$400(this.this$1), this.val$file);
                    }
                }
            });
        }

        static /* synthetic */ WebAppProjectImpl access$400(WebAppResourceDeltaVisitor x0) {
            return x0.WebAppProjectImpl.this;
        }
    }
}

