/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.webapp;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class WebAppImplPlugin
extends Plugin {
    public static final String WCPRP_PROPERTY = "wcprp";
    public static final String JSP_PREFIX = "/";
    private boolean myTracing;
    private boolean myDebuggingDelta;
    private String myWebContent;
    private static WebAppImplPlugin ourInstance;

    public WebAppImplPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourInstance = this;
        this.myTracing = UtilsPlugin.getTraceDebugOption((IPluginDescriptor)descriptor);
        this.myDebuggingDelta = UtilsPlugin.getDeltaDebugOption((IPluginDescriptor)descriptor);
        this.myWebContent = UtilsPlugin.getProperty((IPluginDescriptor)this.getDescriptor(), (String)WCPRP_PROPERTY);
        if (this.myWebContent != null) {
            this.myWebContent = this.myWebContent.trim();
            if (this.myWebContent.length() == 0) {
                this.myWebContent = null;
            } else if (this.myWebContent.startsWith(JSP_PREFIX) || this.myWebContent.endsWith(JSP_PREFIX)) {
                WebAppImplPlugin.logError("Invalid web content folder specified (it can't start or end with '/' symbol)");
                this.myWebContent = null;
            }
        }
    }

    public static WebAppImplPlugin getDefault() {
        return ourInstance;
    }

    String getWebContent() {
        return this.myWebContent;
    }

    public boolean isTracing() {
        return this.myTracing;
    }

    public boolean isDebuggingDelta() {
        return this.myDebuggingDelta;
    }

    public static void logInfo(String text) {
        WebAppImplPlugin instance = WebAppImplPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        WebAppImplPlugin.log(1, text);
    }

    public static void logError(String text) {
        WebAppImplPlugin.log(4, text);
    }

    public static void logError(String text, Throwable cause) {
        WebAppImplPlugin.log(4, text, cause);
    }

    public static void logWarning(String text) {
        WebAppImplPlugin.log(2, text);
    }

    public static void logWarning(String text, Throwable cause) {
        WebAppImplPlugin.log(2, text, cause);
    }

    protected static void log(int type, String text) {
        WebAppImplPlugin instance = WebAppImplPlugin.getDefault();
        if (instance != null && instance.isTracing()) {
            WebAppImplPlugin.log(type, text, new Throwable());
        } else {
            WebAppImplPlugin.log(type, text, null);
        }
    }

    protected static void log(int type, String text, Throwable cause) {
        WebAppImplPlugin instance = WebAppImplPlugin.getDefault();
        if (instance == null) {
            System.err.println(text);
            if (cause != null) {
                cause.printStackTrace(System.err);
            }
        } else {
            String id = instance.getDescriptor().getUniqueIdentifier();
            Status status = new Status(type, id, 0, text, cause);
            instance.getLog().log((IStatus)status);
        }
    }
}

