/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.webapp;

import com.tssap.j2ee.core.descriptor.DescriptorDeltaListener;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.Environment;
import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.descriptor.UserInterface;
import com.tssap.j2ee.core.utils.FileUtils;
import com.tssap.j2ee.core.web.IFilter;
import com.tssap.j2ee.core.web.IHttpSessionAttributeListener;
import com.tssap.j2ee.core.web.IJSP;
import com.tssap.j2ee.core.web.IServlet;
import com.tssap.j2ee.core.web.IWebListener;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.j2ee.core.webapp.ContextParameter;
import com.tssap.j2ee.core.webapp.ErrorPage;
import com.tssap.j2ee.core.webapp.Filter;
import com.tssap.j2ee.core.webapp.FilterMapping;
import com.tssap.j2ee.core.webapp.Listener;
import com.tssap.j2ee.core.webapp.LoginConfig;
import com.tssap.j2ee.core.webapp.MimeMapping;
import com.tssap.j2ee.core.webapp.SecurityConstraint;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.core.webapp.ServletMapping;
import com.tssap.j2ee.core.webapp.TagLibrary;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.WebAppMetaInfo;
import com.tssap.j2ee.core.webapp.WebAppProject;
import com.tssap.j2ee.core.webapp.context.FilterContext;
import com.tssap.j2ee.core.webapp.context.ServletContext;
import com.tssap.j2ee.internal.core.descriptor.DescriptorDocumentImpl;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import com.tssap.j2ee.internal.core.webapp.ContextParameterImpl;
import com.tssap.j2ee.internal.core.webapp.ErrorPageImpl;
import com.tssap.j2ee.internal.core.webapp.FilterImpl;
import com.tssap.j2ee.internal.core.webapp.FilterMappingImpl;
import com.tssap.j2ee.internal.core.webapp.ListenerImpl;
import com.tssap.j2ee.internal.core.webapp.LoginConfigImpl;
import com.tssap.j2ee.internal.core.webapp.MimeMappingImpl;
import com.tssap.j2ee.internal.core.webapp.SecurityConstraintImpl;
import com.tssap.j2ee.internal.core.webapp.SecurityRoleImpl;
import com.tssap.j2ee.internal.core.webapp.ServletImpl;
import com.tssap.j2ee.internal.core.webapp.ServletMappingImpl;
import com.tssap.j2ee.internal.core.webapp.TagLibraryImpl;
import com.tssap.j2ee.internal.core.webapp.UserInterfaceImpl;
import com.tssap.j2ee.internal.core.webapp.WebAppChildOrder;
import com.tssap.j2ee.internal.core.webapp.WebAppEnvironmentImpl;
import com.tssap.j2ee.internal.core.webapp.WebAppImplPlugin;
import com.tssap.j2ee.internal.core.webapp.WebAppProjectImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.w3c.dom.Element;

final class WebAppImpl
extends DescriptorDocumentImpl
implements WebApp {
    public static final String PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    public static final String SYSTEM_ID = "http://java.sun.com/dtd/web-app_2_3.dtd";
    private static final String DTD_PATH = "templates/web-app_2_3.dtd";
    private static String ourDtd;
    private WebAppProjectImpl myProject;
    private UserInterface myUserInterface;
    private LoginConfig myLoginConfig;
    private Environment myEnvironment;
    private Map myListeners;
    private Map myFilters;
    private Map myServlets;
    private Map myTagLibraries;
    private List myWelcomeFiles;
    private Map myErrorPages;
    private Map myMimeMappings;
    private Map myContextParameters;
    private Map mySecurityRoles;
    private Map mySecurityConstraints;
    private List myFilterMappings;
    private List myServletMappings;

    public WebAppImpl(IFile file, WebAppProjectImpl project) {
        super(file, (DescriptorDeltaListener)project);
        this.myProject = project;
        if (this.isRecognized()) {
            this.myUserInterface = new UserInterfaceImpl((DescriptorEntityImpl)this, this.getElement(), WebAppChildOrder.WEB_APP, "web-app");
            this.myLoginConfig = new LoginConfigImpl(this, this.getElement());
            this.myEnvironment = new WebAppEnvironmentImpl(this, this.getElement());
        }
    }

    public String toString() {
        return "WebApp \"" + this.getFile().getProjectRelativePath().toString() + "\"";
    }

    public void delete() {
        try {
            this.getFile().delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            WebAppImplPlugin.logError("Unable to delete file " + this.getFile(), ce);
        }
    }

    public String getSpecVersion() {
        return "2.3";
    }

    public UserInterface getUserInterface() {
        return this.myUserInterface;
    }

    public String getDescription() {
        if (!this.isRecognized()) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"description");
    }

    public boolean canSetDescription(String description) {
        return this.isRecognized();
    }

    public void setDescription(String description) {
        if (!this.canSetDescription(description)) {
            throw new IllegalArgumentException(description);
        }
        if (DescriptorEntityImpl.equals((Object)this.getDescription(), (Object)description)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"description", (String)description);
        this.changed((DescriptorEntity)this);
    }

    public boolean isDistributable() {
        if (!this.isRecognized()) {
            return false;
        }
        return DomUtils.getChildElement((Element)this.getElement(), (String)"distributable") != null;
    }

    public void setDistributable(boolean distributable) {
        if (!this.isRecognized()) {
            return;
        }
        if (DescriptorEntityImpl.equals((boolean)this.isDistributable(), (boolean)distributable)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        if (distributable) {
            DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"distributable");
        } else {
            DomUtils.removeChildNodes((Element)this.getElement(), (String)"distributable");
        }
        this.changed((DescriptorEntity)this);
    }

    public Integer getSessionTimeout() {
        if (!this.isRecognized()) {
            return null;
        }
        Element config = DomUtils.getChildElement((Element)this.getElement(), (String)"session-config");
        if (config == null) {
            return null;
        }
        try {
            return Integer.valueOf(DomUtils.getChildTextNodeValue((Element)config, (String)"session-timeout"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean canSetSessionTimeout(Integer timeout) {
        return this.isRecognized();
    }

    public void setSessionTimeout(Integer timeout) {
        if (!this.canSetSessionTimeout(timeout)) {
            throw new IllegalArgumentException(timeout == null ? null : timeout.toString());
        }
        if (DescriptorEntityImpl.equals((Object)this.getSessionTimeout(), (Object)timeout)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        if (timeout != null) {
            Element config = DomUtils.getChildElement((Element)this.getElement(), (String)"session-config");
            if (config == null) {
                config = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"session-config");
            }
            DomUtils.setChildTextNodeValue((Element)config, (String[])WebAppChildOrder.WEB_APP, (String)"session-timeout", (String)timeout.toString());
        } else {
            DomUtils.removeChildNodes((Element)this.getElement(), (String)"session-config");
        }
        this.changed((DescriptorEntity)this);
    }

    public LoginConfig getLoginConfig() {
        return this.myLoginConfig;
    }

    public Environment getEnvironment() {
        return this.myEnvironment;
    }

    protected void readListeners() {
        if (this.myListeners == null) {
            this.myListeners = new HashMap();
            Element[] nodes = DomUtils.getChildElements((Element)this.getElement(), (String)"listener");
            int i = 0;
            while (i < nodes.length) {
                ListenerImpl listener = new ListenerImpl(this, nodes[i]);
                String className = listener.getClassName();
                if (!DescriptorEntityImpl.isNull((String)className) && !this.myListeners.containsKey(className)) {
                    this.myListeners.put(className, listener);
                }
                ++i;
            }
        }
    }

    protected void updateListener(String className) {
        Listener listener;
        if (this.myListeners != null && (listener = (Listener)this.myListeners.remove(className)) != null && listener.isValid()) {
            this.myListeners.put(listener.getClassName(), listener);
        }
    }

    public Listener[] getListeners() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readListeners();
        return this.myListeners.values().toArray(new Listener[this.myListeners.values().size()]);
    }

    public Listener getListener(String className) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readListeners();
        return (Listener)this.myListeners.get(className);
    }

    public boolean canCreateListener(String className) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readListeners();
        return !DescriptorEntityImpl.isNull((String)className) && !this.myListeners.containsKey(className);
    }

    public Listener createListener(String className) {
        if (!this.canCreateListener(className)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element listenerElement = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"listener");
        DomUtils.setChildTextNodeValue((Element)listenerElement, (String[])WebAppChildOrder.LISTENER, (String)"listener-class", (String)className);
        ListenerImpl listener = new ListenerImpl(this, listenerElement);
        this.myListeners.put(className, listener);
        this.added((DescriptorEntity)listener);
        return listener;
    }

    protected IWebListener getReferencedListener(String listenerClass) {
        if (!this.isRecognized()) {
            return null;
        }
        WebProject[] webProjects = this.getWebAppProject().getReferencedWebProjects();
        int i = 0;
        while (i < webProjects.length) {
            WebProject webProject = webProjects[i];
            IHttpSessionAttributeListener listener = webProject.getHttpSessionAttributeListener(listenerClass);
            if (listener != null) {
                return listener;
            }
            listener = webProject.getHttpSessionActivationListener(listenerClass);
            if (listener != null) {
                return listener;
            }
            listener = webProject.getHttpSessionBindingListener(listenerClass);
            if (listener != null) {
                return listener;
            }
            listener = webProject.getHttpSessionListener(listenerClass);
            if (listener != null) {
                return listener;
            }
            listener = webProject.getServletContextAttributeListener(listenerClass);
            if (listener != null) {
                return listener;
            }
            listener = webProject.getServletContextListener(listenerClass);
            if (listener != null) {
                return listener;
            }
            ++i;
        }
        return null;
    }

    protected void readFilters() {
        if (this.myFilters == null) {
            this.myFilters = new HashMap();
            Element[] nodes = DomUtils.getChildElements((Element)this.getElement(), (String)"filter");
            int i = 0;
            while (i < nodes.length) {
                String className;
                FilterImpl filter = new FilterImpl(this, nodes[i]);
                String name = filter.getName();
                if (!DescriptorEntityImpl.isNull((String)name) && !this.myFilters.containsKey(name) && (className = filter.getClassName()) != null) {
                    this.myFilters.put(name, filter);
                }
                ++i;
            }
        }
    }

    protected void updateFilter(String name) {
        Filter filter;
        if (this.myFilters != null && (filter = (Filter)this.myFilters.remove(name)) != null && filter.isValid()) {
            this.myFilters.put(filter.getName(), filter);
        }
    }

    public Filter[] getFilters() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readFilters();
        return this.myFilters.values().toArray(new Filter[this.myFilters.values().size()]);
    }

    public Filter getFilter(String name) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readFilters();
        return (Filter)this.myFilters.get(name);
    }

    public boolean canCreateFilter(FilterContext context) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readFilters();
        String name = context.getName();
        return context != null && !DescriptorEntityImpl.isNull((String)name) && !this.myFilters.containsKey(name);
    }

    public Filter createFilter(final FilterContext context) {
        if (!this.canCreateFilter(context)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        final Filter[] filterHolder = new Filter[1];
        this.modify(new Runnable(){

            public void run() {
                String name = context.getName();
                Element filterElement = DomUtils.createChildElement((Element)WebAppImpl.this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"filter");
                DomUtils.setChildTextNodeValue((Element)filterElement, (String[])WebAppChildOrder.FILTER, (String)"filter-name", (String)name);
                DomUtils.setChildTextNodeValue((Element)filterElement, (String[])WebAppChildOrder.FILTER, (String)"filter-class", (String)context.getFilterClass());
                FilterImpl filter = new FilterImpl(WebAppImpl.this, filterElement);
                WebAppImpl.this.myFilters.put(name, filter);
                WebAppImpl.this.added((DescriptorEntity)filter);
                context.applyDdps((WebApp)WebAppImpl.this, (DescriptorEntity)filter, (Object)filterElement);
                filterHolder[0] = filter;
            }
        });
        return filterHolder[0];
    }

    protected IFilter getReferencedFilter(String className) {
        if (!this.isRecognized()) {
            return null;
        }
        WebProject[] webProjects = this.getWebAppProject().getReferencedWebProjects();
        int i = 0;
        while (i < webProjects.length) {
            WebProject webProject = webProjects[i];
            IFilter filter = webProject.getFilter(className);
            if (filter != null) {
                return filter;
            }
            ++i;
        }
        return null;
    }

    protected void readServlets() {
        if (this.myServlets == null) {
            this.myServlets = new HashMap();
            Element[] nodes = DomUtils.getChildElements((Element)this.getElement(), (String)"servlet");
            int i = 0;
            while (i < nodes.length) {
                block7: {
                    ServletImpl servlet = new ServletImpl(this, nodes[i]);
                    String name = servlet.getName();
                    if (!DescriptorEntityImpl.isNull((String)name) && !this.myServlets.containsKey(name)) {
                        String className = servlet.getClassName();
                        String fileName = servlet.getFileName();
                        if (DescriptorEntityImpl.isNull((String)className) ^ DescriptorEntityImpl.isNull((String)fileName)) {
                            String loadOnStartup = servlet.getLoadOnStartup();
                            if (!DescriptorEntityImpl.isNull((String)loadOnStartup)) {
                                try {
                                    Integer.parseInt(loadOnStartup);
                                }
                                catch (NumberFormatException nfe) {
                                    break block7;
                                }
                            }
                            this.myServlets.put(name, servlet);
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void updateServlet(String name) {
        Servlet servlet;
        if (this.myServlets != null && (servlet = (Servlet)this.myServlets.remove(name)) != null && servlet.isValid()) {
            this.myServlets.put(servlet.getName(), servlet);
        }
    }

    public Servlet[] getServlets() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readServlets();
        return this.myServlets.values().toArray(new Servlet[this.myServlets.values().size()]);
    }

    public Servlet getServlet(String name) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readServlets();
        return (Servlet)this.myServlets.get(name);
    }

    public boolean canCreateServlet(ServletContext context) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readServlets();
        String name = context.getName();
        if (context == null || DescriptorEntityImpl.isNull((String)name) || this.myServlets.containsKey(name)) {
            return false;
        }
        String className = context.getServletClass();
        String fileName = context.getJspFile();
        if (!(DescriptorEntityImpl.isNull((String)className) ^ DescriptorEntityImpl.isNull((String)fileName))) {
            return false;
        }
        return DescriptorEntityImpl.isNull((String)fileName) || WebAppImpl.getWebContent() == null || fileName.startsWith(WebAppImpl.getWebContent());
    }

    public Servlet createServlet(final ServletContext context) {
        if (!this.canCreateServlet(context)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        final Servlet[] servletHolder = new Servlet[1];
        this.modify(new Runnable(){

            public void run() {
                String name = context.getName();
                Element servletElement = DomUtils.createChildElement((Element)WebAppImpl.this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"servlet");
                DomUtils.setChildTextNodeValue((Element)servletElement, (String[])WebAppChildOrder.SERVLET, (String)"servlet-name", (String)name);
                String fileName = context.getJspFile();
                if (!DescriptorEntityImpl.isNull((String)fileName)) {
                    if (WebAppImpl.getWebContent() != null) {
                        fileName = fileName.substring(WebAppImpl.getWebContent().length());
                    }
                    if (!fileName.startsWith("/")) {
                        fileName = "/" + fileName;
                    }
                    DomUtils.setChildTextNodeValue((Element)servletElement, (String[])WebAppChildOrder.SERVLET, (String)"jsp-file", (String)fileName);
                } else {
                    DomUtils.setChildTextNodeValue((Element)servletElement, (String[])WebAppChildOrder.SERVLET, (String)"servlet-class", (String)context.getServletClass());
                }
                ServletImpl servlet = new ServletImpl(WebAppImpl.this, servletElement);
                WebAppImpl.this.myServlets.put(name, servlet);
                WebAppImpl.this.added((DescriptorEntity)servlet);
                context.applyDdps((WebApp)WebAppImpl.this, (DescriptorEntity)servlet, (Object)servletElement);
                servletHolder[0] = servlet;
            }
        });
        return servletHolder[0];
    }

    protected IServlet getReferencedServlet(String className) {
        if (!this.isRecognized()) {
            return null;
        }
        WebProject[] webProjects = this.getWebAppProject().getReferencedWebProjects();
        int i = 0;
        while (i < webProjects.length) {
            WebProject webProject = webProjects[i];
            IServlet servlet = webProject.getServlet(className);
            if (servlet != null) {
                return servlet;
            }
            ++i;
        }
        return null;
    }

    protected IJSP getReferencedJsp(String fileName) {
        if (!this.isRecognized()) {
            return null;
        }
        WebProject[] webProjects = this.getWebAppProject().getReferencedWebProjects();
        int i = 0;
        while (i < webProjects.length) {
            WebProject webProject = webProjects[i];
            IJSP jsp = webProject.getJSP(webProject.getProject().getFile(fileName));
            if (jsp != null) {
                return jsp;
            }
            ++i;
        }
        return null;
    }

    protected void readTagLibraries() {
        if (this.myTagLibraries == null) {
            this.myTagLibraries = new HashMap();
            Element[] nodes = DomUtils.getChildElements((Element)this.getElement(), (String)"taglib");
            int i = 0;
            while (i < nodes.length) {
                String location;
                TagLibraryImpl library = new TagLibraryImpl(this, nodes[i]);
                String uri = library.getUri();
                if (!(DescriptorEntityImpl.isNull((String)uri) || this.myTagLibraries.containsKey(uri) || DescriptorEntityImpl.isNull((String)(location = library.getLocation())))) {
                    this.myTagLibraries.put(uri, library);
                }
                ++i;
            }
        }
    }

    protected void updateTagLibrary(String uri) {
        TagLibrary library;
        if (this.myTagLibraries != null && (library = (TagLibrary)this.myTagLibraries.remove(uri)) != null && library.isValid()) {
            this.myTagLibraries.put(library.getUri(), library);
        }
    }

    public TagLibrary[] getTagLibraries() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readTagLibraries();
        return this.myTagLibraries.values().toArray(new TagLibrary[this.myTagLibraries.values().size()]);
    }

    public TagLibrary getTagLibrary(String uri) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readTagLibraries();
        return (TagLibrary)this.myTagLibraries.get(uri);
    }

    public boolean canCreateTagLibrary(String uri, String location) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readTagLibraries();
        if (DescriptorEntityImpl.isNull((String)uri)) {
            return false;
        }
        if (this.myTagLibraries.containsKey(uri)) {
            return false;
        }
        return !DescriptorEntityImpl.isNull((String)location);
    }

    public TagLibrary createTagLibrary(String uri, String location) {
        if (!this.canCreateTagLibrary(uri, location)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element libraryElement = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"taglib");
        DomUtils.setChildTextNodeValue((Element)libraryElement, (String[])WebAppChildOrder.TAGLIB, (String)"taglib-uri", (String)uri);
        DomUtils.setChildTextNodeValue((Element)libraryElement, (String[])WebAppChildOrder.TAGLIB, (String)"taglib-location", (String)location);
        TagLibraryImpl library = new TagLibraryImpl(this, libraryElement);
        this.myTagLibraries.put(uri, library);
        this.added((DescriptorEntity)library);
        return library;
    }

    private Element getWelcomeFilesList(boolean create) {
        Element list = DomUtils.getChildElement((Element)this.getElement(), (String)"welcome-file-list");
        if (list == null && create) {
            list = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"welcome-file-list");
        }
        return list;
    }

    protected void readWelcomeFiles() {
        if (this.myWelcomeFiles == null) {
            Element list = this.getWelcomeFilesList(false);
            if (list == null) {
                this.myWelcomeFiles = new ArrayList(0);
                return;
            }
            Element[] nodes = DomUtils.getChildElements((Element)list, (String)"welcome-file");
            this.myWelcomeFiles = new ArrayList(nodes.length);
            int i = 0;
            while (i < nodes.length) {
                String fileName = DomUtils.getTextNodeValue((Element)nodes[i]);
                if (!DescriptorEntityImpl.isNull((String)fileName) && !this.myWelcomeFiles.contains(fileName)) {
                    this.myWelcomeFiles.add(fileName);
                }
                ++i;
            }
        }
    }

    public String[] getWelcomeFiles() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readWelcomeFiles();
        return this.myWelcomeFiles.toArray(new String[this.myWelcomeFiles.size()]);
    }

    public boolean canSetWelcomeFiles(String[] files) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readWelcomeFiles();
        if (files == null || files.length == 0) {
            return true;
        }
        HashSet<String> fileSet = new HashSet<String>(files.length);
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            if (file == null || file.trim().length() == 0) {
                return false;
            }
            if (fileSet.contains(file)) {
                return false;
            }
            fileSet.add(file);
            ++i;
        }
        return true;
    }

    public void setWelcomeFiles(String[] files) {
        if (!this.canSetWelcomeFiles(files)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return;
        }
        if (files == null || files.length == 0) {
            DomUtils.removeChildNodes((Element)this.getElement(), (String)"welcome-file-list");
            this.myWelcomeFiles.clear();
        } else {
            Element list = this.getWelcomeFilesList(true);
            DomUtils.removeChildNodes((Element)list, (String)"welcome-file");
            this.myWelcomeFiles = new ArrayList(files.length);
            int i = 0;
            while (i < files.length) {
                String file = files[i];
                DomUtils.createChildTextNode((Element)list, (String[])WebAppChildOrder.WELCOME_FILE_LIST, (String)"welcome-file").setNodeValue(file);
                this.myWelcomeFiles.add(file);
                ++i;
            }
        }
        this.changed((DescriptorEntity)this);
    }

    protected void readErrorPages() {
        if (this.myErrorPages == null) {
            this.myErrorPages = new HashMap();
            Element[] nodes = DomUtils.getChildElements((Element)this.getElement(), (String)"error-page");
            int i = 0;
            while (i < nodes.length) {
                ErrorPageImpl page = new ErrorPageImpl(this, nodes[i]);
                if (ErrorPageImpl.isValidErrorPageLocation(page.getLocation())) {
                    Integer code = page.getCode();
                    String exception = page.getException();
                    if (code == null && !DescriptorEntityImpl.isNull((String)exception) && !this.myErrorPages.containsKey(exception)) {
                        this.myErrorPages.put(exception, page);
                    } else if (DescriptorEntityImpl.isNull((String)exception) && code != null && !this.myErrorPages.containsKey(code)) {
                        this.myErrorPages.put(code, page);
                    }
                }
                ++i;
            }
        }
    }

    protected void updateErrorPage(Object reason) {
        if (this.myErrorPages != null) {
            ErrorPage page = (ErrorPage)this.myErrorPages.remove(reason);
            if (page == null || !page.isValid()) {
                return;
            }
            Integer code = page.getCode();
            if (code != null) {
                this.myErrorPages.put(code, page);
                return;
            }
            String exception = page.getException();
            if (!DescriptorEntityImpl.isNull((String)exception)) {
                this.myErrorPages.put(exception, page);
                return;
            }
        }
    }

    public ErrorPage[] getErrorPages() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readErrorPages();
        return this.myErrorPages.values().toArray(new ErrorPage[this.myErrorPages.values().size()]);
    }

    public ErrorPage getErrorPage(int code) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readErrorPages();
        return (ErrorPage)this.myErrorPages.get(new Integer(code));
    }

    public ErrorPage getErrorPage(String exception) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readErrorPages();
        return (ErrorPage)this.myErrorPages.get(exception);
    }

    public boolean canCreateErrorPage(int code, String location) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readErrorPages();
        return ErrorPageImpl.isValidErrorPageLocation(location);
    }

    public boolean canCreateErrorPage(String exception, String location) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readErrorPages();
        if (DescriptorEntityImpl.isNull((String)exception)) {
            return false;
        }
        return ErrorPageImpl.isValidErrorPageLocation(location);
    }

    public ErrorPage createErrorPage(int code, String location) {
        if (!this.canCreateErrorPage(code, location)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element pageElement = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"error-page");
        DomUtils.setChildTextNodeValue((Element)pageElement, (String[])WebAppChildOrder.ERROR_PAGE, (String)"error-code", (String)String.valueOf(code));
        DomUtils.setChildTextNodeValue((Element)pageElement, (String[])WebAppChildOrder.ERROR_PAGE, (String)"location", (String)location);
        ErrorPageImpl page = new ErrorPageImpl(this, pageElement);
        this.myErrorPages.put(new Integer(code), page);
        this.added((DescriptorEntity)page);
        return page;
    }

    public ErrorPage createErrorPage(String exception, String location) {
        if (!this.canCreateErrorPage(exception, location)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element pageElement = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"error-page");
        DomUtils.setChildTextNodeValue((Element)pageElement, (String[])WebAppChildOrder.ERROR_PAGE, (String)"exception-type", (String)exception);
        DomUtils.setChildTextNodeValue((Element)pageElement, (String[])WebAppChildOrder.ERROR_PAGE, (String)"location", (String)location);
        ErrorPageImpl page = new ErrorPageImpl(this, pageElement);
        this.myErrorPages.put(exception, page);
        this.added((DescriptorEntity)page);
        return page;
    }

    protected void readMimeMappings() {
        if (this.myMimeMappings == null) {
            this.myMimeMappings = new HashMap();
            Element[] nodes = DomUtils.getChildElements((Element)this.getElement(), (String)"mime-mapping");
            int i = 0;
            while (i < nodes.length) {
                String type;
                MimeMappingImpl map = new MimeMappingImpl(this, nodes[i]);
                String extension = map.getExtension();
                if (!(DescriptorEntityImpl.isNull((String)extension) || this.myMimeMappings.containsKey(extension) || DescriptorEntityImpl.isNull((String)(type = map.getType())))) {
                    this.myMimeMappings.put(extension, map);
                }
                ++i;
            }
        }
    }

    protected void updateMimeMapping(String extension) {
        MimeMapping map;
        if (this.myMimeMappings != null && (map = (MimeMapping)this.myMimeMappings.remove(extension)) != null && map.isValid()) {
            this.myMimeMappings.put(map.getExtension(), map);
        }
    }

    public MimeMapping[] getMimeMappings() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readMimeMappings();
        return this.myMimeMappings.values().toArray(new MimeMapping[this.myMimeMappings.values().size()]);
    }

    public MimeMapping getMimeMapping(String extension) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readMimeMappings();
        return (MimeMapping)this.myMimeMappings.get(extension);
    }

    public boolean canCreateMimeMapping(String extension, String type) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readMimeMappings();
        if (DescriptorEntityImpl.isNull((String)extension) || this.myMimeMappings.containsKey(extension)) {
            return false;
        }
        return !DescriptorEntityImpl.isNull((String)type);
    }

    public MimeMapping createMimeMapping(String extension, String type) {
        if (!this.canCreateMimeMapping(extension, type)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element mapElement = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"mime-mapping");
        DomUtils.setChildTextNodeValue((Element)mapElement, (String[])WebAppChildOrder.MIME_MAPPING, (String)"extension", (String)extension);
        DomUtils.setChildTextNodeValue((Element)mapElement, (String[])WebAppChildOrder.MIME_MAPPING, (String)"mime-type", (String)type);
        MimeMappingImpl map = new MimeMappingImpl(this, mapElement);
        this.myMimeMappings.put(extension, map);
        this.added((DescriptorEntity)map);
        return map;
    }

    protected void readContextParameters() {
        if (this.myContextParameters == null) {
            this.myContextParameters = new HashMap();
            Element[] nodes = DomUtils.getChildElements((Element)this.getElement(), (String)"context-param");
            int i = 0;
            while (i < nodes.length) {
                String value;
                ContextParameterImpl param = new ContextParameterImpl(this, nodes[i]);
                String name = param.getName();
                if (!DescriptorEntityImpl.isNull((String)name) && !this.myContextParameters.containsKey(name) && (value = param.getValue()) != null) {
                    this.myContextParameters.put(name, param);
                }
                ++i;
            }
        }
    }

    protected void updateContextParameter(String name) {
        ContextParameter param;
        if (this.myContextParameters != null && (param = (ContextParameter)this.myContextParameters.remove(name)) != null && param.isValid()) {
            this.myContextParameters.put(param.getName(), param);
        }
    }

    public ContextParameter[] getContextParameters() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readContextParameters();
        return this.myContextParameters.values().toArray(new ContextParameter[this.myContextParameters.values().size()]);
    }

    public ContextParameter getContextParameter(String name) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readContextParameters();
        return (ContextParameter)this.myContextParameters.get(name);
    }

    public boolean canCreateContextParameter(String name, String value, String description) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readContextParameters();
        if (DescriptorEntityImpl.isNull((String)name) || this.myContextParameters.containsKey(name)) {
            return false;
        }
        return value != null;
    }

    public ContextParameter createContextParameter(String name, String value, String description) {
        if (!this.canCreateContextParameter(name, value, description)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element paramElement = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"context-param");
        DomUtils.setChildTextNodeValue((Element)paramElement, (String[])WebAppChildOrder.CONTEXT_PARAM, (String)"param-name", (String)name);
        DomUtils.setChildTextNodeValue((Element)paramElement, (String[])WebAppChildOrder.CONTEXT_PARAM, (String)"param-value", (String)value);
        if (description != null) {
            DomUtils.setChildTextNodeValue((Element)paramElement, (String[])WebAppChildOrder.CONTEXT_PARAM, (String)"description", (String)description);
        }
        ContextParameterImpl param = new ContextParameterImpl(this, paramElement);
        this.myContextParameters.put(name, param);
        this.added((DescriptorEntity)param);
        return param;
    }

    protected void readSecurityRoles() {
        if (this.mySecurityRoles == null) {
            this.mySecurityRoles = new HashMap();
            Element[] nodes = DomUtils.getChildElements((Element)this.getElement(), (String)"security-role");
            int i = 0;
            while (i < nodes.length) {
                SecurityRoleImpl role = new SecurityRoleImpl(this, nodes[i]);
                String name = role.getName();
                if (!DescriptorEntityImpl.isNull((String)name) && !this.mySecurityRoles.containsKey(name)) {
                    this.mySecurityRoles.put(name, role);
                }
                ++i;
            }
        }
    }

    protected void updateSecurityRole(String name) {
        SecurityRole role;
        if (this.mySecurityRoles != null && (role = (SecurityRole)this.mySecurityRoles.remove(name)) != null && role.isValid()) {
            this.mySecurityRoles.put(role.getName(), role);
        }
    }

    public SecurityRole[] getSecurityRoles() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readSecurityRoles();
        return this.mySecurityRoles.values().toArray(new SecurityRole[this.mySecurityRoles.values().size()]);
    }

    public SecurityRole getSecurityRole(String name) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readSecurityRoles();
        return (SecurityRole)this.mySecurityRoles.get(name);
    }

    public boolean canCreateSecurityRole(String name, String description) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readSecurityRoles();
        return !DescriptorEntityImpl.isNull((String)name) && !this.mySecurityRoles.containsKey(name);
    }

    public SecurityRole createSecurityRole(String name, String description) {
        if (!this.canCreateSecurityRole(name, description)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element roleElement = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"security-role");
        DomUtils.setChildTextNodeValue((Element)roleElement, (String[])WebAppChildOrder.SECURITY_ROLE, (String)"role-name", (String)name);
        if (description != null) {
            DomUtils.setChildTextNodeValue((Element)roleElement, (String[])WebAppChildOrder.SECURITY_ROLE, (String)"description", (String)description);
        }
        SecurityRoleImpl role = new SecurityRoleImpl(this, roleElement);
        this.mySecurityRoles.put(name, role);
        this.added((DescriptorEntity)role);
        return role;
    }

    protected void readSecurityConstraints() {
        if (this.mySecurityConstraints == null) {
            this.mySecurityConstraints = new HashMap();
            Element[] nodes = DomUtils.getChildElements((Element)this.getElement(), (String)"security-constraint");
            int i = 0;
            while (i < nodes.length) {
                SecurityConstraintImpl constraint = new SecurityConstraintImpl(this, nodes[i], String.valueOf(i));
                String name = constraint.getSyntheticName();
                if (!DescriptorEntityImpl.isNull((String)name) && !this.mySecurityConstraints.containsKey(name)) {
                    this.mySecurityConstraints.put(name, constraint);
                }
                ++i;
            }
        }
    }

    protected void updateSecurityConstraint(String syntheticName) {
        SecurityConstraint constraint;
        if (this.mySecurityConstraints != null && (constraint = (SecurityConstraint)this.mySecurityConstraints.remove(syntheticName)) != null && constraint.isValid()) {
            this.mySecurityConstraints.put(constraint.getSyntheticName(), constraint);
        }
    }

    public SecurityConstraint[] getSecurityConstraints() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readSecurityConstraints();
        return this.mySecurityConstraints.values().toArray(new SecurityConstraint[this.mySecurityConstraints.values().size()]);
    }

    public SecurityConstraint getSecurityConstraint(String name) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readSecurityConstraints();
        return (SecurityConstraint)this.mySecurityConstraints.get(name);
    }

    public boolean canCreateSecurityConstraint(String displayName, String acDescription, String[] acSecurityRoles, String dcDescription, String dcTransportGuarantee) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readSecurityConstraints();
        if (acSecurityRoles != null && acSecurityRoles.length > 0) {
            HashSet<String> accepted = new HashSet<String>(acSecurityRoles.length);
            int i = 0;
            while (i < acSecurityRoles.length) {
                String name = acSecurityRoles[i];
                if (DescriptorEntityImpl.isNull((String)name) || accepted.contains(name)) {
                    return false;
                }
                accepted.add(name);
                ++i;
            }
        } else if (acDescription != null) {
            return false;
        }
        return !(dcTransportGuarantee != null ? !WebAppMetaInfo.isValidTransportGuarantee((String)dcTransportGuarantee) : dcDescription != null);
    }

    public SecurityConstraint createSecurityConstraint(String displayName, String acDescription, String[] acSecurityRoles, String dcDescription, String dcTransportGuarantee) {
        if (!this.canCreateSecurityConstraint(displayName, acDescription, acSecurityRoles, dcDescription, dcTransportGuarantee)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element constraintElement = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"security-constraint");
        if (displayName != null) {
            DomUtils.setChildTextNodeValue((Element)constraintElement, (String[])WebAppChildOrder.SECURITY_CONSTRAINT, (String)"display-name", (String)displayName);
        }
        if (acSecurityRoles != null && acSecurityRoles.length > 0) {
            Element acElement = DomUtils.createChildElement((Element)constraintElement, (String[])WebAppChildOrder.SECURITY_CONSTRAINT, (String)"auth-constraint");
            if (acDescription != null) {
                DomUtils.setChildTextNodeValue((Element)acElement, (String[])WebAppChildOrder.AUTH_CONSTRAINT, (String)"description", (String)acDescription);
            }
            int i = 0;
            while (i < acSecurityRoles.length) {
                DomUtils.createChildTextNode((Element)acElement, (String[])WebAppChildOrder.AUTH_CONSTRAINT, (String)"role-name").setNodeValue(acSecurityRoles[i]);
                ++i;
            }
        }
        if (dcTransportGuarantee != null) {
            Element dcElement = DomUtils.createChildElement((Element)constraintElement, (String[])WebAppChildOrder.SECURITY_CONSTRAINT, (String)"user-data-constraint");
            if (dcDescription != null) {
                DomUtils.setChildTextNodeValue((Element)dcElement, (String[])WebAppChildOrder.USER_DATA_CONSTRAINT, (String)"description", (String)dcDescription);
            }
            DomUtils.setChildTextNodeValue((Element)dcElement, (String[])WebAppChildOrder.USER_DATA_CONSTRAINT, (String)"transport-guarantee", (String)dcTransportGuarantee);
        }
        SecurityConstraintImpl constraint = new SecurityConstraintImpl(this, constraintElement, String.valueOf(this.mySecurityConstraints.size()));
        this.mySecurityConstraints.put(constraint.getSyntheticName(), constraint);
        this.added((DescriptorEntity)constraint);
        return constraint;
    }

    protected void readFilterMappings() {
        if (this.myFilterMappings != null) {
            return;
        }
        Element[] mappings = DomUtils.getChildElements((Element)this.getElement(), (String)"filter-mapping");
        this.myFilterMappings = new ArrayList(mappings.length);
        int i = 0;
        while (i < mappings.length) {
            FilterMappingImpl mapping = new FilterMappingImpl(this, mappings[i], String.valueOf(i));
            this.myFilterMappings.add(mapping);
            ++i;
        }
    }

    protected void updateFilterMapping(String syntheticName) {
        if (this.myFilterMappings == null) {
            return;
        }
        int index = WebAppImpl.asIndex(syntheticName, this.myFilterMappings);
        if (index < 0) {
            return;
        }
        FilterMapping mapping = (FilterMapping)this.myFilterMappings.remove(index);
        if (mapping != null && mapping.isValid()) {
            this.myFilterMappings.add(index, mapping);
        } else {
            this.updateFilterMappings(index);
        }
    }

    private void updateFilterMappings(int fromIndex) {
        int i = fromIndex;
        while (i < this.myFilterMappings.size()) {
            FilterMappingImpl mapping = (FilterMappingImpl)((Object)this.myFilterMappings.get(i));
            mapping.setSyntheticName(String.valueOf(i));
            ++i;
        }
    }

    public FilterMapping[] getFilterMappings() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readFilterMappings();
        return this.myFilterMappings.toArray(new FilterMapping[this.myFilterMappings.size()]);
    }

    public boolean canSetFilterMappings(FilterMapping[] mappings) {
        return true;
    }

    private void deleteFilterMappings() {
        FilterMapping[] mappings = this.getFilterMappings();
        if (mappings == null) {
            return;
        }
        int i = mappings.length - 1;
        while (i >= 0) {
            FilterMapping mapping = mappings[i];
            if (mapping.canDelete()) {
                mapping.delete();
            }
            --i;
        }
    }

    public void setFilterMappings(FilterMapping[] mappings) {
        if (!this.canSetFilterMappings(mappings)) {
            throw new IllegalArgumentException();
        }
        this.deleteFilterMappings();
        if (mappings == null) {
            return;
        }
        int i = 0;
        while (i < mappings.length) {
            FilterMapping mapping = mappings[i];
            if (this.canCreateFilterMapping(mapping.getFilterName(), mapping.getUrlPattern(), mapping.getServletName())) {
                this.createFilterMapping(mapping.getFilterName(), mapping.getUrlPattern(), mapping.getServletName());
            }
            ++i;
        }
    }

    public FilterMapping getFilterMapping(String syntheticName) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readFilterMappings();
        int index = WebAppImpl.asIndex(syntheticName, this.myFilterMappings);
        if (index < 0) {
            return null;
        }
        return (FilterMapping)this.myFilterMappings.get(index);
    }

    public boolean canCreateFilterMapping(String filterName, String urlPattern, String servletName) {
        if (!this.isRecognized()) {
            return false;
        }
        if (DescriptorEntityImpl.isNull((String)filterName)) {
            return false;
        }
        this.readFilterMappings();
        urlPattern = DescriptorEntityImpl.nullify((String)urlPattern);
        servletName = DescriptorEntityImpl.nullify((String)servletName);
        return urlPattern == null ^ servletName == null;
    }

    public FilterMapping createFilterMapping(String filterName, String urlPattern, String servletName) {
        if (!this.canCreateFilterMapping(filterName, urlPattern, servletName)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element mappingElement = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"filter-mapping");
        DomUtils.setChildTextNodeValue((Element)mappingElement, (String[])WebAppChildOrder.FILTER_MAPPING, (String)"filter-name", (String)filterName);
        urlPattern = DescriptorEntityImpl.nullify((String)urlPattern);
        if (urlPattern != null) {
            DomUtils.setChildTextNodeValue((Element)mappingElement, (String[])WebAppChildOrder.FILTER_MAPPING, (String)"url-pattern", (String)urlPattern);
        }
        if ((servletName = DescriptorEntityImpl.nullify((String)servletName)) != null) {
            DomUtils.setChildTextNodeValue((Element)mappingElement, (String[])WebAppChildOrder.FILTER_MAPPING, (String)"servlet-name", (String)servletName);
        }
        FilterMappingImpl mapping = new FilterMappingImpl(this, mappingElement, String.valueOf(this.myFilterMappings.size()));
        this.myFilterMappings.add(mapping);
        this.added((DescriptorEntity)mapping);
        return mapping;
    }

    protected void readServletMappings() {
        if (this.myServletMappings != null) {
            return;
        }
        Element[] mappings = DomUtils.getChildElements((Element)this.getElement(), (String)"servlet-mapping");
        this.myServletMappings = new ArrayList(mappings.length);
        int i = 0;
        while (i < mappings.length) {
            ServletMappingImpl mapping = new ServletMappingImpl(this, mappings[i], String.valueOf(i));
            this.myServletMappings.add(mapping);
            ++i;
        }
    }

    protected void updateServletMapping(String syntheticName) {
        if (this.myServletMappings == null) {
            return;
        }
        int index = WebAppImpl.asIndex(syntheticName, this.myServletMappings);
        if (index < 0) {
            return;
        }
        ServletMapping mapping = (ServletMapping)this.myServletMappings.remove(index);
        if (mapping != null && mapping.isValid()) {
            this.myServletMappings.add(index, mapping);
        } else {
            this.updateServletMappings(index);
        }
    }

    private void updateServletMappings(int fromIndex) {
        int i = fromIndex;
        while (i < this.myServletMappings.size()) {
            ServletMappingImpl mapping = (ServletMappingImpl)((Object)this.myServletMappings.get(i));
            mapping.setSyntheticName(String.valueOf(i));
            ++i;
        }
    }

    public ServletMapping[] getServletMappings() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readServletMappings();
        return this.myServletMappings.toArray(new ServletMapping[this.myServletMappings.size()]);
    }

    public boolean canSetServletMappings(ServletMapping[] mappings) {
        return true;
    }

    private void deleteServletMappings() {
        ServletMapping[] mappings = this.getServletMappings();
        if (mappings == null) {
            return;
        }
        int i = mappings.length - 1;
        while (i >= 0) {
            ServletMapping mapping = mappings[i];
            if (mapping.canDelete()) {
                mapping.delete();
            }
            --i;
        }
    }

    public void setServletMappings(ServletMapping[] mappings) {
        if (!this.canSetServletMappings(mappings)) {
            throw new IllegalArgumentException();
        }
        this.deleteServletMappings();
        if (mappings == null) {
            return;
        }
        int i = 0;
        while (i < mappings.length) {
            ServletMapping mapping = mappings[i];
            if (this.canCreateServletMapping(mapping.getServletName(), mapping.getUrlPattern())) {
                this.createServletMapping(mapping.getServletName(), mapping.getUrlPattern());
            }
            ++i;
        }
    }

    public ServletMapping getServletMapping(String syntheticName) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readServletMappings();
        int index = WebAppImpl.asIndex(syntheticName, this.myServletMappings);
        if (index < 0) {
            return null;
        }
        return (ServletMapping)this.myServletMappings.get(index);
    }

    public boolean canCreateServletMapping(String servletName, String urlPattern) {
        if (!this.isRecognized()) {
            return false;
        }
        if (DescriptorEntityImpl.isNull((String)servletName)) {
            return false;
        }
        this.readServletMappings();
        urlPattern = DescriptorEntityImpl.nullify((String)urlPattern);
        return urlPattern != null;
    }

    public ServletMapping createServletMapping(String servletName, String urlPattern) {
        if (!this.canCreateServletMapping(servletName, urlPattern)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element mappingElement = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"servlet-mapping");
        DomUtils.setChildTextNodeValue((Element)mappingElement, (String[])WebAppChildOrder.SERVLET_MAPPING, (String)"servlet-name", (String)servletName);
        urlPattern = DescriptorEntityImpl.nullify((String)urlPattern);
        if (urlPattern != null) {
            DomUtils.setChildTextNodeValue((Element)mappingElement, (String[])WebAppChildOrder.SERVLET_MAPPING, (String)"url-pattern", (String)urlPattern);
        }
        ServletMappingImpl mapping = new ServletMappingImpl(this, mappingElement, String.valueOf(this.myServletMappings.size()));
        this.myServletMappings.add(mapping);
        this.added((DescriptorEntity)mapping);
        return mapping;
    }

    private static String getWebContent() {
        return WebAppImplPlugin.getDefault().getWebContent();
    }

    private WebAppProject getWebAppProject() {
        return this.myProject;
    }

    public void reload() {
        this.myListeners = null;
        this.myFilters = null;
        this.myServlets = null;
        this.myTagLibraries = null;
        this.myWelcomeFiles = null;
        this.myErrorPages = null;
        this.myMimeMappings = null;
        this.myContextParameters = null;
        this.mySecurityRoles = null;
        this.mySecurityConstraints = null;
        this.myFilterMappings = null;
        this.myServletMappings = null;
        super.reload();
        if (this.isRecognized()) {
            this.myUserInterface = new UserInterfaceImpl((DescriptorEntityImpl)this, this.getElement(), WebAppChildOrder.WEB_APP, "web-app");
            this.myLoginConfig = new LoginConfigImpl(this, this.getElement());
            this.myEnvironment = new WebAppEnvironmentImpl(this, this.getElement());
        }
    }

    static int asIndex(String syntheticName, Collection elements) {
        int index;
        try {
            index = Integer.parseInt(syntheticName);
        }
        catch (NumberFormatException nfe) {
            WebAppImplPlugin.logError("Invalid synthetic name : " + syntheticName);
            return -1;
        }
        if (index < 0 || index >= elements.size()) {
            return -1;
        }
        return index;
    }

    protected String getPublicId() {
        return PUBLIC_ID;
    }

    protected String getSystemId() {
        return SYSTEM_ID;
    }

    protected String getDtd() {
        if (ourDtd == null) {
            ourDtd = FileUtils.getFileContents((String)DTD_PATH, (String)"", (Plugin)WebAppImplPlugin.getDefault());
        }
        return ourDtd;
    }
}

