/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.webapp;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.SecurityRoleRef;
import com.tssap.j2ee.core.descriptor.UserInterface;
import com.tssap.j2ee.core.web.IJSP;
import com.tssap.j2ee.core.web.IServlet;
import com.tssap.j2ee.core.webapp.Initialization;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.internal.core.descriptor.DescribedDescriptorEntityImpl;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import com.tssap.j2ee.internal.core.webapp.InitializationImpl;
import com.tssap.j2ee.internal.core.webapp.SecurityRoleRefImpl;
import com.tssap.j2ee.internal.core.webapp.UserInterfaceImpl;
import com.tssap.j2ee.internal.core.webapp.WebAppChildOrder;
import com.tssap.j2ee.internal.core.webapp.WebAppImpl;
import com.tssap.j2ee.internal.core.webapp.WebAppImplPlugin;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

final class ServletImpl
extends DescribedDescriptorEntityImpl
implements Servlet {
    private UserInterface myUserInterface;
    private Initialization myInitialization;
    private Map mySecurityRoleRefs;

    public ServletImpl(WebAppImpl parent, Element element) {
        super((DescriptorEntityImpl)parent, element);
        this.myUserInterface = new UserInterfaceImpl((DescriptorEntityImpl)this, element, WebAppChildOrder.SERVLET, "servlet");
        this.myInitialization = new InitializationImpl((DescriptorEntityImpl)this, element, WebAppChildOrder.SERVLET);
    }

    public String toString() {
        return "Servlet \"" + this.getName() + "\"";
    }

    public void delete() {
        if (!this.edit(null)) {
            return;
        }
        String oldName = this.getName();
        super.delete();
        this.getWebAppImpl().updateServlet(oldName);
    }

    public String getName() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"servlet-name");
    }

    public boolean canSetName(String name) {
        if (DescriptorEntityImpl.isNull((String)name)) {
            return false;
        }
        return DescriptorEntityImpl.equals((Object)this.getName(), (Object)name) || this.getWebAppImpl().getServlet(name) == null;
    }

    public void setName(String name) {
        if (!this.canSetName(name)) {
            throw new IllegalArgumentException(name);
        }
        String oldName = this.getName();
        if (DescriptorEntityImpl.equals((Object)oldName, (Object)name)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])WebAppChildOrder.SERVLET, (String)"servlet-name", (String)name);
        this.getWebAppImpl().updateServlet(oldName);
        this.changed((DescriptorEntity)this);
    }

    protected String getLoadOnStartup() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"load-on-startup");
    }

    public boolean isLoadOnStartup() {
        return DomUtils.getChildElement((Element)this.getElement(), (String)"load-on-startup") != null;
    }

    public Integer getLoadOnStartupOrder() {
        String loadOnStartup = this.getLoadOnStartup();
        if (DescriptorEntityImpl.isNull((String)loadOnStartup)) {
            return null;
        }
        try {
            return new Integer(loadOnStartup);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean canSetLoadOnStartup(boolean enable, Integer order) {
        return enable || order == null;
    }

    public void setLoadOnStartup(boolean enable, Integer order) {
        if (!this.canSetLoadOnStartup(enable, order)) {
            throw new IllegalArgumentException();
        }
        if (DescriptorEntityImpl.equals((boolean)this.isLoadOnStartup(), (boolean)enable) && DescriptorEntityImpl.equals((Object)this.getLoadOnStartupOrder(), (Object)order)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        if (enable) {
            String loadOnStartup = order == null ? "" : order.toString();
            DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])WebAppChildOrder.SERVLET, (String)"load-on-startup", (String)loadOnStartup);
        } else {
            DomUtils.removeChildNodes((Element)this.getElement(), (String)"load-on-startup");
        }
        this.changed((DescriptorEntity)this);
    }

    public String getClassName() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"servlet-class");
    }

    public String getFileName() {
        String fileName = DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"jsp-file");
        if (DescriptorEntityImpl.isNull((String)fileName)) {
            return null;
        }
        if (ServletImpl.getWebContent() != null) {
            fileName = ServletImpl.getWebContent() + fileName;
        } else if (DescriptorEntityImpl.isNull((String)(fileName = fileName.substring(1)))) {
            return null;
        }
        return fileName;
    }

    public boolean canSetSource(String className, String fileName) {
        if (!(DescriptorEntityImpl.isNull((String)className) ^ DescriptorEntityImpl.isNull((String)fileName))) {
            return false;
        }
        if (!DescriptorEntityImpl.isNull((String)fileName)) {
            if (ServletImpl.getWebContent() != null) {
                if (!fileName.startsWith(ServletImpl.getWebContent())) {
                    return false;
                }
                fileName = fileName.substring(ServletImpl.getWebContent().length());
            } else if (fileName.startsWith("/")) {
                return false;
            }
            if (fileName.length() < 1) {
                return false;
            }
        }
        return true;
    }

    public void setSource(String className, String fileName) {
        if (!this.canSetSource(className, fileName)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return;
        }
        if (!DescriptorEntityImpl.isNull((String)fileName)) {
            if (DescriptorEntityImpl.equals((Object)this.getFileName(), (Object)fileName)) {
                return;
            }
            fileName = ServletImpl.getWebContent() != null ? fileName.substring(ServletImpl.getWebContent().length()) : "/" + fileName;
            DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])WebAppChildOrder.SERVLET, (String)"jsp-file", (String)fileName);
            DomUtils.removeChildNodes((Element)this.getElement(), (String)"servlet-class");
            this.changed((DescriptorEntity)this);
        } else {
            if (DescriptorEntityImpl.equals((Object)this.getClassName(), (Object)className)) {
                return;
            }
            DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])WebAppChildOrder.SERVLET, (String)"servlet-class", (String)className);
            DomUtils.removeChildNodes((Element)this.getElement(), (String)"jsp-file");
            this.changed((DescriptorEntity)this);
        }
    }

    public IServlet getReferencedServlet() {
        String className = this.getClassName();
        if (DescriptorEntityImpl.isNull((String)className)) {
            return null;
        }
        return this.getWebAppImpl().getReferencedServlet(className);
    }

    public IJSP getReferencedJsp() {
        String fileName = this.getFileName();
        if (DescriptorEntityImpl.isNull((String)fileName)) {
            return null;
        }
        return this.getWebAppImpl().getReferencedJsp(fileName);
    }

    public UserInterface getUserInterface() {
        return this.myUserInterface;
    }

    public Initialization getInitialization() {
        return this.myInitialization;
    }

    private Element getRunAs(boolean create) {
        Element runAs = DomUtils.getChildElement((Element)this.getElement(), (String)"run-as");
        if (runAs == null && create) {
            runAs = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.SERVLET, (String)"run-as");
        }
        return runAs;
    }

    public String getRunAsDescription() {
        Element runAs = this.getRunAs(false);
        if (runAs == null) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)runAs, (String)"description");
    }

    public boolean canSetRunAsDescription(String description) {
        Element runAs = this.getRunAs(false);
        return runAs != null;
    }

    public void setRunAsDescription(String description) {
        if (!this.canSetRunAsDescription(description)) {
            throw new IllegalArgumentException(description);
        }
        if (DescriptorEntityImpl.equals((Object)this.getRunAsDescription(), (Object)description)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        Element runAs = this.getRunAs(false);
        DomUtils.setChildTextNodeValue((Element)runAs, (String[])WebAppChildOrder.RUN_AS, (String)"description", (String)description);
        this.changed((DescriptorEntity)this);
    }

    public String getRunAsRoleName() {
        Element runAs = this.getRunAs(false);
        if (runAs == null) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)runAs, (String)"role-name");
    }

    public boolean canSetRunAsRoleName(String name) {
        return true;
    }

    public void setRunAsRoleName(String name) {
        if (!this.canSetRunAsRoleName(name)) {
            throw new IllegalArgumentException(name);
        }
        if (DescriptorEntityImpl.equals((Object)this.getRunAsRoleName(), (Object)name)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        if (DescriptorEntityImpl.isNull((String)name)) {
            DomUtils.removeChildNodes((Element)this.getElement(), (String)"run-as");
        } else {
            Element runAs = this.getRunAs(true);
            DomUtils.setChildTextNodeValue((Element)runAs, (String[])WebAppChildOrder.RUN_AS, (String)"role-name", (String)name);
        }
        this.changed((DescriptorEntity)this);
    }

    protected void readSecurityRoleRefs() {
        if (this.mySecurityRoleRefs == null) {
            this.mySecurityRoleRefs = new HashMap();
            Element[] refs = DomUtils.getChildElements((Element)this.getElement(), (String)"security-role-ref");
            int i = 0;
            while (i < refs.length) {
                SecurityRoleRefImpl ref = new SecurityRoleRefImpl(this, refs[i]);
                String name = ref.getName();
                if (!DescriptorEntityImpl.isNull((String)name) && !this.mySecurityRoleRefs.containsKey(name)) {
                    this.mySecurityRoleRefs.put(name, ref);
                }
                ++i;
            }
        }
    }

    protected void updateSecurityRoleRef(String name) {
        SecurityRoleRef ref;
        if (this.mySecurityRoleRefs != null && (ref = (SecurityRoleRef)this.mySecurityRoleRefs.remove(name)) != null && ref.isValid()) {
            this.mySecurityRoleRefs.put(ref.getName(), ref);
        }
    }

    public SecurityRoleRef[] getSecurityRoleReferences() {
        this.readSecurityRoleRefs();
        Collection refs = this.mySecurityRoleRefs.values();
        return refs.toArray(new SecurityRoleRef[refs.size()]);
    }

    public SecurityRoleRef getSecurityRoleReference(String name) {
        this.readSecurityRoleRefs();
        return (SecurityRoleRef)this.mySecurityRoleRefs.get(name);
    }

    public boolean canCreateSecurityRoleReference(String name, String link, String description) {
        this.readSecurityRoleRefs();
        return !DescriptorEntityImpl.isNull((String)name) && !this.mySecurityRoleRefs.containsKey(name);
    }

    public SecurityRoleRef createSecurityRoleReference(String name, String link, String description) {
        if (!this.canCreateSecurityRoleReference(name, link, description)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element refElement = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.SERVLET, (String)"security-role-ref");
        DomUtils.setChildTextNodeValue((Element)refElement, (String[])WebAppChildOrder.SECURITY_ROLE_REF, (String)"role-name", (String)name);
        if (link != null) {
            DomUtils.setChildTextNodeValue((Element)refElement, (String[])WebAppChildOrder.SECURITY_ROLE_REF, (String)"role-link", (String)link);
        }
        if (description != null) {
            DomUtils.setChildTextNodeValue((Element)refElement, (String[])WebAppChildOrder.SECURITY_ROLE_REF, (String)"description", (String)description);
        }
        SecurityRoleRefImpl ref = new SecurityRoleRefImpl(this, refElement);
        this.mySecurityRoleRefs.put(name, ref);
        this.added((DescriptorEntity)ref);
        return ref;
    }

    protected String[] getChildOrder() {
        return WebAppChildOrder.SERVLET;
    }

    private WebAppImpl getWebAppImpl() {
        return (WebAppImpl)this.getParent();
    }

    private static String getWebContent() {
        return WebAppImplPlugin.getDefault().getWebContent();
    }
}

