/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.webapp;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.descriptor.SecurityRoleRef;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.core.webapp.SecurityConstraint;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.internal.core.descriptor.DescribedDescriptorEntityImpl;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import com.tssap.j2ee.internal.core.webapp.WebAppChildOrder;
import com.tssap.j2ee.internal.core.webapp.WebAppImpl;
import org.w3c.dom.Element;

final class SecurityRoleImpl
extends DescribedDescriptorEntityImpl
implements SecurityRole {
    public SecurityRoleImpl(WebAppImpl parent, Element element) {
        super((DescriptorEntityImpl)parent, element);
    }

    public String toString() {
        return "SecurityRole \"" + this.getName() + "\"";
    }

    public void delete() {
        if (!this.edit(null)) {
            return;
        }
        final String oldName = this.getName();
        this.modify(new Runnable(){

            public void run() {
                SecurityRoleImpl.super.delete();
                SecurityRoleImpl.this.getWebAppImpl().updateSecurityRole(oldName);
                SecurityRoleImpl.this.sync(oldName, null);
            }
        });
    }

    public String getName() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"role-name");
    }

    public boolean canSetName(String name) {
        if (DescriptorEntityImpl.isNull((String)name)) {
            return false;
        }
        return DescriptorEntityImpl.equals((Object)this.getName(), (Object)name) || this.getWebAppImpl().getSecurityRole(name) == null;
    }

    public void setName(final String name) {
        if (!this.canSetName(name)) {
            throw new IllegalArgumentException(name);
        }
        final String oldName = this.getName();
        if (DescriptorEntityImpl.equals((Object)oldName, (Object)name)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        this.modify(new Runnable(){

            public void run() {
                DomUtils.setChildTextNodeValue((Element)SecurityRoleImpl.this.getElement(), (String[])WebAppChildOrder.SECURITY_ROLE, (String)"role-name", (String)name);
                SecurityRoleImpl.this.getWebAppImpl().updateSecurityRole(oldName);
                SecurityRoleImpl.super.changed((DescriptorEntity)SecurityRoleImpl.this);
                SecurityRoleImpl.this.sync(oldName, name);
            }
        });
    }

    private void sync(String oldName, String newName) {
        Servlet[] servlets = this.getWebAppImpl().getServlets();
        if (servlets != null && servlets.length > 0) {
            int i = 0;
            while (i < servlets.length) {
                this.syncServletRunAs(servlets[i], oldName, newName);
                this.syncServletRoleRefs(servlets[i], oldName, newName);
                ++i;
            }
        }
        this.syncSecurityConstraints(oldName, newName);
    }

    private void syncServletRunAs(Servlet servlet, String oldName, String newName) {
        if (!DescriptorEntityImpl.equals((Object)servlet.getRunAsRoleName(), (Object)oldName)) {
            return;
        }
        try {
            if (servlet.canSetRunAsRoleName(newName)) {
                servlet.setRunAsRoleName(newName);
            } else {
                UtilsPlugin.logWarning((String)("Unable to synchronize run as security role name of servlet " + servlet.getName()));
            }
        }
        catch (Exception e) {
            UtilsPlugin.logError((String)("Unable to synchronize run as security role name of servlet " + servlet.getName()), (Throwable)e);
        }
    }

    private void syncServletRoleRefs(Servlet servlet, String oldName, String newName) {
        SecurityRoleRef[] refs = servlet.getSecurityRoleReferences();
        if (refs == null || refs.length == 0) {
            return;
        }
        int i = 0;
        while (i < refs.length) {
            SecurityRoleRef ref = refs[i];
            if (DescriptorEntityImpl.equals((Object)ref.getLink(), (Object)oldName)) {
                try {
                    if (ref.canSetLink(newName)) {
                        ref.setLink(newName);
                    } else {
                        UtilsPlugin.logWarning((String)("Unable to synchronize security role reference of servlet " + servlet.getName()));
                    }
                }
                catch (Exception e) {
                    UtilsPlugin.logError((String)("Unable to synchronize security role reference of servlet " + servlet.getName()), (Throwable)e);
                }
            }
            ++i;
        }
    }

    private void syncSecurityConstraints(String oldName, String newName) {
        SecurityConstraint[] constraints = this.getWebAppImpl().getSecurityConstraints();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        int i = 0;
        while (i < constraints.length) {
            SecurityConstraint constraint = constraints[i];
            Object[] roles = constraint.getAuthConstraintSecurityRoles();
            if (roles != null && roles.length != 0 && ArrayUtils.contains((Object[])roles, (Object)oldName)) {
                roles = newName == null ? ArrayUtils.removeString((String[])roles, (String)oldName) : ArrayUtils.replaceString((String[])roles, (String)oldName, (String)newName);
                try {
                    if (constraint.canSetAuthConstraintSecurityRoles((String[])roles)) {
                        constraint.setAuthConstraintSecurityRoles((String[])roles);
                    } else {
                        UtilsPlugin.logWarning((String)("Unable to synchronize security roles of security constraint " + constraint.getSyntheticName()));
                    }
                }
                catch (Exception e) {
                    UtilsPlugin.logError((String)("Unable to synchronize security roles of security constraint " + constraint.getSyntheticName()), (Throwable)e);
                }
            }
            ++i;
        }
    }

    protected String[] getChildOrder() {
        return WebAppChildOrder.SECURITY_ROLE;
    }

    private WebAppImpl getWebAppImpl() {
        return (WebAppImpl)this.getParent();
    }
}

