/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.webapp;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.webapp.SecurityConstraint;
import com.tssap.j2ee.core.webapp.WebAppMetaInfo;
import com.tssap.j2ee.core.webapp.WebResourceCollection;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import com.tssap.j2ee.internal.core.webapp.WebAppChildOrder;
import com.tssap.j2ee.internal.core.webapp.WebAppImpl;
import com.tssap.j2ee.internal.core.webapp.WebResourceCollectionImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.w3c.dom.Element;

final class SecurityConstraintImpl
extends DescriptorEntityImpl
implements SecurityConstraint {
    private String mySyntheticName;
    private Map myWebResourceCollections;

    public SecurityConstraintImpl(WebAppImpl parent, Element element, String syntheticName) {
        super((DescriptorEntityImpl)parent, element);
        this.mySyntheticName = syntheticName;
    }

    public String toString() {
        return "SecurityConstraint \"" + this.getSyntheticName() + "\"";
    }

    public void delete() {
        if (!this.edit(null)) {
            return;
        }
        final String oldName = this.getSyntheticName();
        this.modify(new Runnable(){

            public void run() {
                SecurityConstraintImpl.super.delete();
                SecurityConstraintImpl.this.getWebAppImpl().updateSecurityConstraint(oldName);
            }
        });
    }

    public String getSyntheticName() {
        return this.mySyntheticName;
    }

    public String getDisplayName() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"display-name");
    }

    public boolean canSetDisplayName(String name) {
        return true;
    }

    public void setDisplayName(String name) {
        if (!this.canSetDisplayName(name)) {
            throw new IllegalArgumentException(name);
        }
        if (DescriptorEntityImpl.equals((Object)this.getDisplayName(), (Object)name)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])WebAppChildOrder.SECURITY_CONSTRAINT, (String)"display-name", (String)name);
        this.changed((DescriptorEntity)this);
    }

    private Element getAuthConstraint(boolean create) {
        Element authConstraint = DomUtils.getChildElement((Element)this.getElement(), (String)"auth-constraint");
        if (authConstraint == null && create) {
            authConstraint = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.SECURITY_CONSTRAINT, (String)"auth-constraint");
        }
        return authConstraint;
    }

    public String getAuthConstraintDescription() {
        Element authConstraint = this.getAuthConstraint(false);
        if (authConstraint == null) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)authConstraint, (String)"description");
    }

    public boolean canSetAuthConstraintDescription(String description) {
        Element authConstraint = this.getAuthConstraint(false);
        return authConstraint != null;
    }

    public void setAuthConstraintDescription(String description) {
        if (!this.canSetAuthConstraintDescription(description)) {
            throw new IllegalArgumentException(description);
        }
        if (DescriptorEntityImpl.equals((Object)this.getAuthConstraintDescription(), (Object)description)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        Element authConstraint = this.getAuthConstraint(false);
        DomUtils.setChildTextNodeValue((Element)authConstraint, (String[])WebAppChildOrder.AUTH_CONSTRAINT, (String)"description", (String)description);
        this.changed((DescriptorEntity)this);
    }

    public String[] getAuthConstraintSecurityRoles() {
        Element authConstraint = this.getAuthConstraint(false);
        if (authConstraint == null) {
            return null;
        }
        Element[] roles = DomUtils.getChildElements((Element)authConstraint, (String)"role-name");
        if (roles == null || roles.length == 0) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>(roles.length);
        int i = 0;
        while (i < roles.length) {
            names.add(DomUtils.getTextNodeValue((Element)roles[i]));
            ++i;
        }
        return names.toArray(new String[names.size()]);
    }

    public boolean canSetAuthConstraintSecurityRoles(String[] names) {
        if (names == null || names.length == 0) {
            return true;
        }
        HashSet<String> accepted = new HashSet<String>(names.length);
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            if (DescriptorEntityImpl.isNull((String)name) || accepted.contains(name)) {
                return false;
            }
            accepted.add(name);
            ++i;
        }
        return true;
    }

    public void setAuthConstraintSecurityRoles(String[] names) {
        if (!this.canSetAuthConstraintSecurityRoles(names)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return;
        }
        Element authConstraint = this.getAuthConstraint(false);
        if (authConstraint != null) {
            DomUtils.removeChildNodes((Element)authConstraint, (String)"role-name");
        }
        if (names != null && names.length > 0) {
            if (authConstraint == null) {
                authConstraint = this.getAuthConstraint(true);
            }
            int i = 0;
            while (i < names.length) {
                DomUtils.createChildTextNode((Element)authConstraint, (String[])WebAppChildOrder.AUTH_CONSTRAINT, (String)"role-name").setNodeValue(names[i]);
                ++i;
            }
        } else {
            DomUtils.removeChildNodes((Element)this.getElement(), (String)"auth-constraint");
            DomUtils.removeIfEmpty((Element)this.getElement(), (String)"web-app");
        }
        this.changed((DescriptorEntity)this);
    }

    private Element getDataConstraint(boolean create) {
        Element dataConstraint = DomUtils.getChildElement((Element)this.getElement(), (String)"user-data-constraint");
        if (dataConstraint == null && create) {
            dataConstraint = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.SECURITY_CONSTRAINT, (String)"user-data-constraint");
        }
        return dataConstraint;
    }

    public String getDataConstraintDescription() {
        Element dataConstraint = this.getDataConstraint(false);
        if (dataConstraint == null) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)dataConstraint, (String)"description");
    }

    public boolean canSetDataConstraintDescription(String description) {
        Element dataConstraint = this.getDataConstraint(false);
        return dataConstraint != null;
    }

    public void setDataConstraintDescription(String description) {
        if (!this.canSetDataConstraintDescription(description)) {
            throw new IllegalArgumentException(description);
        }
        if (DescriptorEntityImpl.equals((Object)this.getDataConstraintDescription(), (Object)description)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        Element dataConstraint = this.getDataConstraint(false);
        DomUtils.setChildTextNodeValue((Element)dataConstraint, (String[])WebAppChildOrder.USER_DATA_CONSTRAINT, (String)"description", (String)description);
        this.changed((DescriptorEntity)this);
    }

    public String getDataConstraintTransportGuarantee() {
        Element dataConstraint = this.getDataConstraint(false);
        if (dataConstraint == null) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)dataConstraint, (String)"transport-guarantee");
    }

    public boolean canSetDataConstraintTransportGuarantee(String type) {
        if (DescriptorEntityImpl.isNull((String)type)) {
            return true;
        }
        return WebAppMetaInfo.isValidTransportGuarantee((String)type);
    }

    public void setDataConstraintTransportGuarantee(String type) {
        if (!this.canSetDataConstraintTransportGuarantee(type)) {
            throw new IllegalArgumentException(type);
        }
        if (DescriptorEntityImpl.equals((Object)this.getDataConstraintTransportGuarantee(), (Object)type)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        if (DescriptorEntityImpl.isNull((String)type)) {
            DomUtils.removeChildNodes((Element)this.getElement(), (String)"user-data-constraint");
            DomUtils.removeIfEmpty((Element)this.getElement(), (String)"web-app");
        } else {
            Element dataConstraint = this.getDataConstraint(true);
            DomUtils.setChildTextNodeValue((Element)dataConstraint, (String[])WebAppChildOrder.USER_DATA_CONSTRAINT, (String)"transport-guarantee", (String)type);
        }
        this.changed((DescriptorEntity)this);
    }

    protected void readWebResourceCollections() {
        if (this.myWebResourceCollections == null) {
            this.myWebResourceCollections = new HashMap();
            Element[] nodes = DomUtils.getChildElements((Element)this.getElement(), (String)"web-resource-collection");
            int i = 0;
            while (i < nodes.length) {
                WebResourceCollectionImpl collection = new WebResourceCollectionImpl(this, nodes[i]);
                String name = collection.getName();
                if (!DescriptorEntityImpl.isNull((String)name) && !this.myWebResourceCollections.containsKey(name)) {
                    this.myWebResourceCollections.put(name, collection);
                }
                ++i;
            }
        }
    }

    protected void updateWebResourceCollection(String name) {
        WebResourceCollection collection;
        if (this.myWebResourceCollections != null && (collection = (WebResourceCollection)this.myWebResourceCollections.remove(name)) != null && collection.isValid()) {
            this.myWebResourceCollections.put(collection.getName(), collection);
        }
    }

    public WebResourceCollection[] getWebResourceCollections() {
        this.readWebResourceCollections();
        return this.myWebResourceCollections.values().toArray(new WebResourceCollection[this.myWebResourceCollections.values().size()]);
    }

    public WebResourceCollection getWebResourceCollection(String name) {
        this.readWebResourceCollections();
        return (WebResourceCollection)this.myWebResourceCollections.get(name);
    }

    public boolean canCreateWebResourceCollection(String name, String description, String[] urlPatterns, String[] httpMethods) {
        int i;
        this.readWebResourceCollections();
        if (DescriptorEntityImpl.isNull((String)name) || this.myWebResourceCollections.containsKey(name)) {
            return false;
        }
        if (urlPatterns != null && urlPatterns.length > 0) {
            i = 0;
            while (i < urlPatterns.length) {
                if (DescriptorEntityImpl.isNull((String)urlPatterns[i])) {
                    return false;
                }
                ++i;
            }
        }
        if (httpMethods != null && httpMethods.length > 0) {
            i = 0;
            while (i < httpMethods.length) {
                if (!WebAppMetaInfo.isValidHttpMethod((String)httpMethods[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public WebResourceCollection createWebResourceCollection(String name, String description, String[] urlPatterns, String[] httpMethods) {
        int i;
        if (!this.canCreateWebResourceCollection(name, description, urlPatterns, httpMethods)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element collectionElement = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.SECURITY_CONSTRAINT, (String)"web-resource-collection");
        DomUtils.setChildTextNodeValue((Element)collectionElement, (String[])WebAppChildOrder.WEB_RESOURCE_COLLECTION, (String)"web-resource-name", (String)name);
        if (description != null) {
            DomUtils.setChildTextNodeValue((Element)collectionElement, (String[])WebAppChildOrder.WEB_RESOURCE_COLLECTION, (String)"description", (String)description);
        }
        if (urlPatterns != null && urlPatterns.length > 0) {
            i = 0;
            while (i < urlPatterns.length) {
                DomUtils.createChildTextNode((Element)collectionElement, (String[])WebAppChildOrder.WEB_RESOURCE_COLLECTION, (String)"url-pattern").setNodeValue(urlPatterns[i]);
                ++i;
            }
        }
        if (httpMethods != null && httpMethods.length > 0) {
            i = 0;
            while (i < httpMethods.length) {
                DomUtils.createChildTextNode((Element)collectionElement, (String[])WebAppChildOrder.WEB_RESOURCE_COLLECTION, (String)"http-method").setNodeValue(httpMethods[i]);
                ++i;
            }
        }
        WebResourceCollectionImpl collection = new WebResourceCollectionImpl(this, collectionElement);
        this.myWebResourceCollections.put(name, collection);
        this.added((DescriptorEntity)collection);
        return collection;
    }

    private WebAppImpl getWebAppImpl() {
        return (WebAppImpl)this.getParent();
    }
}

