/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.webapp;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.webapp.LoginConfig;
import com.tssap.j2ee.core.webapp.WebAppMetaInfo;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import com.tssap.j2ee.internal.core.webapp.WebAppChildOrder;
import com.tssap.j2ee.internal.core.webapp.WebAppImpl;
import org.w3c.dom.Element;

final class LoginConfigImpl
extends DescriptorEntityImpl
implements LoginConfig {
    public LoginConfigImpl(WebAppImpl webApp, Element webAppElement) {
        super((DescriptorEntityImpl)webApp, webAppElement);
    }

    private Element getLoginConfig(boolean create) {
        Element config = DomUtils.getChildElement((Element)this.getElement(), (String)"login-config");
        if (config == null && create) {
            config = DomUtils.createChildElement((Element)this.getElement(), (String[])WebAppChildOrder.WEB_APP, (String)"login-config");
        }
        return config;
    }

    private Element getFormLoginConfig(boolean create) {
        Element config = this.getLoginConfig(create);
        if (config == null) {
            return null;
        }
        Element formConfig = DomUtils.getChildElement((Element)config, (String)"form-login-config");
        if (formConfig == null && create) {
            formConfig = DomUtils.createChildElement((Element)config, (String[])WebAppChildOrder.LOGIN_CONFIG, (String)"form-login-config");
        }
        return formConfig;
    }

    public String getAuthMethod() {
        if (!this.getDocument().isRecognized()) {
            return null;
        }
        Element config = this.getLoginConfig(false);
        if (config == null) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)config, (String)"auth-method");
    }

    public boolean canSetAuthMethod(String method) {
        if (!this.getDocument().isRecognized()) {
            return false;
        }
        return WebAppMetaInfo.isValidAuthMethod((String)method);
    }

    public void setAuthMethod(String method) {
        if (!this.canSetAuthMethod(method)) {
            throw new IllegalArgumentException(method);
        }
        if (DescriptorEntityImpl.equals((Object)this.getAuthMethod(), (Object)method)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        Element config = this.getLoginConfig(true);
        DomUtils.setChildTextNodeValue((Element)config, (String[])WebAppChildOrder.LOGIN_CONFIG, (String)"auth-method", (String)method);
        DomUtils.removeIfEmpty((Element)config, (String)"web-app");
        this.changed((DescriptorEntity)this);
    }

    public String getRealmName() {
        if (!this.getDocument().isRecognized()) {
            return null;
        }
        Element config = this.getLoginConfig(false);
        if (config == null) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)config, (String)"realm-name");
    }

    public boolean canSetRealmName(String name) {
        return this.getDocument().isRecognized();
    }

    public void setRealmName(String name) {
        if (!this.canSetRealmName(name)) {
            throw new IllegalArgumentException(name);
        }
        if (DescriptorEntityImpl.equals((Object)this.getRealmName(), (Object)name)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        Element config = this.getLoginConfig(true);
        DomUtils.setChildTextNodeValue((Element)config, (String[])WebAppChildOrder.LOGIN_CONFIG, (String)"realm-name", (String)name);
        DomUtils.removeIfEmpty((Element)config, (String)"web-app");
        this.changed((DescriptorEntity)this);
    }

    public String getFormLoginPage() {
        if (!this.getDocument().isRecognized()) {
            return null;
        }
        Element config = this.getFormLoginConfig(false);
        if (config == null) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)config, (String)"form-login-page");
    }

    public boolean canSetFormLoginPage(String page) {
        if (!this.getDocument().isRecognized()) {
            return false;
        }
        return page == null || page.startsWith("/");
    }

    public void setFormLoginPage(String page) {
        if (!this.canSetFormLoginPage(page)) {
            throw new IllegalArgumentException(page);
        }
        if (DescriptorEntityImpl.equals((Object)this.getFormLoginPage(), (Object)page)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        Element config = this.getFormLoginConfig(true);
        DomUtils.setChildTextNodeValue((Element)config, (String[])WebAppChildOrder.FORM_LOGIN_CONFIG, (String)"form-login-page", (String)page);
        DomUtils.removeIfEmpty((Element)config, (String)"web-app");
        this.changed((DescriptorEntity)this);
    }

    public String getFormErrorPage() {
        if (!this.getDocument().isRecognized()) {
            return null;
        }
        Element config = this.getFormLoginConfig(false);
        if (config == null) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)config, (String)"form-error-page");
    }

    public boolean canSetFormErrorPage(String page) {
        if (!this.getDocument().isRecognized()) {
            return false;
        }
        return page == null || page.startsWith("/");
    }

    public void setFormErrorPage(String page) {
        if (!this.canSetFormErrorPage(page)) {
            throw new IllegalArgumentException(page);
        }
        if (DescriptorEntityImpl.equals((Object)this.getFormErrorPage(), (Object)page)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        Element config = this.getFormLoginConfig(true);
        DomUtils.setChildTextNodeValue((Element)config, (String[])WebAppChildOrder.FORM_LOGIN_CONFIG, (String)"form-error-page", (String)page);
        DomUtils.removeIfEmpty((Element)config, (String)"web-app");
        this.changed((DescriptorEntity)this);
    }

    public long getIncarnationNumber() {
        return ((DescriptorEntityImpl)this.getParent()).getIncarnationNumber();
    }
}

