/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.webapp;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.webapp.ErrorPage;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import com.tssap.j2ee.internal.core.webapp.WebAppChildOrder;
import com.tssap.j2ee.internal.core.webapp.WebAppImpl;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.w3c.dom.Element;

final class ErrorPageImpl
extends DescriptorEntityImpl
implements ErrorPage {
    public ErrorPageImpl(WebAppImpl parent, Element element) {
        super((DescriptorEntityImpl)parent, element);
    }

    public String toString() {
        Integer code = this.getCode();
        return "ErrorPage \"" + (code != null ? code.toString() : this.getException()) + "\"";
    }

    public void delete() {
        if (!this.edit(null)) {
            return;
        }
        final Integer oldCode = this.getCode();
        final String oldException = this.getException();
        this.modify(new Runnable(){

            public void run() {
                ErrorPageImpl.super.delete();
                if (oldCode == null) {
                    ErrorPageImpl.this.getWebAppImpl().updateErrorPage(oldException);
                } else {
                    ErrorPageImpl.this.getWebAppImpl().updateErrorPage(oldCode);
                }
            }
        });
    }

    public Integer getCode() {
        try {
            return Integer.valueOf(DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"error-code"));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getException() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"exception-type");
    }

    public boolean canSetReason(Integer code, String exception) {
        if (code == null) {
            if (DescriptorEntityImpl.isNull((String)exception)) {
                return false;
            }
            if (exception.equals(this.getException())) {
                return true;
            }
            IStatus status = JavaConventions.validateJavaTypeName((String)exception);
            if (status == null || !status.isOK()) {
                return false;
            }
            return this.getWebAppImpl().getErrorPage(exception) == null;
        }
        if (DescriptorEntityImpl.isNull((String)exception)) {
            if (code == null) {
                return false;
            }
            if (code.equals(this.getCode())) {
                return true;
            }
            if (code < 0) {
                return false;
            }
            return this.getWebAppImpl().getErrorPage(code) == null;
        }
        return false;
    }

    public void setReason(Integer code, String exception) {
        if (!this.canSetReason(code, exception)) {
            throw new IllegalArgumentException();
        }
        Integer oldCode = this.getCode();
        String oldException = this.getException();
        if (code == null) {
            if (oldCode == null && exception.equals(oldException)) {
                return;
            }
            if (!this.edit(null)) {
                return;
            }
            DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])WebAppChildOrder.ERROR_PAGE, (String)"exception-type", (String)exception);
            DomUtils.removeChildNodes((Element)this.getElement(), (String)"error-code");
        } else if (DescriptorEntityImpl.isNull((String)exception)) {
            if (DescriptorEntityImpl.isNull((String)oldException) && code.equals(oldCode)) {
                return;
            }
            if (!this.edit(null)) {
                return;
            }
            DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])WebAppChildOrder.ERROR_PAGE, (String)"error-code", (String)code.toString());
            DomUtils.removeChildNodes((Element)this.getElement(), (String)"exception-type");
        } else {
            throw new IllegalStateException();
        }
        if (oldCode == null) {
            this.getWebAppImpl().updateErrorPage(oldException);
        } else {
            this.getWebAppImpl().updateErrorPage(oldCode);
        }
        this.changed((DescriptorEntity)this);
    }

    public String getLocation() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"location");
    }

    public boolean canSetLocation(String location) {
        return ErrorPageImpl.isValidErrorPageLocation(location);
    }

    public void setLocation(String location) {
        if (!this.canSetLocation(location)) {
            throw new IllegalArgumentException(location);
        }
        if (DescriptorEntityImpl.equals((Object)this.getLocation(), (Object)location)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])WebAppChildOrder.ERROR_PAGE, (String)"location", (String)location);
        this.changed((DescriptorEntity)this);
    }

    protected static boolean isValidErrorPageLocation(String location) {
        return location != null && location.length() > 0 && '/' == location.charAt(0);
    }

    private WebAppImpl getWebAppImpl() {
        return (WebAppImpl)this.getParent();
    }
}

