/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm;

import com.sap.util.monitor.jarm.ApplThreadMonitor;
import com.sap.util.monitor.jarm.ConfMonitor;
import com.sap.util.monitor.jarm.MonitorConsumer;
import com.sap.util.monitor.jarm.ReqMonitor;

class CondenseThread
implements Runnable {
    private static Thread condenseThread = null;
    private static long readyListStartTS;
    private static long readyListEndTS;
    private static int reqMonCount;
    private static boolean pause;
    private static Object pauseLockObj;
    private static Object wakeUpObj;

    protected CondenseThread() {
    }

    protected static synchronized boolean condenseThreadActive() {
        return condenseThread != null && condenseThread.isAlive();
    }

    private static synchronized boolean thisThreadShouldStart() {
        if (condenseThread != null && condenseThread.isAlive()) {
            return false;
        }
        condenseThread = Thread.currentThread();
        return true;
    }

    private static synchronized void thisThreadShouldStop() {
        condenseThread = null;
    }

    protected static void pause() {
        pause = true;
        Object object = pauseLockObj;
        synchronized (object) {
        }
    }

    protected static void resume() {
        pause = false;
    }

    protected static void wakeUp() {
        Object object = wakeUpObj;
        synchronized (object) {
            wakeUpObj.notify();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        if (CondenseThread.thisThreadShouldStart()) {
            do {
                Object object = pauseLockObj;
                synchronized (object) {
                    ReqMonitor reqMon;
                    reqMonCount = 0;
                    readyListStartTS = System.currentTimeMillis();
                    while (!pause && (reqMon = ReqMonitor.getReadyList()) != null) {
                        void var1_1;
                        var1_1.updComponents();
                        if (ConfMonitor.initUserSwitch == 1) {
                            var1_1.updUser();
                        }
                        if (!var1_1.updTopRequests()) {
                            var1_1.freeRequest(0);
                        }
                        ++reqMonCount;
                    }
                    if (!pause) {
                        ApplThreadMonitor.getApplThreads(true);
                        this.startConsumerThreads();
                    } else if (2 <= ConfMonitor.initLogLevel) {
                        ConfMonitor.logWriteInfo(2, "CondenseThread: pause");
                    }
                    if (2 <= ConfMonitor.initLogLevel) {
                        readyListEndTS = System.currentTimeMillis();
                        ConfMonitor.logWriteInfo(2, "CondenseThread: duration (ms): " + (readyListEndTS - readyListStartTS) + ", condensed requests: " + reqMonCount);
                    }
                }
            } while (this.threadShouldContinue());
            CondenseThread.thisThreadShouldStop();
        }
    }

    private boolean threadShouldContinue() {
        try {
            Object object = wakeUpObj;
            synchronized (object) {
                if (!pause) {
                    wakeUpObj.wait(ConfMonitor.initCondenseSleep);
                } else {
                    wakeUpObj.wait(ConfMonitor.initCondensePauseSleep);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private void startConsumerThreads() {
        if (MonitorConsumer.firstConsumer != null) {
            MonitorConsumer nextConsumer = MonitorConsumer.firstConsumer;
            long currentTS = System.currentTimeMillis();
            do {
                nextConsumer.checkAndStart(currentTS);
            } while ((nextConsumer = nextConsumer.succ) != null);
        }
    }

    static {
        pause = false;
        pauseLockObj = new Object();
        wakeUpObj = new Object();
    }
}

