/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.selector;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ObjectsRegistry {
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String ID_ATTRIBUTE = "id";
    private Map myObjects;
    private IExtensionPoint myExtensionPoint;
    private String myNameAttribute;
    private Class myObjectClass;

    public ObjectsRegistry(IExtensionPoint iExtensionPoint, String string, Class clazz) {
        this.myExtensionPoint = iExtensionPoint;
        this.myNameAttribute = string;
        this.myObjectClass = clazz;
    }

    public String[] getObjectIds() {
        this.loadObjects();
        Set set = this.getObjects().keySet();
        return set.toArray(new String[set.size()]);
    }

    public Object getObject(String string) {
        this.loadObjects();
        return this.myObjects.get(string);
    }

    public Map getObjects() {
        this.loadObjects();
        return this.myObjects;
    }

    private void loadObjects() {
        if (this.myObjects == null) {
            this.myObjects = new HashMap();
            if (this.myExtensionPoint != null) {
                IConfigurationElement[] iConfigurationElementArray = this.myExtensionPoint.getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    this.loadObject(iConfigurationElementArray[n2]);
                    ++n2;
                }
            }
        }
    }

    private void loadObject(IConfigurationElement iConfigurationElement) {
        String string;
        if (iConfigurationElement.getName().equals(this.myNameAttribute) && (string = iConfigurationElement.getAttribute(ID_ATTRIBUTE)) != null) {
            Object object = null;
            try {
                object = iConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException coreException) {
                try {
                    IPluginDescriptor iPluginDescriptor = iConfigurationElement.getDeclaringExtension().getDeclaringPluginDescriptor();
                    String string2 = iPluginDescriptor.getUniqueIdentifier();
                    String string3 = "Unable to create instance of [" + iConfigurationElement.getAttribute(CLASS_ATTRIBUTE) + "]";
                    iPluginDescriptor.getPlugin().getLog().log((IStatus)new Status(4, string2, 0, string3, (Throwable)coreException));
                }
                catch (CoreException coreException2) {
                    throw new RuntimeException("Unable to properly log error message: " + coreException2.getMessage());
                }
            }
            if (this.myObjectClass.isInstance(object)) {
                this.myObjects.put(string, object);
            }
        }
    }
}

