/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.selector;

import com.togethersoft.selena.selector.Acceptor;
import com.togethersoft.selena.selector.DefaultSelectorCustomizer;
import com.togethersoft.selena.selector.SelectorPlugin;
import com.togethersoft.selena.selector.SourceAwareAcceptor;
import com.togethersoft.selena.selector.SourceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class GenericDefaultSelectorCustomizer
implements DefaultSelectorCustomizer,
SourceAwareAcceptor {
    private boolean mySetOnlyMode;
    private Class[] myTargetClasses;
    private String[] mySourceProviderIds;
    private String[] myDisabledSourceProviderIds;
    private Map mySourceInputs;
    private Map mySourceObjects;
    private Collection myTargetObjects;
    private Collection myAcceptors;
    private String myTitle;
    private String myTargetTitle;

    public GenericDefaultSelectorCustomizer() {
    }

    public GenericDefaultSelectorCustomizer(Class[] classArray) {
        this.myTargetClasses = classArray;
    }

    public GenericDefaultSelectorCustomizer(String[] stringArray, Class[] classArray) {
        this(classArray);
        this.mySourceProviderIds = stringArray;
    }

    public void setTitle(String string) {
        this.myTitle = string;
    }

    public boolean isSetOnlyMode() {
        return this.mySetOnlyMode;
    }

    public void setSetOnlyMode(boolean bl) {
        this.mySetOnlyMode = bl;
    }

    public void setTargetClasses(Class[] classArray) {
        this.myTargetClasses = classArray;
    }

    public void setSourceProviderIds(String[] stringArray) {
        this.mySourceProviderIds = stringArray;
    }

    public void setDisabledSourceProviderIds(String[] stringArray) {
        this.myDisabledSourceProviderIds = stringArray;
    }

    public Object getSourceInput(String string) {
        return this.mySourceInputs == null ? null : this.mySourceInputs.get(string);
    }

    public void setSourceInput(String string, Object object) {
        if (this.mySourceInputs == null) {
            this.mySourceInputs = new HashMap();
        }
        this.mySourceInputs.put(string, object);
    }

    public Collection getSourceObjects(String string) {
        return this.mySourceObjects == null ? null : (Collection)this.mySourceObjects.get(string);
    }

    public void setSourceObjects(String string, Collection collection) {
        if (this.mySourceObjects == null) {
            this.mySourceObjects = new HashMap();
        }
        this.mySourceObjects.put(string, collection);
    }

    public Collection getTargetObjects() {
        return this.myTargetObjects;
    }

    public void setTargetObjects(Collection collection) {
        this.myTargetObjects = collection;
    }

    public String[] getSourceProviderIds() {
        String[] stringArray = this.mySourceProviderIds;
        if (stringArray == null) {
            stringArray = SelectorPlugin.getSourceProviderIds();
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        int n2 = 0;
        while (n2 < stringArray.length) {
            SourceProvider sourceProvider;
            String string = stringArray[n2];
            if (string != null && !this.isDisabled(string) && (sourceProvider = SelectorPlugin.getSourceProvider(string)) != null && this.hasTarget(sourceProvider)) {
                arrayList.add(string);
            }
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean hasTarget(SourceProvider sourceProvider) {
        Class[] classArray = this.myTargetClasses;
        if (classArray == null) {
            return true;
        }
        int n2 = 0;
        while (n2 < classArray.length) {
            Class clazz = classArray[n2];
            if (clazz != null && sourceProvider.getSourceTransformer(clazz) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isDisabled(String string) {
        if (this.myDisabledSourceProviderIds != null) {
            int n2 = 0;
            while (n2 < this.myDisabledSourceProviderIds.length) {
                String string2 = this.myDisabledSourceProviderIds[n2];
                if (string2 != null && string2.equals(string)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean accept(Collection collection, Collection collection2) {
        if (this.myAcceptors == null) {
            return true;
        }
        Iterator iterator = this.myAcceptors.iterator();
        while (iterator.hasNext()) {
            Acceptor acceptor = (Acceptor)iterator.next();
            if (acceptor.accept(collection, collection2)) continue;
            return false;
        }
        return true;
    }

    public Collection getSelectedObjects(Collection collection) {
        if (this.myAcceptors == null) {
            return collection;
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = this.myAcceptors.iterator();
        while (iterator.hasNext()) {
            Acceptor acceptor = (Acceptor)iterator.next();
            hashSet.addAll(acceptor.getSelectedObjects(collection));
        }
        return hashSet;
    }

    public void setSourceProvider(SourceProvider sourceProvider) {
        if (this.myAcceptors == null) {
            return;
        }
        Iterator iterator = this.myAcceptors.iterator();
        while (iterator.hasNext()) {
            Acceptor acceptor = (Acceptor)iterator.next();
            if (!(acceptor instanceof SourceAwareAcceptor)) continue;
            ((SourceAwareAcceptor)acceptor).setSourceProvider(sourceProvider);
        }
    }

    public void addAcceptor(Acceptor acceptor) {
        if (this.myAcceptors == null) {
            this.myAcceptors = new ArrayList();
        }
        this.myAcceptors.add(acceptor);
    }

    public String getTitle() {
        return this.myTitle;
    }

    public String getTargetTitle() {
        return this.myTargetTitle;
    }

    public void setTargetTitle(String string) {
        this.myTargetTitle = string;
    }
}

