/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.portalapp;

import com.sap.tc.buildplugin.PluginBuildInfo;
import com.sap.tc.buildplugin.util.ComponentDependencies;
import com.sap.tc.buildplugin.util.JavaTools;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;

public class PortalDCJavaTools
extends JavaTools {
    private static final String PP_SUBDIR_PORTAL = "portal";

    public PortalDCJavaTools(PluginBuildInfo pluginBuildInfo) {
        super(pluginBuildInfo);
    }

    public void createFSDescriptors(String dc_gen_tempDir, String dc_name, String deploymentDir) throws IOException {
        StringBuffer sb = new StringBuffer(500);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        sb.append("<SDA name=\"" + dc_name + ".sda\">\n");
        sb.append("  <SoftwareType>FS</SoftwareType>\n");
        sb.append("  <fs-deployment-descriptor version=\"1.0\">\n");
        sb.append("    <display-name>Filesets for " + dc_name + "</display-name>\n");
        sb.append("    <fileset id=\"" + dc_name + "\">\n");
        sb.append("      <display-name>" + dc_name + "</display-name>\n");
        sb.append("      <description>" + dc_name + "</description>\n");
        sb.append("      <default-deployment-dir>" + deploymentDir + "</default-deployment-dir>\n");
        sb.append("    </fileset>\n");
        sb.append("  </fs-deployment-descriptor>\n");
        sb.append("</SDA>");
        String fileName = dc_gen_tempDir + "/portalapp-dd.xml";
        this.storeFile(fileName, sb.toString());
    }

    public void createEARDescriptors(String dc_gen_tempDir, String dc_name, String dc_vendor, String dc_deploy_File, List dependencies) throws IOException {
        StringBuffer sb = new StringBuffer(500);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        sb.append("<SDA>\n");
        sb.append("  <SoftwareType>J2EE</SoftwareType>\n");
        sb.append("  <engine-deployment-descriptor version=\"2.0\"/>\n");
        sb.append("</SDA>");
        this.storeFile(dc_gen_tempDir + "/portalapp-dd.xml", sb.toString());
        sb = new StringBuffer(1000);
        sb.append("<?xml version=\"1.0\" ?>\n");
        sb.append("<application>\n");
        sb.append("  <display-name>" + dc_name + "</display-name>\n");
        sb.append("  <description>" + dc_name + "</description>\n");
        sb.append("</application>\n");
        this.storeFile(dc_gen_tempDir + "/META-INF/application.xml", sb.toString());
        sb = new StringBuffer(1000);
        sb.append("<?xml version=\"1.0\" ?>\n");
        sb.append("<application-j2ee-engine>\n");
        sb.append("  <provider-name>" + dc_vendor + "</provider-name>\n");
        sb.append("  <modules-additional>\n");
        sb.append("    <module>\n");
        sb.append("      <entry-name>" + dc_deploy_File + "</entry-name>\n");
        sb.append("      <container-type>PortalRuntimeContainer</container-type>\n");
        sb.append("    </module>\n");
        int i = 0;
        while (i < dependencies.size()) {
            ComponentDependencies cd = (ComponentDependencies)dependencies.get(i);
            if (cd.getAtBuild()) {
                List ppNames = cd.getPublicPartNames();
                int j = 0;
                while (j < ppNames.size()) {
                    File[] files;
                    String rootPath;
                    File f;
                    String ppName = (String)ppNames.get(j);
                    if ("assembly".equals(cd.getPublicPartPurpose(ppName)) && (f = new File(rootPath = cd.getPublicPartRootPath(ppName), PP_SUBDIR_PORTAL)).isDirectory() && (files = f.listFiles(new FileFilter(){

                        public boolean accept(File pathname) {
                            return pathname.isFile() && pathname.getName().endsWith(".par");
                        }
                    })) != null) {
                        int k = 0;
                        while (k < files.length) {
                            File file = files[k];
                            sb.append("    <module>\n");
                            sb.append("      <entry-name>" + file.getName() + "</entry-name>\n");
                            sb.append("      <container-type>PortalRuntimeContainer</container-type>\n");
                            sb.append("    </module>\n");
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        sb.append("  </modules-additional>\n");
        sb.append("</application-j2ee-engine>\n");
        this.storeFile(dc_gen_tempDir + "/META-INF/application-j2ee-engine.xml", sb.toString());
    }
}

