/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.security.http;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class DigestUtil {
    protected static final String DEFAULT_ALGORITHM = "MD5";
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static MessageDigest messageDigest() {
        try {
            return MessageDigest.getInstance(DEFAULT_ALGORITHM);
        }
        catch (NoSuchAlgorithmException f) {
            return null;
        }
    }

    public static MessageDigest messageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            try {
                return MessageDigest.getInstance(DEFAULT_ALGORITHM);
            }
            catch (NoSuchAlgorithmException f) {
                return null;
            }
        }
    }

    public static String md5Encode(byte[] binaryData) {
        if (binaryData.length != 16) {
            return null;
        }
        char[] buffer = new char[32];
        int i = 0;
        while (i < 16) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = hexadecimal[high];
            buffer[i * 2 + 1] = hexadecimal[low];
            ++i;
        }
        return new String(buffer);
    }
}

