/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.logging.descriptors;

import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import com.sap.engine.lib.logging.descriptors.PersistenceAdapter;
import com.sap.engine.lib.util.DeepCloneable;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.Severity;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.HashSet;

public class LogDestinationDescriptor
implements Serializable,
Cloneable,
DeepCloneable,
Comparable {
    public static final int VALUE_UNDEFINED = 0;
    private String type = null;
    private String name = null;
    private String prefix = null;
    private String pattern = null;
    private String encoding = null;
    private HashSet filters = new HashSet();
    private int limit = 0;
    private int count = 0;
    private int effectiveSeverity = 0;
    private LogFormatterDescriptor formatter = null;
    private transient PersistenceAdapter source = null;
    private transient Log realLog = null;

    public LogDestinationDescriptor() {
    }

    public LogDestinationDescriptor(PersistenceAdapter source) {
        this();
        this.source = source;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEffectiveSeverity() {
        return Severity.toString((int)this.effectiveSeverity);
    }

    public int getEffectiveSeverityInt() {
        return this.effectiveSeverity;
    }

    public void setEffectiveSeverity(String severity) {
        this.effectiveSeverity = Severity.parse((String)severity);
    }

    public void setEffectiveSeverity(int severity) {
        this.effectiveSeverity = severity;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String[] getFilters() {
        return ((AbstractCollection)this.filters).toArray(new String[this.filters.size()]);
    }

    public void setFilters(String[] filters) {
        this.removeFilters();
        if (filters != null) {
            this.addFilters(filters);
        }
    }

    public void addFilters(String[] filters) {
        int i = filters.length;
        while (--i >= 0) {
            this.filters.add(filters[i]);
        }
    }

    public void addFilter(String filter) {
        this.filters.add(filter);
    }

    public void removeFilter(String filter) {
        this.filters.remove(filter);
    }

    public void removeFilters() {
        this.filters.clear();
    }

    public boolean containsFilter(String filter) {
        return this.filters.contains(filter);
    }

    public LogFormatterDescriptor getFormatter() {
        return this.formatter;
    }

    public void setFormatter(LogFormatterDescriptor formatter) {
        this.formatter = formatter;
    }

    public PersistenceAdapter getPersistenceAdapter() {
        return this.source;
    }

    public void setPersistenceAdapter(PersistenceAdapter source) {
        this.source = source;
    }

    public Log getRealLog() {
        return this.realLog;
    }

    public void setRealLog(Log realLog) {
        this.realLog = realLog;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogDestinationDescriptor)) {
            return false;
        }
        LogDestinationDescriptor descr = (LogDestinationDescriptor)obj;
        if (!LogFormatterDescriptor.equals(this.name, descr.name)) {
            return false;
        }
        if (!LogFormatterDescriptor.equals(this.prefix, descr.prefix)) {
            return false;
        }
        if (!LogFormatterDescriptor.equals(this.type, descr.type)) {
            return false;
        }
        if (!LogFormatterDescriptor.equals(this.pattern, descr.pattern)) {
            return false;
        }
        if (!LogFormatterDescriptor.equals(this.encoding, descr.encoding)) {
            return false;
        }
        if (this.effectiveSeverity != descr.effectiveSeverity) {
            return false;
        }
        if (this.limit != descr.limit) {
            return false;
        }
        if (this.count != descr.count) {
            return false;
        }
        if (!this.filters.equals(descr.filters)) {
            return false;
        }
        return LogFormatterDescriptor.equals(this.formatter, descr.formatter);
    }

    public Object deepClone() {
        try {
            LogDestinationDescriptor descr = (LogDestinationDescriptor)super.clone();
            descr.filters = (HashSet)this.filters.clone();
            if (this.formatter != null) {
                descr.formatter = (LogFormatterDescriptor)this.formatter.deepClone();
            }
            return descr;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Object clone() {
        return this.deepClone();
    }

    public int compareTo(LogDestinationDescriptor descr) {
        return this.toString().compareTo(descr.toString());
    }

    public int compareTo(Object o) {
        return this.compareTo((LogDestinationDescriptor)o);
    }

    public String toString() {
        if (this.name != null) {
            if (this.prefix != null) {
                return this.prefix + this.name;
            }
            return this.name;
        }
        if (this.type != null) {
            return "Anonymous[ " + this.type + " ]";
        }
        return null;
    }
}

