/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

public class ConvertTools {
    public boolean littleEndian = false;

    public ConvertTools(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    public final short arrToShort(byte[] arr) {
        return this.arrToShort(arr, 0);
    }

    public final short arrToShort(byte[] arr, int offset) {
        int b1;
        int b2;
        if (arr.length < offset + 2 || offset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.littleEndian) {
            b2 = arr[offset] << 0 & 0xFF;
            b1 = arr[offset + 1] << 8 & 0xFF00;
        } else {
            b1 = arr[offset] << 8 & 0xFF00;
            b2 = arr[offset + 1] << 0 & 0xFF;
        }
        return (short)(b1 | b2);
    }

    public final int arrToInt(byte[] arr) {
        return this.arrToInt(arr, 0);
    }

    public final int arrToInt(byte[] arr, int offset) {
        int b1;
        int b2;
        int b3;
        int b4;
        if (arr.length < offset + 4 || offset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.littleEndian) {
            b4 = arr[offset] << 0 & 0xFF;
            b3 = arr[offset + 1] << 8 & 0xFF00;
            b2 = arr[offset + 2] << 16 & 0xFF0000;
            b1 = arr[offset + 3] << 24 & 0xFF000000;
        } else {
            b1 = arr[offset] << 24 & 0xFF000000;
            b2 = arr[offset + 1] << 16 & 0xFF0000;
            b3 = arr[offset + 2] << 8 & 0xFF00;
            b4 = arr[offset + 3] << 0 & 0xFF;
        }
        return b1 | b2 | b3 | b4;
    }

    public final long arrToLong(byte[] arr) {
        return this.arrToLong(arr, 0);
    }

    public final long arrToLong(byte[] arr, int offset) {
        long i1;
        long i2;
        if (arr.length < offset + 8 || offset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] arr1 = new byte[]{arr[offset], arr[offset + 1], arr[offset + 2], arr[offset + 3]};
        byte[] arr2 = new byte[]{arr[offset + 4], arr[offset + 5], arr[offset + 6], arr[offset + 7]};
        if (this.littleEndian) {
            i2 = (long)this.arrToInt(arr1) & 0xFFFFFFFFL;
            i1 = (long)this.arrToInt(arr2) << 32;
        } else {
            i1 = (long)this.arrToInt(arr1) << 32;
            i2 = (long)this.arrToInt(arr2) & 0xFFFFFFFFL;
        }
        return i1 | i2;
    }

    public final byte[] longToArr(long x) {
        byte[] arr = new byte[8];
        this.longToArr(x, arr, 0);
        return arr;
    }

    public final void longToArr(long x, byte[] arr, int offset) {
        if (arr.length < offset + 8 || offset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.littleEndian) {
            arr[offset] = (byte)(x >>> 0 & 0xFFL);
            arr[offset + 1] = (byte)(x >>> 8 & 0xFFL);
            arr[offset + 2] = (byte)(x >>> 16 & 0xFFL);
            arr[offset + 3] = (byte)(x >>> 24 & 0xFFL);
            arr[offset + 4] = (byte)(x >>> 32 & 0xFFL);
            arr[offset + 5] = (byte)(x >>> 40 & 0xFFL);
            arr[offset + 6] = (byte)(x >>> 48 & 0xFFL);
            arr[offset + 7] = (byte)(x >>> 56 & 0xFFL);
        } else {
            arr[offset] = (byte)(x >>> 56 & 0xFFL);
            arr[offset + 1] = (byte)(x >>> 48 & 0xFFL);
            arr[offset + 2] = (byte)(x >>> 40 & 0xFFL);
            arr[offset + 3] = (byte)(x >>> 32 & 0xFFL);
            arr[offset + 4] = (byte)(x >>> 24 & 0xFFL);
            arr[offset + 5] = (byte)(x >>> 16 & 0xFFL);
            arr[offset + 6] = (byte)(x >>> 8 & 0xFFL);
            arr[offset + 7] = (byte)(x >>> 0 & 0xFFL);
        }
    }

    public final byte[] intToArr(int i) {
        byte[] bArr = new byte[4];
        this.intToArr(i, bArr, 0);
        return bArr;
    }

    public final void intToArr(int i, byte[] arr, int offset) {
        if (arr.length < offset + 4 || offset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.littleEndian) {
            arr[offset + 3] = (byte)(0xFF & i >> 24);
            arr[offset + 2] = (byte)(0xFF & i >> 16);
            arr[offset + 1] = (byte)(0xFF & i >> 8);
            arr[offset] = (byte)(0xFF & i);
        } else {
            arr[offset] = (byte)(0xFF & i >> 24);
            arr[offset + 1] = (byte)(0xFF & i >> 16);
            arr[offset + 2] = (byte)(0xFF & i >> 8);
            arr[offset + 3] = (byte)(0xFF & i);
        }
    }

    public final byte[] shortToArr(short s) {
        byte[] bArr = new byte[2];
        this.shortToArr(s, bArr, 0);
        return bArr;
    }

    public final void shortToArr(short s, byte[] arr, int offset) {
        if (arr.length < offset + 2 || offset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.littleEndian) {
            arr[offset + 1] = (byte)(0xFF & s >> 8);
            arr[offset] = (byte)(0xFF & s);
        } else {
            arr[offset] = (byte)(0xFF & s >> 8);
            arr[offset + 1] = (byte)(0xFF & s);
        }
    }

    public final byte[] byteToArr(byte b) {
        byte[] bArr = new byte[]{b};
        return bArr;
    }

    public final void byteToArr(byte b, byte[] arr, int offset) {
        arr[offset] = b;
    }
}

