/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.jar;

import com.sap.engine.lib.jar.DependencyAnalyzer;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.lib.jar.event.AnalyzeProgressListener;
import java.io.IOException;
import java.util.Vector;

public class DependenceJarUtils
extends JarUtils
implements AnalyzeProgressListener {
    Vector dependencyFiles = new Vector();
    String fileName = null;
    String fileLocation = null;
    InfoObject info = null;
    DependencyAnalyzer dAnalizer = new DependencyAnalyzer();

    public Vector getInfoClasses(String[] classes) {
        Vector<String> cl = new Vector<String>();
        if (classes == null) {
            int i = 0;
            while (i < classes.length) {
                cl.addElement(classes[i]);
                ++i;
            }
        }
        return this.getInfoClasses(cl);
    }

    public Vector getInfoClasses(Vector cl) {
        if (this.dependencyFiles.size() > 0) {
            this.dependencyFiles.removeAllElements();
        }
        if (cl.size() > 0) {
            this.dAnalizer.addProgressListener(this);
            Vector additional = new Vector();
            if (this.additionalPaths != null) {
                additional = this.parsePath(this.additionalPaths);
            }
            Vector<String> exclude = new Vector<String>();
            exclude.add("java");
            exclude.add("org/");
            exclude.addElement("sun/io/");
            this.dAnalizer.findDependancies(cl, exclude, true, additional);
        }
        return this.dependencyFiles;
    }

    public Vector getDependencyFiles() {
        return this.dependencyFiles;
    }

    public Vector getAllDependencies(Vector classNames) {
        this.getInfoClasses(classNames);
        return this.getDependencyFiles();
    }

    public void makeJar(String jarName, String[] classes) throws IOException {
        this.getInfoClasses(classes);
        this.makeJarFromFiles(jarName, this.dependencyFiles);
    }

    public void makeJarFromVector(String jarName, Vector cl) throws IOException {
        this.getInfoClasses(cl);
        this.makeJarFromFiles(jarName, this.dependencyFiles);
    }

    public void newFilesFound(int numberOfFiles) {
    }

    public void currentFileFinished(String fileName1, String fileLocation) {
        this.fileName = fileName1.endsWith(".class") ? fileName1 : fileName1 + ".class";
        this.fileLocation = fileLocation;
        if (this.fileName == null || fileLocation == null || this.fileName.equals("") || fileLocation.equals("")) {
            return;
        }
        this.info = new InfoObject(this.fileName, fileLocation);
        if (!this.dependencyFiles.contains(this.info)) {
            this.dependencyFiles.addElement(this.info);
        }
    }

    protected boolean hasManifest(Vector infos) {
        if (infos == null) {
            return false;
        }
        InfoObject inf = null;
        int i = 0;
        while (i < infos.size()) {
            inf = (InfoObject)infos.elementAt(i);
            if (inf != null && inf.getEntryName() != null) {
                if (inf.getEntryName().equalsIgnoreCase("meta-inf/Manifest.mf")) {
                    return true;
                }
                if (inf.getEntryName().equalsIgnoreCase("meta-inf\\Manifest.mf")) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void processFinished() {
    }

    public void fileNotFound(String fileName) {
    }

    public void fileNotReadProperly(String fileName) {
    }

    public void groupStarted(String groupName) {
    }
}

