/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io.hash;

import com.sap.engine.lib.io.hash.CorruptedHashException;
import com.sap.engine.lib.io.hash.Entry;
import com.sap.engine.lib.io.hash.HashCompare;
import com.sap.engine.lib.io.hash.Hasher;
import com.sap.engine.lib.io.hash.MD5Hash;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.lib.util.ArrayByte;
import com.sap.engine.lib.util.PoolInstanceCreator;
import com.sap.engine.lib.util.PoolObjectWithCreator;
import java.io.IOException;
import java.io.InputStream;

public class IndexUtils {
    public static final byte COMPARE_EQUAL = 0;
    public static final byte COMPARE_LESS = -1;
    public static final byte COMPARE_GREATER = 1;
    static IndexUtils instance = new IndexUtils();
    private PoolObjectWithCreator MD5Pool = new PoolObjectWithCreator(new PoolInstanceCreator(){

        public Object newInstance() {
            return new MD5Hash();
        }
    });

    protected IndexUtils() {
    }

    protected void verifyCRC(byte[] index, int offset) throws CorruptedHashException {
        Hasher hash = this.getHasher();
        try {
            try {
                int recordSize = IndexUtils.getRecordSize(index, offset);
                int hash_offset = offset + recordSize - 16;
                byte[] verifyRezult = null;
                hash.updateHash(index, offset, recordSize - 16);
                verifyRezult = hash.getHash();
                if (HashCompare.compareByteArrays(verifyRezult, 0, 16, index, hash_offset, 16)) {
                    Object var8_8 = null;
                    this.releaseHasher(hash);
                    return;
                }
                Object var8_9 = null;
                this.releaseHasher(hash);
            }
            catch (Exception e) {
                throw new CorruptedHashException();
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.releaseHasher(hash);
            throw throwable;
        }
        throw new CorruptedHashException();
    }

    protected void encodeCRC(byte[] data, int start, int dataLength) {
        Hasher hash = this.getHasher();
        int hash_offset = start + dataLength - 16;
        hash.updateHash(data, start, dataLength - 16);
        hash.writeHash(data, hash_offset);
        this.releaseHasher(hash);
    }

    protected byte[] readFromStream(InputStream in) throws IOException {
        ArrayByte serial = new ArrayByte();
        byte[] buffer = new byte[64000];
        int bufferIndex = 0;
        while (bufferIndex != -1) {
            serial.addAll(buffer, 0, bufferIndex);
            bufferIndex = in.read(buffer);
        }
        return serial.toArray();
    }

    protected static int getRecordSize(byte[] index, int offset) {
        return Convert.byteArrToInt(index, offset);
    }

    protected static void encodeVersion(byte[] data, int offset, byte recordType) {
        data[offset + 0] = recordType;
        data[offset + 1] = 0;
        data[offset + 2] = 1;
        data[offset + 3] = 1;
    }

    protected static IndexUtils getInstance() {
        return instance;
    }

    protected Hasher getHasher() {
        PoolObjectWithCreator poolObjectWithCreator = this.MD5Pool;
        synchronized (poolObjectWithCreator) {
            Hasher hasher = (Hasher)this.MD5Pool.getObject();
            return hasher;
        }
    }

    protected void releaseHasher(Hasher hasher) {
        hasher.clear();
        PoolObjectWithCreator poolObjectWithCreator = this.MD5Pool;
        synchronized (poolObjectWithCreator) {
            this.MD5Pool.releaseObject((Object)hasher);
        }
    }

    protected static int compareNames(Object obj1, Object obj2) {
        return IndexUtils.compareNameBytes(((Entry)obj1).getNameBytes(), ((Entry)obj2).getNameBytes());
    }

    protected static byte compareNameBytes(byte[] str1, byte[] str2) {
        int i = 0;
        while (i < str1.length) {
            if (str2.length <= i) {
                return 1;
            }
            if (str1[i] < str2[i]) {
                return -1;
            }
            if (str1[i] > str2[i]) {
                return 1;
            }
            ++i;
        }
        if (i < str2.length) {
            return -1;
        }
        return 0;
    }
}

