/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io.hash;

import com.sap.engine.lib.io.hash.CorruptedHashException;
import com.sap.engine.lib.io.hash.Entry;
import com.sap.engine.lib.io.hash.FileHash;
import com.sap.engine.lib.io.hash.FolderCompareResult;
import com.sap.engine.lib.io.hash.FolderInDepthIterator;
import com.sap.engine.lib.io.hash.HashCompare;
import com.sap.engine.lib.io.hash.InDepthIterator;
import com.sap.engine.lib.io.hash.Index;
import com.sap.engine.lib.io.hash.IndexUtils;
import com.sap.engine.lib.io.hash.MultipleHash;
import com.sap.engine.lib.io.hash.ZipInDepthIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HashUtils {
    public static FolderCompareResult compareFolders(File f, byte[] data) throws IOException {
        if (!f.isDirectory()) {
            Thread.dumpStack();
            throw new IllegalArgumentException("This compare is only for folders!");
        }
        Index fh1 = null;
        Index fh2 = null;
        try {
            fh1 = HashUtils.getIndex(f);
            fh2 = HashUtils.getIndex(data, 0);
        }
        catch (CorruptedHashException e) {
            e.printStackTrace();
            return null;
        }
        return fh1.compare(fh2, true);
    }

    public static FolderCompareResult compareFolders(byte[] firstData, byte[] secondData) {
        MultipleHash fh1 = null;
        MultipleHash fh2 = null;
        try {
            fh1 = new MultipleHash(firstData, 0);
            fh2 = new MultipleHash(secondData, 0);
        }
        catch (CorruptedHashException e) {
            e.printStackTrace();
            return null;
        }
        return fh1.compare(fh2, true);
    }

    public static FolderCompareResult compareFolders(File f, File f1) throws IOException {
        if (!f.isDirectory() || !f1.isDirectory()) {
            Thread.dumpStack();
            throw new IllegalArgumentException("This compare is only for folders!");
        }
        Index fh1 = null;
        Index fh2 = null;
        fh1 = HashUtils.getIndex(f);
        fh2 = HashUtils.getIndex(f1);
        return fh1.compare(fh2, true);
    }

    public static boolean compareFiles(File f, File f1) throws IOException {
        if (f.isDirectory() || f1.isDirectory()) {
            Thread.dumpStack();
            throw new IllegalArgumentException("This compare is only for files!");
        }
        FileHash fh1 = null;
        FileInputStream fis1 = new FileInputStream(f);
        FileHash fh2 = null;
        FileInputStream fis2 = new FileInputStream(f1);
        try {
            fh1 = new FileHash(f.getName(), fis1);
            fh2 = new FileHash(f1.getName(), fis2);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            fis1.close();
            fis2.close();
            throw throwable;
        }
        fis1.close();
        fis2.close();
        return fh1.equals(fh2);
    }

    public static byte[] getIndexForFolder(File f) {
        if (!f.isDirectory()) {
            Thread.dumpStack();
            throw new IllegalArgumentException("This index is for folders!!!");
        }
        Index fh = null;
        try {
            fh = HashUtils.getIndex(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fh.toByteArr();
    }

    public static byte[] generateFileHash(File f) throws IOException {
        byte[] byArray;
        FileInputStream fis = new FileInputStream(f);
        try {
            byArray = new FileHash(f.getName(), fis).getHash();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            fis.close();
            throw throwable;
        }
        fis.close();
        return byArray;
    }

    public static byte[] generateFileHash(String name, InputStream f) throws IOException {
        return new FileHash(name, f).getHash();
    }

    public static byte[] generateDirHash(File f) throws IOException {
        return HashUtils.getIndex(f).getHash();
    }

    public static boolean compareHash(byte[] hash1, byte[] hash2) {
        return HashCompare.compareByteArrays(hash1, 0, 16, hash2, 0, 16);
    }

    public static Index getIndex(byte[] indexByteArray, int offset) throws CorruptedHashException {
        return new MultipleHash(indexByteArray, offset);
    }

    public static Index getIndex(InputStream in) throws IOException, CorruptedHashException {
        return new MultipleHash(IndexUtils.getInstance().readFromStream(in), 0);
    }

    public static Index getIndex(File f) throws IOException {
        if (f.isDirectory()) {
            return new MultipleHash(new FolderInDepthIterator(f));
        }
        return new MultipleHash(new ZipInDepthIterator(f));
    }

    public static Index getIndex(InDepthIterator iter) throws IOException {
        return new MultipleHash(iter);
    }

    public static Entry getEntry(String name, InputStream stream) throws IOException {
        return new FileHash(name, stream);
    }
}

