/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PropertiesMerger {
    public static final int CMIN = 0;
    public static final int CMAX = 1;
    public static final int COMPARATOR = 2;
    public static final int RESTRICTOR = 3;
    public static final int SMIN = 4;
    public static final int SMAX = 5;
    public static final int OVERRIDE = 6;
    public static final String[] footers = new String[]{".CMin", ".CMax", ".Comparator", ".Restrictor", ".SMin", ".SMax", ".Override"};
    private Properties properties;
    static /* synthetic */ Class class$java$lang$String;

    public PropertiesMerger() {
        this.properties = new Properties();
    }

    public PropertiesMerger(Properties properties) {
        this.properties = (Properties)((Hashtable)properties).clone();
    }

    public PropertiesMerger(File file) {
        this.loadAndSaveProperties(file);
    }

    public PropertiesMerger(ZipFile zipfile, ZipEntry entry) {
        this.properties = new Properties();
        try {
            this.properties.load(zipfile.getInputStream(entry));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addProperties(Properties properties, boolean overwrite) {
        boolean ok = false;
        if (overwrite) {
            Enumeration keys = ((Hashtable)properties).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.properties.setProperty(key, properties.getProperty(key));
            }
        } else {
            Object outer;
            Properties localProperties = (Properties)((Hashtable)properties).clone();
            HashSet bundles = new HashSet();
            block21: while (((Hashtable)localProperties).size() > 0) {
                outer = ((Hashtable)localProperties).keys();
                while (outer.hasMoreElements()) {
                    String current = (String)outer.nextElement();
                    ok = true;
                    int i = 0;
                    while (i < footers.length) {
                        if (current.endsWith(footers[i])) {
                            ok = false;
                        }
                        ++i;
                    }
                    if (!ok) continue;
                    if (((Hashtable)this.properties).get(current) == null) {
                        ok = false;
                        this.properties.setProperty(current, properties.getProperty(current));
                    }
                    Enumeration inner = ((Hashtable)localProperties).keys();
                    HashSet<String> bundle = new HashSet<String>();
                    while (inner.hasMoreElements()) {
                        String token = (String)inner.nextElement();
                        if (!token.startsWith(current) || token.equals(current)) continue;
                        bundle.add(token);
                    }
                    Hashtable<String, HashSet<String>> node = new Hashtable<String, HashSet<String>>();
                    node.put(current, bundle);
                    if (ok) {
                        bundles.add(node);
                    }
                    Iterator bundleElements = bundle.iterator();
                    ((Hashtable)localProperties).remove(current);
                    while (bundleElements.hasNext()) {
                        String bundleElement = (String)bundleElements.next();
                        ((Hashtable)localProperties).remove(bundleElement);
                    }
                    continue block21;
                }
            }
            outer = bundles.iterator();
            while (outer.hasNext()) {
                String element;
                Hashtable node = (Hashtable)outer.next();
                HashSet elementOptions = (HashSet)node.get(element = (String)node.keys().nextElement());
                if (elementOptions.size() <= 0) continue;
                if (elementOptions.contains(element + footers[6])) {
                    this.properties.setProperty(element, properties.getProperty(element));
                    continue;
                }
                if (elementOptions.contains(element + footers[3])) {
                    Object restrictor = ((Hashtable)properties).get(element + footers[3]);
                    Class<?> restrictorClass = null;
                    Object restrictorInstance = null;
                    if (restrictor instanceof String) {
                        try {
                            restrictorClass = Class.forName((String)restrictor);
                            restrictorInstance = restrictorClass.newInstance();
                        }
                        catch (ClassNotFoundException e) {
                        }
                        catch (InstantiationException e) {
                        }
                        catch (IllegalAccessException e) {}
                    } else {
                        restrictorClass = restrictor.getClass();
                        restrictorInstance = restrictor;
                    }
                    try {
                        Class[] argTypes = new Class[]{class$java$lang$String == null ? PropertiesMerger.class$("java.lang.String") : class$java$lang$String};
                        Method isOk = restrictorClass.getMethod("isOk", argTypes);
                        Object[] args = new Object[]{(String)((Hashtable)this.properties).get(element)};
                        Boolean result = (Boolean)isOk.invoke(restrictorInstance, args);
                        if (result.booleanValue()) continue;
                        this.properties.setProperty(element, properties.getProperty(element));
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (IllegalArgumentException e) {
                    }
                    catch (InvocationTargetException e) {}
                    continue;
                }
                if (elementOptions.contains(element + footers[2])) {
                    Object comparator = ((Hashtable)properties).get(element + footers[2]);
                    String lowest = (String)((Hashtable)properties).get(element + footers[0]);
                    String highest = (String)((Hashtable)properties).get(element + footers[1]);
                    Class<?> comparatorClass = null;
                    Object comparatorInstance = null;
                    if (comparator instanceof String) {
                        try {
                            comparatorClass = Class.forName((String)comparator);
                            comparatorInstance = comparatorClass.newInstance();
                        }
                        catch (ClassNotFoundException e) {
                        }
                        catch (InstantiationException e) {
                        }
                        catch (IllegalAccessException e) {}
                    } else {
                        comparatorClass = comparator.getClass();
                        comparatorInstance = comparator;
                    }
                    try {
                        Class[] argTypes = new Class[]{class$java$lang$String == null ? PropertiesMerger.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? PropertiesMerger.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? PropertiesMerger.class$("java.lang.String") : class$java$lang$String};
                        Method isInRange = comparatorClass.getMethod("isInRange", argTypes);
                        Object[] args = new Object[]{(String)((Hashtable)this.properties).get(element), lowest, highest};
                        Boolean result = (Boolean)isInRange.invoke(comparatorInstance, args);
                        if (result.booleanValue()) continue;
                        this.properties.setProperty(element, properties.getProperty(element));
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (IllegalArgumentException e) {
                    }
                    catch (InvocationTargetException e) {}
                    continue;
                }
                if (elementOptions.contains(element + footers[4])) {
                    Object lowest = ((Hashtable)properties).get(element + footers[4]);
                    if (new Long(((Hashtable)this.properties).get(element).toString()) < new Long(lowest.toString())) {
                        this.properties.setProperty(element, properties.getProperty(element));
                    }
                }
                if (!elementOptions.contains(element + footers[5])) continue;
                Object highest = ((Hashtable)properties).get(element + footers[5]);
                if (new Long(((Hashtable)this.properties).get(element).toString()) <= new Long(highest.toString())) continue;
                this.properties.setProperty(element, properties.getProperty(element));
            }
        }
    }

    public void addProperties(File file, boolean overwrite) {
        this.addProperties(this.loadProperties(file), overwrite);
    }

    public void addProperties(ZipFile zipfile, ZipEntry entry, boolean overwrite) {
        Properties properties = new Properties();
        try {
            properties.load(zipfile.getInputStream(entry));
        }
        catch (IOException e) {
            // empty catch block
        }
        this.addProperties(properties, overwrite);
    }

    public void addPropertiesOverwrite(Properties properties) {
        this.addProperties(properties, true);
    }

    public void addPropertiesOverwrite(File file) {
        this.addProperties(file, true);
    }

    public void addPropertiesOverwrite(ZipFile zipfile, ZipEntry entry) {
        this.addProperties(zipfile, entry, true);
    }

    public void addPropertiesWithoutOverwrite(Properties properties) {
        this.addProperties(properties, false);
    }

    public void addPropertiesWithoutOverwrite(File file) {
        this.addProperties(file, false);
    }

    public void addPropertiesWithoutOverwrite(ZipFile zipfile, ZipEntry entry) {
        this.addProperties(zipfile, entry, false);
    }

    public void loadAndSaveProperties(File file) {
        this.properties = new Properties();
        try {
            this.properties.load(new FileInputStream(file));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void storeProperties(File file) {
        try {
            this.properties.store(new FileOutputStream(file), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void processProperties(File source, File newProperties, File result, boolean overwrite) {
        PropertiesMerger merger = new PropertiesMerger(source);
        merger.addProperties(newProperties, overwrite);
        merger.storeProperties(result);
    }

    public static void processProperties(File source, ZipFile zipfile, ZipEntry entry, File result, boolean overwrite) {
        PropertiesMerger merger = new PropertiesMerger(source);
        merger.addProperties(zipfile, entry, overwrite);
        merger.storeProperties(result);
    }

    public static void processProperties(File destination, File newProperties, boolean overwrite) {
        PropertiesMerger merger = new PropertiesMerger(destination);
        merger.addProperties(newProperties, overwrite);
        merger.storeProperties(destination);
    }

    public static void processProperties(File destination, ZipFile zipfile, ZipEntry entry, boolean overwrite) {
        PropertiesMerger merger = new PropertiesMerger(destination);
        merger.addProperties(zipfile, entry, overwrite);
        merger.storeProperties(destination);
    }

    public static void processProperties(File destination, Properties newProperties, boolean overwrite) {
        PropertiesMerger merger = new PropertiesMerger(destination);
        merger.addProperties(newProperties, overwrite);
        merger.storeProperties(destination);
    }

    public static void processPropertiesOverwrite(File source, File newProperties, File result) {
        PropertiesMerger.processProperties(source, newProperties, result, true);
    }

    public static void processPropertiesOverwrite(File source, ZipFile zipfile, ZipEntry entry, File result) {
        PropertiesMerger.processProperties(source, zipfile, entry, result, true);
    }

    public static void processPropertiesOverwrite(File destination, File newProperties) {
        PropertiesMerger.processProperties(destination, newProperties, true);
    }

    public static void processPropertiesOverwrite(File destination, ZipFile zipfile, ZipEntry entry) {
        PropertiesMerger.processProperties(destination, zipfile, entry, true);
    }

    public static void processPropertiesOverwrite(File destination, Properties newProperties) {
        PropertiesMerger.processProperties(destination, newProperties, true);
    }

    public static void processPropertiesWithoutOverwrite(File source, File newProperties, File result) {
        PropertiesMerger.processProperties(source, newProperties, result, false);
    }

    public static void processPropertiesWithoutOverwrite(File source, ZipFile zipfile, ZipEntry entry, File result) {
        PropertiesMerger.processProperties(source, zipfile, entry, result, false);
    }

    public static void processPropertiesWithoutOverwrite(File destination, File newProperties) {
        PropertiesMerger.processProperties(destination, newProperties, false);
    }

    public static void processPropertiesWithoutOverwrite(File destination, ZipFile zipfile, ZipEntry entry) {
        PropertiesMerger.processProperties(destination, zipfile, entry, false);
    }

    public static void processPropertiesWithoutOverwrite(File destination, Properties newProperties) {
        PropertiesMerger.processProperties(destination, newProperties, false);
    }

    public Properties getProperties() {
        return this.properties;
    }

    private Properties loadProperties(File file) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public boolean isOk(String string) {
        return true;
    }

    public boolean isInRange(String org, String min, String max) {
        long _org = new Long(org);
        long _min = new Long(min);
        long _max = new Long(max);
        if (_org < _min) {
            return false;
        }
        return _org <= _max;
    }

    public static void main(String[] args) {
        Properties properties_1 = new Properties();
        Properties properties_2 = new Properties();
        Properties properties_3 = new Properties();
        properties_1.setProperty("key_1", "properties_1");
        properties_1.setProperty("key_2", "properties_1");
        properties_1.setProperty("key_3", "48");
        properties_1.setProperty("key_4", "properties_1");
        properties_1.setProperty("key_6", "10000");
        properties_1.setProperty("key_7", "0");
        properties_1.setProperty("key_8", "properties_1");
        properties_2.setProperty("key_5", "properties_2");
        properties_2.setProperty("key_1", "properties_2");
        properties_2.setProperty("key_3", "300");
        properties_2.setProperty("key_3.Comparator", "com.sap.engine.lib.io.PropertiesMerger");
        properties_2.setProperty("key_3.CMax", "500");
        properties_2.setProperty("key_3.CMin", "100");
        properties_2.setProperty("key_4", "properties_2");
        properties_2.setProperty("key_4.Restrictor", "com.sap.engine.lib.io.PropertiesMerger");
        properties_2.setProperty("key_6", "128");
        properties_2.setProperty("key_6.SMin", "64");
        properties_2.setProperty("key_6.SMax", "256");
        properties_2.setProperty("key_7", "128");
        properties_2.setProperty("key_7.SMin", "64");
        properties_2.setProperty("key_7.SMax", "256");
        properties_2.setProperty("key_8", "properties_2");
        properties_2.setProperty("key_8.Override", "true");
        PropertiesMerger merger_1 = new PropertiesMerger(properties_1);
        System.out.println("Initial Properties: " + merger_1.getProperties());
        System.out.println("Merging Properties: " + properties_2);
        merger_1.addProperties(properties_2, false);
        System.out.println("Final Properties: " + merger_1.getProperties());
        String result = ((Hashtable)merger_1.getProperties()).toString();
        String correct = "{key_7=128, key_6=128, key_5=properties_2, key_4=properties_1, key_3=300, key_2=properties_1, key_1=properties_1, key_8=properties_2}";
        if (correct.equals(result)) {
            System.out.println("Correct.");
        } else {
            System.out.println("ERROR!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

