/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.ui.util;

import com.togethersoft.togetherxj.gsd.core.jsm.JsmCatchBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmConditionalBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmDoBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmElement;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmElseBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmElseIfBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmExpressionPart;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmFinallyBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmForBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmIfBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmMessage;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmObject;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmSwitchBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmTryBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmVisitor;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmWhileBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaCatchBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaConditionalBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaDiagram;
import com.togethersoft.togetherxj.gsd.core.sda.SdaDoBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaElement;
import com.togethersoft.togetherxj.gsd.core.sda.SdaElseBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaElseIfBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaExpressionPart;
import com.togethersoft.togetherxj.gsd.core.sda.SdaFinallyBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaForBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaIfBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaMessage;
import com.togethersoft.togetherxj.gsd.core.sda.SdaObject;
import com.togethersoft.togetherxj.gsd.core.sda.SdaSwitchBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaTryBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaWhileBlock;
import com.togethersoft.togetherxj.gsd.monitor.IMonitorRecord;
import com.togethersoft.togetherxj.gsd.ui.GsdMessages;
import com.togethersoft.togetherxj.gsd.ui.util.ClassFilter;
import com.togethersoft.togetherxj.gsd.ui.util.GenerateSDMonitor;
import com.togethersoft.togetherxj.gsd.ui.util.SDBuilder$ErrorRecord;
import com.togethersoft.togetherxj.gsd.ui.util.SDBuilder$InfoRecord;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

public class SDBuilder
extends JsmVisitor {
    private Map myObjectsMap = new HashMap();
    private Map myObject2LastInboundMap;
    private JsmElement myCurrentJsmParent;
    private SdaElement myCurrentSdaParent;
    private SdaDiagram myDiagram;
    private Stack myStateStack;
    private GenerateSDMonitor myMonitor;
    private ClassFilter myClassFilter;

    public SDBuilder(SdaDiagram sdaDiagram, GenerateSDMonitor generateSDMonitor, ClassFilter classFilter) {
        this.myDiagram = sdaDiagram;
        this.myMonitor = generateSDMonitor;
        this.myObject2LastInboundMap = new HashMap();
        this.myStateStack = new Stack();
        this.myClassFilter = classFilter == null ? new ClassFilter() : classFilter;
    }

    public void build(JsmMessage jsmMessage) {
        jsmMessage.accept((JsmVisitor)this);
    }

    protected void pushState(JsmElement jsmElement, SdaElement sdaElement) {
        this.myStateStack.push(this.myCurrentJsmParent);
        this.myStateStack.push(this.myCurrentSdaParent);
        this.myCurrentJsmParent = jsmElement;
        this.myCurrentSdaParent = sdaElement;
    }

    protected void popState() {
        this.myCurrentSdaParent = (SdaElement)this.myStateStack.pop();
        this.myCurrentJsmParent = (JsmElement)this.myStateStack.pop();
    }

    public boolean visit(JsmMessage jsmMessage) {
        SdaMessage sdaMessage;
        Object object;
        Object object2;
        boolean bl2 = jsmMessage.getParent() == null;
        JsmObject jsmObject = jsmMessage.getTarget();
        IType iType = jsmObject.getType();
        if (!bl2 && !this.myClassFilter.showType(iType)) {
            if (this.myMonitor != null) {
                this.myMonitor.addRecord((IMonitorRecord)new SDBuilder$InfoRecord(this, (JsmElement)jsmMessage, this.getTargetHiddenText(jsmMessage, iType)));
            }
            this.pushState((JsmElement)jsmMessage, null);
            return false;
        }
        SdaObject sdaObject = (SdaObject)this.myObjectsMap.get(jsmObject.getId());
        if (sdaObject == null) {
            sdaObject = this.myDiagram.newObject();
            try {
                sdaObject.setType(jsmObject.getType());
            }
            catch (Throwable throwable) {
                if (this.myMonitor != null) {
                    this.myMonitor.addRecord((IMonitorRecord)new SDBuilder$ErrorRecord(this, (JsmElement)jsmMessage, throwable));
                }
                throwable.printStackTrace();
            }
            this.myObjectsMap.put(jsmObject.getId(), sdaObject);
            object2 = jsmObject.getName();
            if (object2 == null) {
                object2 = jsmMessage.getParent() == null ? "<initial>" : "<anonymous>";
            }
            object = object2;
            if (jsmObject.isArray()) {
                int bl = jsmObject.getDimensions();
                int n = 0;
                while (n < bl) {
                    object = (String)object + "[]";
                    ++n;
                }
            }
            sdaObject.setName((String)object);
            this.myMonitor.countObject();
        }
        object2 = null;
        object2 = bl2 ? this.myDiagram.newInitialMessage(this.myDiagram.getActorObject(), sdaObject) : this.myDiagram.newMessage(this.myCurrentSdaParent, sdaObject);
        object2.setMethod(jsmMessage.getMethod());
        object2.setCreation(jsmMessage.isCreation());
        object2.setArguments(jsmMessage.getArguments());
        object = "";
        if (jsmMessage.isCreation()) {
            object = jsmMessage.getMethod() != null && jsmMessage.getTarget().getType() != null ? "create " + jsmMessage.getTarget().getType().getElementName() : "<default constructor>";
        } else if (jsmMessage.getMethod() != null) {
            object = "invoke " + jsmMessage.getMethod().getElementName();
        }
        object2.setName((String)object);
        if (jsmObject.isTransient() && ((sdaMessage = (SdaMessage)this.myObject2LastInboundMap.get(jsmObject.getId())) == null || !sdaMessage.parentOf((SdaElement)object2))) {
            if (sdaMessage != null) {
                sdaMessage.setDestruction(false);
            }
            object2.setDestruction(true);
            this.myObject2LastInboundMap.put(jsmObject.getId(), object2);
        }
        this.pushState((JsmElement)jsmMessage, (SdaElement)object2);
        boolean bl = this.myClassFilter.showImplementation(iType);
        if (!bl && jsmMessage.hasChildren() && this.myMonitor != null) {
            this.myMonitor.addRecord((IMonitorRecord)new SDBuilder$InfoRecord(this, (JsmElement)jsmMessage, this.getImplementationHiddenText(jsmMessage, iType)));
        }
        return bl;
    }

    public boolean visit(JsmExpressionPart jsmExpressionPart) {
        if (jsmExpressionPart.getKind() != 0) {
            if (jsmExpressionPart.getKind() == 1) {
                SdaExpressionPart sdaExpressionPart = ((SdaConditionalBlock)this.myCurrentSdaParent).getExpressionPart();
                JsmExpressionPart jsmExpressionPart2 = ((JsmConditionalBlock)this.myCurrentJsmParent).getExpressionPart();
                this.pushState((JsmElement)jsmExpressionPart2, (SdaElement)sdaExpressionPart);
            } else if (jsmExpressionPart.getKind() == 3) {
                SdaExpressionPart sdaExpressionPart = ((SdaForBlock)this.myCurrentSdaParent).getExpressionPart();
                JsmExpressionPart jsmExpressionPart3 = ((JsmForBlock)this.myCurrentJsmParent).getInitPart();
                this.pushState((JsmElement)jsmExpressionPart3, (SdaElement)sdaExpressionPart);
            } else if (jsmExpressionPart.getKind() == 2) {
                SdaExpressionPart sdaExpressionPart = ((SdaForBlock)this.myCurrentSdaParent).getExpressionPart();
                JsmExpressionPart jsmExpressionPart4 = ((JsmForBlock)this.myCurrentJsmParent).getExpressionPart();
                this.pushState((JsmElement)jsmExpressionPart4, (SdaElement)sdaExpressionPart);
            } else if (jsmExpressionPart.getKind() == 4) {
                SdaExpressionPart sdaExpressionPart = ((SdaForBlock)this.myCurrentSdaParent).getUpdatePart();
                JsmExpressionPart jsmExpressionPart5 = ((JsmForBlock)this.myCurrentJsmParent).getUpdatePart();
                this.pushState((JsmElement)jsmExpressionPart5, (SdaElement)sdaExpressionPart);
            } else if (jsmExpressionPart.getKind() == 5) {
                SdaExpressionPart sdaExpressionPart = ((SdaWhileBlock)this.myCurrentSdaParent).getExpressionPart();
                JsmExpressionPart jsmExpressionPart6 = ((JsmWhileBlock)this.myCurrentJsmParent).getExpressionPart();
                this.pushState((JsmElement)jsmExpressionPart6, (SdaElement)sdaExpressionPart);
            } else if (jsmExpressionPart.getKind() == 6) {
                SdaExpressionPart sdaExpressionPart = ((SdaDoBlock)this.myCurrentSdaParent).getExpressionPart();
                JsmExpressionPart jsmExpressionPart7 = ((JsmDoBlock)this.myCurrentJsmParent).getExpressionPart();
                this.pushState((JsmElement)jsmExpressionPart7, (SdaElement)sdaExpressionPart);
            } else if (jsmExpressionPart.getKind() == 7) {
                SdaExpressionPart sdaExpressionPart = ((SdaSwitchBlock)this.myCurrentSdaParent).getExpressionPart();
                JsmExpressionPart jsmExpressionPart8 = ((JsmSwitchBlock)this.myCurrentJsmParent).getExpressionPart();
                this.pushState((JsmElement)jsmExpressionPart8, (SdaElement)sdaExpressionPart);
            }
        }
        return true;
    }

    public boolean visit(JsmIfBlock jsmIfBlock) {
        SdaIfBlock sdaIfBlock = this.myDiagram.newIfBlock(this.myCurrentSdaParent);
        sdaIfBlock.setCondition(jsmIfBlock.getCondition());
        this.pushState((JsmElement)jsmIfBlock, (SdaElement)sdaIfBlock);
        return true;
    }

    public boolean visit(JsmElseIfBlock jsmElseIfBlock) {
        SdaElseIfBlock sdaElseIfBlock = this.myDiagram.newElseIfBlock((SdaConditionalBlock)this.myCurrentSdaParent);
        sdaElseIfBlock.setCondition(jsmElseIfBlock.getCondition());
        this.pushState((JsmElement)jsmElseIfBlock, (SdaElement)sdaElseIfBlock);
        return true;
    }

    public boolean visit(JsmElseBlock jsmElseBlock) {
        SdaElseBlock sdaElseBlock = this.myDiagram.newElseBlock((SdaConditionalBlock)this.myCurrentSdaParent);
        this.pushState((JsmElement)jsmElseBlock, (SdaElement)sdaElseBlock);
        return true;
    }

    public boolean visit(JsmForBlock jsmForBlock) {
        SdaForBlock sdaForBlock = this.myDiagram.newForBlock(this.myCurrentSdaParent);
        sdaForBlock.setIteration(jsmForBlock.getIteration());
        this.pushState((JsmElement)jsmForBlock, (SdaElement)sdaForBlock);
        return true;
    }

    public boolean visit(JsmDoBlock jsmDoBlock) {
        SdaDoBlock sdaDoBlock = this.myDiagram.newDoBlock(this.myCurrentSdaParent);
        sdaDoBlock.setIteration(jsmDoBlock.getIteration());
        this.pushState((JsmElement)jsmDoBlock, (SdaElement)sdaDoBlock);
        return true;
    }

    public boolean visit(JsmWhileBlock jsmWhileBlock) {
        SdaWhileBlock sdaWhileBlock = this.myDiagram.newWhileBlock(this.myCurrentSdaParent);
        sdaWhileBlock.setIteration(jsmWhileBlock.getIteration());
        this.pushState((JsmElement)jsmWhileBlock, (SdaElement)sdaWhileBlock);
        return true;
    }

    public boolean visit(JsmTryBlock jsmTryBlock) {
        SdaTryBlock sdaTryBlock = this.myDiagram.newTryBlock(this.myCurrentSdaParent);
        this.pushState((JsmElement)jsmTryBlock, (SdaElement)sdaTryBlock);
        return true;
    }

    public boolean visit(JsmCatchBlock jsmCatchBlock) {
        SdaCatchBlock sdaCatchBlock = this.myDiagram.newCatchBlock((SdaTryBlock)this.myCurrentSdaParent);
        sdaCatchBlock.setParameter(jsmCatchBlock.getParameter());
        this.pushState((JsmElement)jsmCatchBlock, (SdaElement)sdaCatchBlock);
        return true;
    }

    public boolean visit(JsmFinallyBlock jsmFinallyBlock) {
        SdaFinallyBlock sdaFinallyBlock = this.myDiagram.newFinallyBlock((SdaTryBlock)this.myCurrentSdaParent);
        this.pushState((JsmElement)jsmFinallyBlock, (SdaElement)sdaFinallyBlock);
        return true;
    }

    public boolean visit(JsmSwitchBlock jsmSwitchBlock) {
        SdaSwitchBlock sdaSwitchBlock = this.myDiagram.newSwitchBlock(this.myCurrentSdaParent);
        sdaSwitchBlock.setExpression(jsmSwitchBlock.getExpression());
        this.pushState((JsmElement)jsmSwitchBlock, (SdaElement)sdaSwitchBlock);
        return true;
    }

    public void endVisit(JsmMessage jsmMessage) {
        this.popState();
        this.myMonitor.countMessage();
    }

    public void endVisit(JsmExpressionPart jsmExpressionPart) {
        if (jsmExpressionPart.getKind() != 0) {
            this.popState();
        }
    }

    public void endVisit(JsmIfBlock jsmIfBlock) {
        this.popState();
        this.myMonitor.countStatementBlock();
    }

    public void endVisit(JsmElseIfBlock jsmElseIfBlock) {
        this.popState();
        this.myMonitor.countStatementBlock();
    }

    public void endVisit(JsmElseBlock jsmElseBlock) {
        this.popState();
        this.myMonitor.countStatementBlock();
    }

    public void endVisit(JsmForBlock jsmForBlock) {
        this.popState();
        this.myMonitor.countStatementBlock();
    }

    public void endVisit(JsmDoBlock jsmDoBlock) {
        this.popState();
        this.myMonitor.countStatementBlock();
    }

    public void endVisit(JsmWhileBlock jsmWhileBlock) {
        this.popState();
        this.myMonitor.countStatementBlock();
    }

    public void endVisit(JsmTryBlock jsmTryBlock) {
        this.popState();
        this.myMonitor.countStatementBlock();
    }

    public void endVisit(JsmCatchBlock jsmCatchBlock) {
        this.popState();
        this.myMonitor.countStatementBlock();
    }

    public void endVisit(JsmFinallyBlock jsmFinallyBlock) {
        this.popState();
        this.myMonitor.countStatementBlock();
    }

    public void endVisit(JsmSwitchBlock jsmSwitchBlock) {
        this.popState();
        this.myMonitor.countStatementBlock();
    }

    private String getTargetHiddenText(JsmMessage jsmMessage, IType iType) {
        String string = null;
        if (jsmMessage.isCreation()) {
            string = "constructor";
        } else {
            IMethod iMethod = jsmMessage.getMethod();
            if (iMethod != null) {
                string = iMethod.getElementName();
            }
        }
        return GsdMessages.getFormattedString("gsdlog.info.skip_method_hidden_by_class_filter", new Object[]{string, iType.getElementName()});
    }

    private String getImplementationHiddenText(JsmMessage jsmMessage, IType iType) {
        String string = null;
        if (jsmMessage.isCreation()) {
            string = "constructor";
        } else {
            IMethod iMethod = jsmMessage.getMethod();
            if (iMethod != null) {
                string = iMethod.getElementName();
            }
        }
        return GsdMessages.getFormattedString("gsdlog.info.skip_method_impl_hidden_by_class_filter", new Object[]{string, iType.getElementName()});
    }
}

