/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.ui.util;

import com.togethersoft.togetherxj.gsd.monitor.IMonitor;
import com.togethersoft.togetherxj.gsd.monitor.IMonitorRecord;
import com.togethersoft.togetherxj.gsd.ui.GsdMessages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class GenerateSDMonitor
implements IMonitor {
    private IMonitor myLog;
    private IProgressMonitor myProgress;
    private int myMessagesCount;
    private int myStatementBlocksCount;
    private int myObjectsCount;
    private String myMainTaskName;
    private Display myDisplay;
    private static Object[] OBJECTS3 = new Object[3];

    public GenerateSDMonitor(IMonitor iMonitor, Display display) {
        this.myLog = iMonitor;
        this.myDisplay = display;
    }

    public void refreshUI() {
        if (this.myDisplay != null && !this.myDisplay.isDisposed() && Thread.currentThread() == this.myDisplay.getThread()) {
            while (this.myDisplay.readAndDispatch()) {
            }
        }
    }

    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        this.myProgress = iProgressMonitor;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.myProgress;
    }

    public void begin(String string, int n) {
        this.myMainTaskName = string;
        if (this.myProgress != null) {
            this.myProgress.beginTask(string, n);
        }
        this.refreshUI();
    }

    public void done() {
        if (this.myProgress != null) {
            this.myProgress.done();
        }
        this.refreshUI();
    }

    public void countMessage() {
        ++this.myMessagesCount;
        this.updateProgress();
    }

    public void countStatementBlock() {
        ++this.myStatementBlocksCount;
        this.updateProgress();
    }

    public void countObject() {
        ++this.myObjectsCount;
        this.updateProgress();
    }

    protected void updateProgress() {
        if (this.myProgress != null) {
            this.myProgress.worked(1);
            this.myProgress.subTask(this.getProgressText());
        }
        this.refreshUI();
    }

    protected String getProgressText() {
        GenerateSDMonitor.OBJECTS3[0] = String.valueOf(this.myMessagesCount);
        GenerateSDMonitor.OBJECTS3[1] = String.valueOf(this.myStatementBlocksCount);
        GenerateSDMonitor.OBJECTS3[2] = String.valueOf(this.myObjectsCount);
        String string = GsdMessages.getFormattedString("gsdprogress.so_far_created", OBJECTS3);
        return string;
    }

    public void addRecord(IMonitorRecord iMonitorRecord) {
        if (this.myLog != null) {
            this.myLog.addRecord(iMonitorRecord);
        }
    }

    public void reset() {
        if (this.myLog != null) {
            this.myLog.reset();
        }
    }
}

