/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.ui.util;

import com.togethersoft.togetherxj.gsd.core.jsm.JsmCatchBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmDoBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmElseBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmElseIfBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmFinallyBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmForBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmIfBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmMessage;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmObject;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmSwitchBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmTryBlock;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmVisitor;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmWhileBlock;
import com.togethersoft.togetherxj.gsd.ui.util.ClassFilter;
import java.util.HashSet;

public class ElementCounter
extends JsmVisitor {
    private int myMessagesCount;
    private int myStatementBlocksCount;
    private int myObjectsCount;
    private HashSet myObjectsSet = new HashSet();
    private ClassFilter myClassFilter;

    public ElementCounter(ClassFilter classFilter) {
        this.myClassFilter = classFilter;
        if (classFilter == null) {
            this.myClassFilter = new ClassFilter();
        }
    }

    public void countElements(JsmMessage[] jsmMessageArray, boolean bl) {
        int n = 0;
        while (n < jsmMessageArray.length) {
            if (bl) {
                this.myObjectsSet.clear();
            }
            jsmMessageArray[n].accept((JsmVisitor)this);
            ++n;
        }
    }

    public void countElements(JsmMessage jsmMessage) {
        jsmMessage.accept((JsmVisitor)this);
    }

    public int totalMessages() {
        return this.myMessagesCount;
    }

    public int totalStatementBlocks() {
        return this.myStatementBlocksCount;
    }

    public int totalObjects() {
        return this.myObjectsCount;
    }

    protected void countMessage() {
        ++this.myMessagesCount;
    }

    protected void countStatementBlock() {
        ++this.myStatementBlocksCount;
    }

    protected void countObject() {
        ++this.myObjectsCount;
    }

    public boolean visit(JsmMessage jsmMessage) {
        JsmObject jsmObject = jsmMessage.getTarget();
        if (jsmObject.getType() != null && !this.myClassFilter.showType(jsmObject.getType())) {
            return false;
        }
        this.countMessage();
        String string = jsmObject.getId();
        if (!this.myObjectsSet.contains(string)) {
            this.myObjectsSet.add(string);
            this.countObject();
        }
        return jsmObject.getType() == null || this.myClassFilter.showImplementation(jsmObject.getType());
    }

    public boolean visit(JsmCatchBlock jsmCatchBlock) {
        this.countStatementBlock();
        return true;
    }

    public boolean visit(JsmDoBlock jsmDoBlock) {
        this.countStatementBlock();
        return true;
    }

    public boolean visit(JsmElseBlock jsmElseBlock) {
        this.countStatementBlock();
        return true;
    }

    public boolean visit(JsmElseIfBlock jsmElseIfBlock) {
        this.countStatementBlock();
        return true;
    }

    public boolean visit(JsmFinallyBlock jsmFinallyBlock) {
        this.countStatementBlock();
        return true;
    }

    public boolean visit(JsmForBlock jsmForBlock) {
        this.countStatementBlock();
        return true;
    }

    public boolean visit(JsmIfBlock jsmIfBlock) {
        this.countStatementBlock();
        return true;
    }

    public boolean visit(JsmSwitchBlock jsmSwitchBlock) {
        this.countStatementBlock();
        return true;
    }

    public boolean visit(JsmTryBlock jsmTryBlock) {
        this.countStatementBlock();
        return true;
    }

    public boolean visit(JsmWhileBlock jsmWhileBlock) {
        this.countStatementBlock();
        return true;
    }
}

