/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.ui.dialogs;

import com.togethersoft.togetherxj.gsd.core.jsm.JsmBuilder;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmMessage;
import com.togethersoft.togetherxj.gsd.monitor.IMonitor;
import com.togethersoft.togetherxj.gsd.ui.dialogs.GenerateSDPreferences;
import com.togethersoft.togetherxj.gsd.ui.dialogs.GenerateSDWizard;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;

public class GenerateSDWizardController {
    private IJavaProject myProject;
    private IMethod[] myMethods;
    private ArrayList myJsmMessagesList = new ArrayList();
    private boolean myJSMValid;
    private IMonitor myMonitor;
    private GenerateSDPreferences myPreferences;
    private int myDepthOfNesting;
    private boolean myExcludeSelfMessages;
    private boolean myCreateMultDiagrams;

    public GenerateSDWizardController(GenerateSDWizard generateSDWizard, IJavaProject iJavaProject, IMethod[] iMethodArray) {
        this.myProject = iJavaProject;
        this.myMethods = iMethodArray;
        this.myPreferences = new GenerateSDPreferences();
        this.myDepthOfNesting = this.myPreferences.getDepthOfNesting();
        this.myExcludeSelfMessages = this.myPreferences.isExcludeSelfMessages();
        this.myCreateMultDiagrams = this.myPreferences.isCreateMnogoDiagrams();
    }

    public void dispose() {
    }

    public void setMonitor(IMonitor iMonitor) {
        this.myMonitor = iMonitor;
    }

    public JsmMessage[] getInitialMessages() {
        return this.myJsmMessagesList.toArray(new JsmMessage[this.myJsmMessagesList.size()]);
    }

    public boolean hasValidJSM() {
        return this.myJSMValid;
    }

    public void validateJSM() {
        if (!this.myJSMValid) {
            JsmBuilder jsmBuilder = JsmBuilder.newBuilder((IJavaProject)this.myProject);
            jsmBuilder.setMonitor(this.myMonitor);
            jsmBuilder.setCallNestingDepth(this.myDepthOfNesting);
            jsmBuilder.setExcludeSelfMessages(this.myExcludeSelfMessages);
            this.myJsmMessagesList.clear();
            int n = 0;
            while (n < this.myMethods.length) {
                JsmMessage jsmMessage = jsmBuilder.buildInitialMessage(this.myMethods[n], this.myCreateMultDiagrams);
                this.myJsmMessagesList.add(jsmMessage);
                ++n;
            }
            this.myJSMValid = true;
        }
    }

    public void invalidateJSM() {
        if (this.myJSMValid) {
            this.myJSMValid = false;
            this.myMonitor.reset();
            Iterator iterator = ((AbstractList)this.myJsmMessagesList).iterator();
            while (iterator.hasNext()) {
                JsmMessage jsmMessage = (JsmMessage)iterator.next();
                jsmMessage.dispose();
            }
            this.myJsmMessagesList.clear();
        }
    }

    public boolean isMultipleMethods() {
        return this.myMethods.length > 1;
    }

    public int getDepthOfNesting() {
        return this.myDepthOfNesting;
    }

    public boolean isExcludeSelfMessages() {
        return this.myExcludeSelfMessages;
    }

    public boolean isCreateMultDiagrams() {
        return this.myCreateMultDiagrams;
    }

    public boolean isShowMultDiagrams() {
        return this.myPreferences.isShowMnogoDiagrams();
    }

    public boolean isCreateHyperlinks() {
        return this.myPreferences.isCreateHyperlinks();
    }

    public void setDepthOfNesting(int n) {
        this.myDepthOfNesting = n;
    }

    public void setExcludeSelfMessages(boolean bl) {
        this.myExcludeSelfMessages = bl;
    }

    public void setCreateMultDiagrams(boolean bl) {
        this.myCreateMultDiagrams = bl;
    }

    public void setShowMultDiagrams(boolean bl) {
        this.myPreferences.setShowMnogoDiagrams(bl);
    }

    public void setCreateHyperlinks(boolean bl) {
        this.myPreferences.setCreateHyperlinks(bl);
    }

    public void applyDirtyValues() {
        if (this.myDepthOfNesting != this.myPreferences.getDepthOfNesting() || this.myExcludeSelfMessages != this.myPreferences.isExcludeSelfMessages() || this.myCreateMultDiagrams != this.myPreferences.isCreateMnogoDiagrams()) {
            this.invalidateJSM();
        }
        this.myPreferences.setDepthOfNesting(this.myDepthOfNesting);
        this.myPreferences.setExcludeSelfMessages(this.myExcludeSelfMessages);
        this.myPreferences.setCreateMnogoDiagrams(this.myCreateMultDiagrams);
    }

    public GenerateSDPreferences getPreferences() {
        return this.myPreferences;
    }
}

