/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.adobetemplatedesigner;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.actions.SaveActionManager;
import com.sap.ide.metamodel.core.plugin.IMetamodelSaveParticipant;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.view.UIElementContextBinding;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElement;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ViewElementProperty;
import com.sap.ide.metamodel.webdynpro.repository.ViewRepositoryManager;
import com.sap.ide.webdynpro.adobetemplatedesigner.AdobeDesignerEditorInput;
import com.sap.ide.webdynpro.adobetemplatedesigner.AdobeTemplateDesignerPlugin;
import com.sap.ide.webdynpro.adobetemplatedesigner.NativeWrapper;
import com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectEditorInput;
import com.tssap.util.InstallationInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class AdobeDesignerEditorPart
extends EditorPart
implements IMetamodelSaveParticipant {
    private UIElement mUIElement;
    private OleFrame mWebFrame = null;
    private OleAutomation mOleAutomation = null;
    private OleControlSite mWebControlSite = null;
    private boolean mActivated = false;
    private NativeWrapper mAdobeWrapper = null;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$adobetemplatedesigner$AdobeDesignerEditorPart;
    static /* synthetic */ Class array$B;

    public AdobeDesignerEditorPart(DevelopmentObjectEditorInput input) {
    }

    public AdobeDesignerEditorPart() {
    }

    public void createPartControl(Composite parent) {
        try {
            this.mWebFrame = new OleFrame(parent, 0);
            GridData lGridData = new GridData(1808);
            this.mWebFrame.setLayoutData((Object)lGridData);
            this.mWebControlSite = new OleControlSite((Composite)this.mWebFrame, 0, "WDAdobeControl.WDTemplateDesigner.1");
            this.mOleAutomation = new OleAutomation((OleClientSite)this.mWebControlSite);
            this.mAdobeWrapper = new NativeWrapper(this.mOleAutomation);
            this.mWebControlSite.addEventListener(NativeWrapper.OnDataChange, new OleListener(){

                public void handleEvent(OleEvent event) {
                    AdobeDesignerEditorPart.this.makeDirty();
                }
            });
        }
        catch (SWTException exception) {
            String string = exception.getMessage();
        }
        boolean bl = this.mActivated = this.mWebControlSite.doVerb(-5) == 0;
        if (this.mActivated) {
            this.openDocument();
        } else {
            AdobeTemplateDesignerPlugin.internalError(class$com$sap$ide$webdynpro$adobetemplatedesigner$AdobeDesignerEditorPart == null ? (class$com$sap$ide$webdynpro$adobetemplatedesigner$AdobeDesignerEditorPart = AdobeDesignerEditorPart.class$("com.sap.ide.webdynpro.adobetemplatedesigner.AdobeDesignerEditorPart")) : class$com$sap$ide$webdynpro$adobetemplatedesigner$AdobeDesignerEditorPart, "doVerb", "An error ocurred. See error log for more details.", null, false);
        }
    }

    private void makeDirty() {
        if (null == this.mUIElement) {
            return;
        }
        if (!this.checkWritability(this.mUIElement)) {
            return;
        }
        SaveActionManager.enableSaveAllButton();
        SaveActionManager.enableRollbackButton();
        ViewElementProperty viewElementProperty = (ViewElementProperty)this.mUIElement.getProperty("templateSource");
        if (null != viewElementProperty) {
            String xft = viewElementProperty.getValue();
            viewElementProperty.setValue("xft");
            viewElementProperty.setValue(xft);
        }
    }

    private boolean checkWritability(UIElement adobeElement) {
        ArrayList<MMRepositoryObject> result = new ArrayList<MMRepositoryObject>();
        View view = (View)adobeElement.getMDO();
        result.add(ViewRepositoryManager.getRepositioryObject((View)view, (boolean)false));
        MMRepositoryObject[] repositoryObjects = result.toArray(new MMRepositoryObject[0]);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return false;
        }
        ViewElementProperty property = (ViewElementProperty)adobeElement.getProperty("templateSource");
        if (null == property) {
            return true;
        }
        IFile[] files = new IFile[1];
        Path path = new Path(this.getFullPath(property));
        files[0] = AdobeTemplateDesignerPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        IStatus status = AdobeTemplateDesignerPlugin.getWorkspace().validateEdit(files, null);
        return status.isOK();
    }

    private void openDocument() {
        ViewElementProperty viewElementProperty = (ViewElementProperty)this.mUIElement.getProperty("templateSource");
        if (null != viewElementProperty) {
            String absolutePath = this.getFullPath(viewElementProperty);
            try {
                this.mAdobeWrapper.openDocument(absolutePath);
            }
            catch (Exception e) {
                AdobeTemplateDesignerPlugin.internalError(((Object)((Object)this)).getClass(), "openDocument()", e.getMessage(), e, true);
            }
        } else {
            this.mAdobeWrapper.openDocument("");
        }
    }

    private String getFullPath(ViewElementProperty viewElementProperty) {
        String xft = viewElementProperty.getValue();
        View view = (View)this.mUIElement.getMDO();
        String componentPath = AdobeDesignerEditorPart.getComponentPath(view);
        componentPath = componentPath + "\\" + xft;
        return componentPath;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof AdobeDesignerEditorInput) {
            AdobeDesignerEditorInput adobeInput = (AdobeDesignerEditorInput)input;
            this.mUIElement = (UIElement)adobeInput.getDevelopmentObject();
        }
        this.setTitle(input.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        if (this.mWebControlSite != null) {
            this.mWebControlSite.setFocus();
        }
        this.invokeGenerator();
    }

    private void invokeGenerator() {
        try {
            ContextNode dataSource = null;
            UIElementContextBinding binding = this.mUIElement.getContextBinding("dataSource");
            if (null == binding) {
                return;
            }
            dataSource = (ContextNode)binding.getBoundContextElement();
            if (null == dataSource) {
                return;
            }
            GenerationEclipse lWDGeneration = new GenerationEclipse((IProgressMonitor)new NullProgressMonitor());
            lWDGeneration.setIncremental(false);
            lWDGeneration.refreshConfiguration();
            String lSchema = lWDGeneration.generateTransientControllerContext2Schema(dataSource, true, true);
            lWDGeneration.cleanup();
            this.mAdobeWrapper.addSchema(dataSource.getName(), lSchema);
        }
        catch (Exception e) {
            AdobeTemplateDesignerPlugin.internalError(((Object)((Object)this)).getClass(), "invokeGenerator()", e.getMessage(), e, true);
        }
    }

    public void dispose() {
        if (this.mActivated) {
            this.mWebControlSite.deactivateInPlaceClient();
            this.mActivated = false;
        }
        if (this.mAdobeWrapper != null) {
            this.mAdobeWrapper.dispose();
        }
        this.mAdobeWrapper = null;
    }

    public Metamodel getMetamodel() {
        if (null != this.mUIElement) {
            return this.mUIElement.getRoot().getMetamodel();
        }
        return null;
    }

    public void preSave() {
        this.mAdobeWrapper.save();
        String xft = this.mAdobeWrapper.getXFT();
        this.saveToFile(this.getContents(xft));
        this.deleteTempFile(xft);
    }

    private void deleteTempFile(String xft) {
        File file = new File(xft);
        if (file.exists()) {
            file.delete();
        }
    }

    private byte[] getContents(String xft) {
        try {
            FileInputStream stream = new FileInputStream(xft);
            int available = stream.available();
            byte[] bytes = new byte[available];
            stream.read(bytes);
            return bytes;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private byte[] getSAPInternalDocument(byte[] bytes) {
        try {
            if (InstallationInfo.getInstallationType() == 2) {
                return bytes;
            }
            if (InstallationInfo.getInstallationType() == 1) {
                Class<?> sapForm = Class.forName("com.adobe.service.sap.licensing.SAPForm");
                Method makeIntoSAPForm = sapForm.getMethod("makeIntoSAPForm", array$B == null ? (array$B = AdobeDesignerEditorPart.class$("[B")) : array$B);
                Object retBytes = makeIntoSAPForm.invoke(null, new Object[]{bytes});
                if (null != retBytes) {
                    return (byte[])retBytes;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    private void saveToFile(byte[] bytes) {
        ViewElementProperty property = (ViewElementProperty)this.mUIElement.getProperty("templateSource");
        String fileName = property.getValue();
        View mdo = (View)this.mUIElement.getMDO();
        String path = AdobeDesignerEditorPart.getComponentPath(mdo);
        path = path + "\\" + fileName;
        try {
            FileOutputStream outputStream = new FileOutputStream(path);
            bytes = this.getSAPInternalDocument(bytes);
            outputStream.write(bytes);
            outputStream.close();
        }
        catch (Exception e) {
            AdobeTemplateDesignerPlugin.internalError(((Object)((Object)this)).getClass(), "saveToFile(String)", e.getMessage(), e, true);
        }
    }

    public void postSave() {
    }

    public void postRollback() {
        this.mAdobeWrapper.close();
        this.openDocument();
        this.invokeGenerator();
    }

    private static String getComponentPath(View mdo) {
        String packageName = mdo.getComponent().getQualifiedName();
        String path = mdo.getAbsolutePath();
        int slashPos = path.lastIndexOf("\\packages\\");
        path = path.substring(0, slashPos);
        path = path + "\\configuration\\Components\\" + packageName;
        return path;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

