/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.util.reg;

import com.sap.ip.basecomps.util.reg.Registration;
import com.sap.ip.basecomps.util.reg.SimpleRegistration;
import java.util.Vector;

public abstract class RegistrationDestination {
    private static Vector registrations = new Vector();
    private static boolean busy = false;

    protected static void inc(Registration r) {
        r.inc();
    }

    protected static void dec(Registration r) {
        r.dec();
    }

    public static synchronized void registerRegistrationHandler(IRegistrationHandler h) {
        Registration r;
        int size = registrations.size();
        int i = 0;
        while (i < size) {
            r = (Registration)registrations.elementAt(i);
            if (r.getObject() == h) {
                return;
            }
            ++i;
        }
        r = new RegistrationRegistration(h);
        RegistrationDestination.inc(r);
        registrations.add(r);
    }

    public static synchronized void unregisterRegistrationHandler(IRegistrationHandler h) {
        if (busy) {
            registrations = (Vector)registrations.clone();
            busy = false;
        }
        int size = registrations.size();
        int i = 0;
        while (i < size) {
            Registration r = (Registration)registrations.elementAt(i);
            if (r.getObject() == h) {
                registrations.removeElementAt(i);
                RegistrationDestination.dec(r);
            }
            ++i;
        }
    }

    static synchronized void notifyRegistration(Registration reg) {
        Vector regs = registrations;
        int size = regs.size();
        busy = true;
        int i = 0;
        while (i < size) {
            RegistrationRegistration r = (RegistrationRegistration)regs.elementAt(i);
            r.getRegistrationHandler().notifyRegistration(reg);
            ++i;
        }
        busy = false;
    }

    static synchronized void notifyUnRegistration(Registration reg) {
        Vector regs = registrations;
        int size = regs.size();
        busy = true;
        int i = 0;
        while (i < size) {
            RegistrationRegistration r = (RegistrationRegistration)regs.elementAt(i);
            r.getRegistrationHandler().notifyUnregistration(reg);
            ++i;
        }
        busy = false;
    }

    private static class RegistrationRegistration
    extends SimpleRegistration {
        RegistrationRegistration(IRegistrationHandler h) {
            super(h);
        }

        IRegistrationHandler getRegistrationHandler() {
            return (IRegistrationHandler)this.getObject();
        }

        protected void handleUnregister() {
            RegistrationDestination.unregisterRegistrationHandler(this.getRegistrationHandler());
        }

        public String toString() {
            return "registration registration for " + this.getObject();
        }
    }

    public static interface IRegistrationHandler {
        public void notifyRegistration(Registration var1);

        public void notifyUnregistration(Registration var1);
    }
}

