/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.util.reg;

import com.sap.ip.basecomps.util.reg.Registration;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;

public class RegistrationContainer
extends AbstractSet {
    private ReferenceQueue queue = new ReferenceQueue();
    private HashSet cleanup = new HashSet();
    private HashSet registrations = new HashSet();

    /*
     * WARNING - void declaration
     */
    private synchronized void cleanup() {
        Reference r;
        if (this.cleanup.isEmpty()) {
            Iterator i = this.cleanup.iterator();
            this.cleanup = new HashSet();
            while (i.hasNext()) {
                this.registrations.remove(i.next());
            }
        }
        while ((r = this.queue.poll()) != null) {
            void var3_2;
            this.remove(var3_2);
        }
    }

    public boolean unregister(Registration r) {
        if (r != null) {
            RegistrationRef ref = new RegistrationRef(r);
            if (!this.registrations.contains(ref)) {
                return false;
            }
            this.registrations.remove(ref);
            this.cleanup();
            return true;
        }
        return false;
    }

    public boolean register(Registration r) {
        if (r != null) {
            RegistrationRef ref = new RegistrationRef(r);
            if (this.registrations.contains(ref)) {
                return false;
            }
            this.registrations.add(ref);
            this.cleanup();
            return true;
        }
        return false;
    }

    public boolean add(Object o) {
        return this.register((Registration)o);
    }

    public boolean remove(Object o) {
        return this.unregister((Registration)o);
    }

    public synchronized void clear() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public synchronized boolean contains(Object o) {
        if (o instanceof Registration) {
            return this.registrations.contains(new RegistrationRef(o));
        }
        return false;
    }

    public synchronized int size() {
        return this.registrations.size();
    }

    public synchronized boolean isEmpty() {
        return this.registrations.isEmpty();
    }

    public Iterator iterator() {
        return new RegistrationIterator();
    }

    private class RegistrationIterator
    implements Iterator {
        Iterator i;
        Registration next;

        RegistrationIterator() {
            this.i = RegistrationContainer.this.registrations.iterator();
            this._next();
        }

        private synchronized void _next() {
            this.next = null;
            while (this.next == null && this.i.hasNext()) {
                this.next = ((RegistrationRef)this.i.next()).getRegistration();
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            Registration n = this.next;
            this._next();
            return n;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class RegistrationRef
    extends WeakReference {
        private int hash;

        RegistrationRef(Object o) {
            super(o, RegistrationContainer.this.queue);
            this.hash = o.hashCode();
        }

        public Registration getRegistration() {
            return (Registration)this.get();
        }

        public boolean equals(Object o) {
            Object me = this.get();
            if (me == null) {
                RegistrationContainer.this.cleanup.add(this);
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o instanceof RegistrationRef) {
                Object you = ((RegistrationRef)o).get();
                if (you == null) {
                    RegistrationContainer.this.cleanup.add(o);
                    return false;
                }
                return you == me;
            }
            return o == me;
        }

        public int hashCode() {
            if (this.get() == null) {
                RegistrationContainer.this.cleanup.add(this);
            }
            return this.hash;
        }

        public String toString() {
            return "registrations registration for " + this.get();
        }
    }
}

