/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.util.reg;

import com.sap.ip.basecomps.util.reg.RegistrationDestination;

public abstract class Registration {
    protected volatile int count = 0;

    public Registration() {
        this(null);
    }

    public Registration(Object o) {
        this.setObject(o);
    }

    protected synchronized void inc() {
        ++this.count;
        if (this.count == 1) {
            RegistrationDestination.notifyRegistration(this);
        }
    }

    protected synchronized void dec() {
        if (this.count > 0) {
            --this.count;
            if (this.count <= 0) {
                RegistrationDestination.notifyUnRegistration(this);
            }
        }
    }

    public abstract Object getObject();

    protected abstract void setObject(Object var1);

    public int getRegistrationCount() {
        return this.count;
    }

    public final synchronized void unregister() {
        this.handleUnregister();
        if (this.count > 0) {
            System.err.println("ERROR: registration not fully unregistered " + this);
            RegistrationDestination.notifyUnRegistration(this);
        }
        this.count = 0;
    }

    protected abstract void handleUnregister();

    public void finalize() throws Throwable {
        this.finish();
    }

    public synchronized void finish() {
        if (this.count > 0) {
            RegistrationDestination.notifyUnRegistration(this);
            this.count = 0;
        }
    }
}

