/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.util.reg;

import com.sap.ip.basecomps.util.reg.Registration;
import com.sap.ip.basecomps.util.reg.RegistrationDestination;

public abstract class AbstractRegisteredObjectHandle {
    private Registration reg = new Registration(){

        protected void handleUnregister() {
            this.dec();
            AbstractRegisteredObjectHandle.this.notifyUnregister();
            this.setObject(null);
        }

        public Object getObject() {
            return AbstractRegisteredObjectHandle.this.get();
        }

        protected void setObject(Object o) {
            AbstractRegisteredObjectHandle.this.set(o);
        }
    };

    public AbstractRegisteredObjectHandle() {
        this(null);
    }

    public AbstractRegisteredObjectHandle(Object o) {
        this.setObject(o);
    }

    protected abstract void set(Object var1);

    protected abstract Object get();

    public synchronized Object getObject() {
        Object o;
        if (this.reg.getObject() == null && (o = this.restoreObject()) != null) {
            this.setObject(o);
        }
        return this.get();
    }

    public synchronized void setObject(Object o) {
        if (this.reg.getRegistrationCount() > 0) {
            RegistrationDestination.dec(this.reg);
        }
        this.set(o);
        if (this.get() != null) {
            RegistrationDestination.inc(this.reg);
        }
    }

    public synchronized boolean valid() {
        if (this.get() != null) {
            return true;
        }
        if (this.reg.getRegistrationCount() > 0) {
            RegistrationDestination.dec(this.reg);
        }
        return false;
    }

    protected Object restoreObject() {
        return null;
    }

    protected void notifyUnregister() {
    }
}

