/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Hashtable;

public class WeakHashTable {
    private ReferenceQueue queue = new ReferenceQueue();
    private Hashtable hash = new Hashtable();
    private Hashtable ref_hash = new Hashtable();

    private void removeRef(Reference r) {
        Object k = this.ref_hash.get(r);
        if (k != null) {
            this.hash.remove(k);
        }
        this.ref_hash.remove(r);
    }

    private void addRef(Object key, Object value) {
        WeakReference<Object> r = new WeakReference<Object>(value, this.queue);
        this.ref_hash.put(r, key);
        this.hash.put(key, r);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean containsKey(Object key) {
        Reference e;
        Object obj = null;
        while ((e = this.queue.poll()) != null) {
            void var2_3;
            this.removeRef((Reference)var2_3);
        }
        e = (Reference)this.hash.get(key);
        if (e != null) {
            Object t = e.get();
            obj = t;
            if (t == null) {
                this.removeRef(e);
            }
        }
        return obj != null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Object get(Object key) {
        Reference e;
        Object obj = null;
        while ((e = this.queue.poll()) != null) {
            void var2_3;
            this.removeRef((Reference)var2_3);
        }
        e = (Reference)this.hash.get(key);
        if (e != null) {
            Object t = e.get();
            obj = t;
            if (t == null) {
                this.removeRef(e);
            }
        }
        return obj;
    }

    public synchronized void put(Object key, Object value) {
        this.addRef(key, value);
    }

    public synchronized void remove(Object key) {
        Object r = this.hash.get(key);
        if (r != null) {
            this.ref_hash.remove(r);
        }
        this.hash.remove(key);
    }

    public synchronized void clear() {
        this.hash.clear();
        this.ref_hash.clear();
    }

    public Enumeration keys() {
        return new WeakKeyEnumeration();
    }

    public Enumeration elements() {
        return new WeakEnumeration();
    }

    private class WeakEnumeration
    implements Enumeration {
        Enumeration e;
        Object o;

        /*
         * WARNING - void declaration
         */
        Object next() {
            Reference r;
            while ((r = WeakHashTable.this.queue.poll()) != null) {
                void var1_1;
                WeakHashTable.this.removeRef((Reference)var1_1);
            }
            while (this.e.hasMoreElements()) {
                r = (Reference)this.e.nextElement();
                this.o = r.get();
                if (this.o != null) {
                    return this.o;
                }
                WeakHashTable.this.removeRef(r);
            }
            this.o = null;
            return null;
        }

        WeakEnumeration() {
            this.e = ((Hashtable)WeakHashTable.this.hash.clone()).elements();
            this.next();
        }

        public boolean hasMoreElements() {
            return this.o != null;
        }

        public Object nextElement() {
            Object r = this.o;
            this.next();
            return r;
        }
    }

    private class WeakKeyEnumeration
    implements Enumeration {
        Enumeration e;
        Object o;

        /*
         * WARNING - void declaration
         */
        Object next() {
            Reference r;
            while ((r = WeakHashTable.this.queue.poll()) != null) {
                void var1_1;
                WeakHashTable.this.removeRef((Reference)var1_1);
            }
            while (this.e.hasMoreElements()) {
                Object k = this.e.nextElement();
                r = (Reference)WeakHashTable.this.hash.get(k);
                if (r == null) continue;
                if (r.get() != null) {
                    this.o = k;
                    return this.o;
                }
                WeakHashTable.this.removeRef(r);
            }
            this.o = null;
            return null;
        }

        WeakKeyEnumeration() {
            this.e = ((Hashtable)WeakHashTable.this.hash.clone()).keys();
            this.next();
        }

        public boolean hasMoreElements() {
            return this.o != null;
        }

        public Object nextElement() {
            Object r = this.o;
            this.next();
            return r;
        }
    }
}

