/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.util;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ConcurrentModificationException;
import java.util.Random;

public class UUID
implements Cloneable,
Serializable {
    private static final long timeDiff = 122192928000000000L;
    private static final char[] hexCharacters = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final boolean nativeLibraryAvailable;
    protected static final int randomClockSequence;
    protected static final byte[] randomNodeId;
    protected static long previousTime;
    protected String uuid = null;
    static /* synthetic */ Class class$com$sap$ip$basecomps$util$UUID;

    public UUID() {
        this.uuid = "00000000-0000-0000-0000-000000000000";
    }

    public UUID(String uuid) throws NumberFormatException {
        if (uuid.length() != 36 || uuid.charAt(8) != '-' || uuid.charAt(13) != '-' || uuid.charAt(18) != '-' || uuid.charAt(23) != '-') {
            throw new NumberFormatException("'" + uuid + "' is not in UUID format xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx");
        }
        Long.parseLong(uuid.substring(0, 8), 16);
        Integer.parseInt(uuid.substring(9, 13), 16);
        Integer.parseInt(uuid.substring(14, 18), 16);
        Integer.parseInt(uuid.substring(19, 23), 16);
        Long.parseLong(uuid.substring(24, 36), 16);
        this.uuid = uuid;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == (class$com$sap$ip$basecomps$util$UUID == null ? (class$com$sap$ip$basecomps$util$UUID = UUID.class$("com.sap.ip.basecomps.util.UUID")) : class$com$sap$ip$basecomps$util$UUID) && this.uuid.equals(((UUID)obj).uuid);
    }

    public int hashCode() {
        try {
            return (int)(Long.parseLong(this.uuid.substring(0, 8), 16) ^ Long.parseLong(this.uuid.substring(28, 36), 16)) ^ (Integer.parseInt(this.uuid.substring(9, 13), 16) ^ Integer.parseInt(this.uuid.substring(19, 23), 16)) << 16 ^ (Integer.parseInt(this.uuid.substring(14, 18), 16) ^ Integer.parseInt(this.uuid.substring(24, 28), 16)) & 0xFFFF;
        }
        catch (NumberFormatException e) {
            return this.uuid.hashCode();
        }
    }

    public static UUID createUUID() {
        UUID uuid = new UUID();
        uuid.generateUUID();
        return uuid;
    }

    public void generateUUID() {
        Class clazz = class$com$sap$ip$basecomps$util$UUID == null ? (class$com$sap$ip$basecomps$util$UUID = UUID.class$("com.sap.ip.basecomps.util.UUID")) : class$com$sap$ip$basecomps$util$UUID;
        synchronized (clazz) {
            String nativeUUID = null;
            if (nativeLibraryAvailable) {
                try {
                    nativeUUID = UUID.getNativeUUID();
                }
                catch (ConcurrentModificationException e) {
                    // empty catch block
                }
            }
            if (nativeUUID != null) {
                this.uuid = nativeUUID;
            } else {
                long currentTime = UUID.getCurrentTime();
                int timeLow = (int)currentTime;
                short timeMid = (short)(currentTime >> 32);
                short timeHiAndVersion = (short)(currentTime >> 48 & 0xFFFL | 0x1000L);
                byte clockSeqHiAndReserved = (byte)(randomClockSequence >> 8 & 0x3F | 0x80);
                byte clockSeqLow = (byte)(randomClockSequence & 0xFF);
                StringBuffer buf = new StringBuffer(36);
                UUID.appendHexValue(buf, timeLow, 8).append('-');
                UUID.appendHexValue(buf, timeMid, 4).append('-');
                UUID.appendHexValue(buf, timeHiAndVersion, 4).append('-');
                UUID.appendHexValue(buf, clockSeqHiAndReserved, 2);
                UUID.appendHexValue(buf, clockSeqLow, 2).append('-');
                int i = 0;
                while (i < 6) {
                    UUID.appendHexValue(buf, randomNodeId[i], 2);
                    ++i;
                }
                this.uuid = buf.toString();
            }
        }
    }

    public boolean isStrong() {
        try {
            return (Integer.parseInt(this.uuid.substring(14, 16), 16) & 0xF0) == 16 && (Integer.parseInt(this.uuid.substring(19, 21), 16) & 0xC0) == 128 && (Integer.parseInt(this.uuid.substring(24, 26), 16) & 0x80) == 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected static synchronized long getCurrentTime() {
        long currentTime;
        while (previousTime >= (currentTime = System.currentTimeMillis() * 10000L + 122192928000000000L)) {
            if (previousTime - currentTime >= 9999L) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            currentTime = previousTime + 1L;
            break;
        }
        previousTime = currentTime;
        return currentTime;
    }

    private static final StringBuffer appendHexValue(StringBuffer buf, int v, int len) {
        int i = (len - 1) * 4;
        while (i >= 0) {
            buf.append(hexCharacters[v >> i & 0xF]);
            i -= 4;
        }
        return buf;
    }

    public String toString() {
        return this.uuid;
    }

    private static native String getNativeUUID() throws ConcurrentModificationException;

    public static void main(String[] args) {
        UUID uuid1 = new UUID();
        UUID uuid2 = new UUID();
        System.out.println("Nil UUID          : " + uuid1.toString() + (uuid1.isStrong() ? " (strong)" : " (weak)"));
        uuid1.generateUUID();
        uuid2.generateUUID();
        System.out.println("Generated UUID 1  : " + uuid1.toString() + (uuid1.isStrong() ? " (strong)" : " (weak)"));
        System.out.println("Generated UUID 2  : " + uuid2.toString() + (uuid2.isStrong() ? " (strong)" : " (weak)"));
        UUID uuid2c = new UUID(uuid2.toString());
        System.out.println("Copied UUID 2     : " + uuid2c.toString() + (uuid2c.isStrong() ? " (strong)" : " (weak)"));
        uuid2.generateUUID();
        System.out.println("Regenerated UUID 2: " + uuid2.toString() + (uuid2.isStrong() ? " (strong)" : " (weak)"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        previousTime = 0L;
        boolean loadSuccessful = false;
        try {
            System.loadLibrary("UUID");
            loadSuccessful = true;
        }
        catch (UnsatisfiedLinkError e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        nativeLibraryAvailable = loadSuccessful;
        SecureRandom random = new SecureRandom();
        randomClockSequence = random.nextInt(16384);
        randomNodeId = new byte[6];
        ((Random)random).nextBytes(randomNodeId);
        randomNodeId[0] = (byte)(randomNodeId[0] | 0x80);
    }
}

