/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.test;

import com.sap.ip.basecomps.debug.Debug;
import com.sap.ip.basecomps.test.CmdInt;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.TraceFormatter;
import java.util.Enumeration;

public class MainTestEnv
extends CmdInt.Interpreter {
    static final ConsoleLog console = new ConsoleLog();
    static final Category stdout = com.sap.ip.basecomps.debug.Log.stdout;
    static final CmdInt.Command[] c;
    private static CmdInt.Interpreter mainenv;

    public static void TestEnv() {
        System.out.println(mainenv.getHelp());
        mainenv.Interpret();
    }

    public static void TestEnv(CmdInt.CmdReader r) {
        mainenv.Interpret(r);
    }

    public static void addTestEnv(CmdInt.Interpreter env) {
        mainenv.addCommand(env);
    }

    public static void removeTestEnv(CmdInt.Interpreter env) {
        mainenv.removeCommand(env);
    }

    public static void removeTestEnv(String name) {
        mainenv.removeCommand(name);
    }

    private MainTestEnv() {
        super("tst", "*** Welcome to the main test system ***", c);
        System.out.println("main test env created");
    }

    static {
        ((TraceFormatter)console.getFormatter()).setPattern("%m");
        stdout.addLog((Log)console);
        c = new CmdInt.Command[]{new LoadCmd(), new DebCmd(), new EchoCmd(), new CmdInt.Interpreter.QuitCmd()};
        mainenv = new MainTestEnv();
    }

    public static class DebCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public DebCmd() {
            super("debug", "[key [on|off|console]]", "get/set debug mode");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            boolean force = false;
            if (args.length > 1 && args[1].equals("-f")) {
                args = CmdInt.shiftArgs(args);
                force = true;
            }
            if (args.length > 3) {
                CmdInt.SimpleCommand.TooManyArguments();
            }
            if (args.length == 1) {
                Enumeration e = Debug.getDebugKeys();
                while (e.hasMoreElements()) {
                    String n = (String)e.nextElement();
                    Debug d = Debug.queryDebug(n);
                    System.out.println("  " + n + ": " + (d.active() ? "on" : "off"));
                }
            } else {
                Debug d = force ? Debug.getDebug(args[1]) : Debug.queryDebug(args[1]);
                if (d == null) {
                    System.out.println(" debug key '" + args[1] + "' not used");
                } else if (args.length == 2) {
                    System.out.println("debug for " + args[1] + " is " + (d.active() ? "on" : "off"));
                } else {
                    Location l = d.getLocation();
                    if (args[2].equals("on")) {
                        d.setActive(true);
                    } else if (args[2].equals("console")) {
                        d.setActive(true);
                        l.addLog((Log)console);
                    } else if (args[2].equals("off")) {
                        d.setActive(false);
                        l.removeLog((Log)console);
                    } else {
                        CmdInt.SimpleCommand.Error("illegal debug mode");
                    }
                }
            }
            return 0;
        }
    }

    public static class EchoCmd
    extends CmdInt.SimpleCommand {
        public EchoCmd() {
            super("echo", "{<text>}", "echo arguments");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            int i = 1;
            while (i < args.length) {
                System.out.print((i > 1 ? " " : "") + args[i]);
                ++i;
            }
            System.out.println();
            return 0;
        }
    }

    public static class LoadCmd
    extends CmdInt.SimpleCommand {
        public LoadCmd() {
            super("load", "<class> {<class>}", "load classes");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            if (args.length < 2) {
                CmdInt.SimpleCommand.Error("class name missing");
            }
            int i = 1;
            while (i < args.length) {
                try {
                    Class.forName(args[i]);
                }
                catch (Exception e) {
                    CmdInt.SimpleCommand.Error("cannot load class " + args[i] + ": " + e);
                }
                ++i;
            }
            return 0;
        }
    }
}

