/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Stack;
import java.util.Vector;

public abstract class CmdInt {
    private static Command helpcmd = new Interpreter.HelpCmd();
    public static final int OK = 0;
    public static final int ERR = 1;
    public static final int EXIT = 2;
    private static ThreadLocal stack = new ThreadLocal();

    public static String[] shiftArgs(String[] src, int n) {
        String[] dst = new String[src.length - n];
        int i = n;
        while (i < src.length) {
            dst[i - n] = src[i];
            ++i;
        }
        return dst;
    }

    public static String[] shiftArgs(String[] src) {
        return CmdInt.shiftArgs(src, 1);
    }

    private static Stack getStack() {
        Stack s = (Stack)stack.get();
        if (s == null) {
            s = new Stack();
            stack.set(s);
        }
        return s;
    }

    public static int Error(String txt) {
        Stack s = CmdInt.getStack();
        String cmds = "Error: ";
        int i = 0;
        while (i < s.size()) {
            cmds = cmds + s.elementAt(i) + ": ";
            ++i;
        }
        System.err.println(cmds + txt);
        return 1;
    }

    public static void Warning(String txt) {
        Stack s = CmdInt.getStack();
        String cmds = "Warning: ";
        int i = 0;
        while (i < s.size()) {
            cmds = cmds + s.elementAt(i) + ": ";
            ++i;
        }
        System.err.println(cmds + txt);
    }

    public static class CmdException
    extends RuntimeException {
        public CmdException(String txt) {
            super(txt);
        }
    }

    public static abstract class SubCommand
    extends Interpreter {
        public SubCommand(String name, String syntax, String help, Command[] cmds) {
            super(name, syntax, help, cmds);
        }

        public int Exec(Interpreter cmdint, String[] args) {
            if (args.length <= 1) {
                SimpleCommand.Error("sub command missing");
            }
            return super.Exec(cmdint, args);
        }
    }

    public static abstract class SimpleCommand
    implements Command {
        private String name;
        private String syntax;
        private String help;

        public SimpleCommand(String name, String syntax, String help) {
            this.name = name;
            this.syntax = syntax;
            this.help = help;
        }

        public String getName() {
            return this.name;
        }

        public String getSyntax() {
            return this.syntax;
        }

        public String getHelp() {
            return this.help;
        }

        public static void Error(String txt) {
            throw new CmdException(txt);
        }

        public static void Warning(String txt) {
            CmdInt.Warning(txt);
        }

        public static void TooManyArguments() {
            SimpleCommand.TooManyArguments(null);
        }

        public static void TooManyArguments(String txt) {
            SimpleCommand.Error("too many arguments" + (txt != null ? ": " + txt : ""));
        }

        public static void ArgumentMissing() {
            SimpleCommand.Error("argument(s) missing");
        }

        public static void ArgumentMissing(String arg) {
            SimpleCommand.Error("<" + arg + "> missing");
        }

        public static void CheckNumberOfArguments(String[] args, int min, int max) {
            if (args.length < min) {
                SimpleCommand.ArgumentMissing();
            }
            if (args.length > max) {
                SimpleCommand.TooManyArguments();
            }
        }

        public static void CheckNumberOfArguments(String[] args, int min, int max, String txt) {
            if (args.length < min) {
                SimpleCommand.ArgumentMissing(txt);
            }
            if (args.length > max) {
                SimpleCommand.TooManyArguments();
            }
        }

        public static void CheckNumberOfArguments(String[] args, int expected) {
            SimpleCommand.CheckNumberOfArguments(args, expected, expected);
        }

        public static void CheckNumberOfArguments(String[] args, int expected, String txt) {
            SimpleCommand.CheckNumberOfArguments(args, expected, expected, txt);
        }

        public static void Route(Exception e) {
            if (e instanceof CmdException) {
                throw (CmdException)e;
            }
            throw new RouteException(e);
        }

        public abstract int Exec(Interpreter var1, String[] var2);
    }

    public static interface Command {
        public String getName();

        public String getSyntax();

        public String getHelp();

        public int Exec(Interpreter var1, String[] var2);
    }

    public static abstract class Interpreter
    extends com.sap.ip.basecomps.test.CmdInt$SimpleCommand {
        private ThreadLocal input = new ThreadLocal();
        protected Vector cmds = new Vector();

        public Interpreter(String name, String help, Command[] cmds) {
            this(name, "[<subcmd>]", help, cmds);
        }

        public Interpreter(String name, String syntax, String help, Command[] cmds) {
            super(name, syntax, help);
            if (cmds != null) {
                int i = 0;
                while (i < cmds.length) {
                    this.cmds.addElement(cmds[i]);
                    ++i;
                }
            } else {
                System.out.println("no commands given");
            }
        }

        public int Exec(Interpreter cmdint, String[] args) {
            this.input.set(cmdint.getInput());
            if (args.length > 1) {
                return this.Exec(CmdInt.shiftArgs(args, 1));
            }
            return this.Interpret(cmdint.getInput());
        }

        public int Exec(String[] args) {
            Stack s = CmdInt.getStack();
            if (args.length > 0) {
                int i;
                block8: {
                    Command cmd = this.getCommand(args[0]);
                    if (cmd == null) {
                        s.push(args[0]);
                        i = CmdInt.Error("command not found");
                    } else {
                        args[0] = cmd.getName();
                        s.push(args[0]);
                        try {
                            if (!(cmd instanceof Interpreter) && args.length == 2 && args[1].equals("?")) {
                                System.out.println(cmd.getName() + " " + cmd.getSyntax() + ": " + cmd.getHelp());
                                i = 0;
                            } else {
                                i = cmd.Exec(this, args);
                            }
                        }
                        catch (CmdException e) {
                            i = CmdInt.Error(e.getMessage());
                        }
                        catch (Exception e) {
                            String str = e.toString();
                            i = CmdInt.Error(str);
                            if (str.indexOf("CmdException") >= 0) break block8;
                            e.printStackTrace();
                        }
                    }
                }
                s.pop();
                return i;
            }
            return 0;
        }

        public int Interpret() {
            return this.Interpret(new CmdReader(System.in));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int Interpret(CmdReader stdin) {
            Parser p = new Parser();
            this.input.set(stdin);
            try {
                if (stdin.getInteractive()) {
                    System.out.print(this.getName() + "> ");
                    System.out.flush();
                }
                block2: while (true) {
                    int i;
                    String[] args;
                    if (!p.reset(stdin.readLine())) {
                        return 0;
                    }
                    do {
                        if (!p.end()) continue;
                        if (!stdin.getInteractive()) continue block2;
                        System.out.print(this.getName() + "> ");
                        System.out.flush();
                        continue block2;
                    } while ((args = p.parse()) == null || (i = this.Exec(args)) != 2);
                    break;
                }
                return 0;
            }
            catch (IOException e) {
                return 1;
            }
        }

        public void addCommand(Command cmd) {
            this.removeCommand(cmd.getName());
            this.cmds.addElement(cmd);
        }

        public void removeCommand(Command cmd) {
            this.cmds.removeElement(cmd);
        }

        public void removeCommand(String name) {
            int i = 0;
            while (i < this.cmds.size()) {
                if (((Command)this.cmds.elementAt(i)).getName().equals(name)) {
                    this.cmds.removeElementAt(i);
                    break;
                }
                ++i;
            }
        }

        public Command[] getCommands() {
            Command[] cmds = new Command[this.cmds.size()];
            int i = 0;
            while (i < this.cmds.size()) {
                cmds[i] = (Command)this.cmds.elementAt(i);
                ++i;
            }
            return cmds;
        }

        public Command getCommand(String name) {
            int i = 0;
            while (i < this.cmds.size()) {
                if (this.match((Command)this.cmds.elementAt(i), name)) {
                    return (Command)this.cmds.elementAt(i);
                }
                ++i;
            }
            if (this.match(helpcmd, name) || name.equals("?")) {
                return helpcmd;
            }
            return null;
        }

        public CmdReader getInput() {
            return (CmdReader)this.input.get();
        }

        protected boolean match(Command cmd, String name) {
            return cmd.getName().regionMatches(0, name, 0, name.length());
        }

        public static class QuitCmd
        extends SimpleCommand {
            public QuitCmd() {
                super("quit", "", "quit current command level");
            }

            public QuitCmd(String name) {
                super(name, "", "quit current command level");
            }

            public QuitCmd(String name, String help) {
                super(name, "", help);
            }

            public int Exec(Interpreter cmdint, String[] args) {
                return 2;
            }
        }

        public static class HelpCmd
        extends SimpleCommand {
            public HelpCmd() {
                super("help", "help [<cmd>]", "print help text");
            }

            public int Exec(Interpreter cmdint, String[] args) {
                Command cmd = null;
                int i = 1;
                while (args.length > i) {
                    cmd = cmdint.getCommand(args[i]);
                    if (cmd == null) continue;
                    if (!(cmd instanceof CmdInt)) break;
                    cmdint = (Interpreter)cmd;
                    ++i;
                }
                if (cmd == null) {
                    if (args.length == 1) {
                        Command[] cmds = cmdint.getCommands();
                        if (cmds != null) {
                            int ns = 0;
                            int ss = 0;
                            System.out.println("List of commands");
                            i = 0;
                            while (cmds.length > i) {
                                int l = cmds[i].getName().length();
                                if (l > ns) {
                                    ns = l;
                                }
                                if ((l = cmds[i].getSyntax().length()) > ss) {
                                    ss = l;
                                }
                                ++i;
                            }
                            i = 0;
                            while (cmds.length > i) {
                                System.out.println(this.format(ns, cmds[i].getName()) + " " + this.format(ss, cmds[i].getSyntax()) + " " + cmds[i].getHelp());
                                ++i;
                            }
                        } else {
                            System.out.println("no commands available");
                        }
                    } else {
                        System.out.println("command not found");
                    }
                } else {
                    System.out.println(cmd.getName() + " " + cmd.getSyntax() + " : " + cmd.getHelp());
                }
                return 0;
            }

            private String format(int len, String s) {
                int l = s.length();
                String sp = "                                                                                                                     ";
                return s + sp.substring(0, len - l);
            }
        }

        public static abstract class SimpleCommand
        extends com.sap.ip.basecomps.test.CmdInt$SimpleCommand {
            public SimpleCommand(String name, String syntax, String help) {
                super(name, syntax, help);
            }
        }
    }

    private static class Parser {
        public String s;
        public int pos;

        public Parser(String s) {
            this.s = s;
            this.reset();
        }

        public Parser() {
            this.reset(this.s);
        }

        public boolean reset(String s) {
            this.s = s;
            return this.reset();
        }

        public boolean reset() {
            this.pos = 0;
            return this.s != null;
        }

        public void next() {
            ++this.pos;
        }

        public char cur() {
            return this.s.charAt(this.pos);
        }

        public boolean end() {
            return this.pos >= this.s.length();
        }

        /*
         * WARNING - void declaration
         */
        public String[] parse() {
            String[] sargs;
            char c;
            Vector<String> args = new Vector<String>();
            StringBuffer arg = new StringBuffer();
            boolean valid = false;
            boolean mask = false;
            boolean quote = false;
            block6: while (!this.end() && ((c = this.cur()) != ';' || mask || quote)) {
                void var7_6;
                this.next();
                switch (var7_6) {
                    case 92: {
                        if (mask) {
                            arg.append((char)var7_6);
                            valid = true;
                            mask = false;
                            break;
                        }
                        mask = true;
                        break;
                    }
                    case 34: {
                        if (mask) {
                            arg.append((char)var7_6);
                            valid = true;
                            mask = false;
                            break;
                        }
                        boolean bl = quote = !quote;
                        if (quote) {
                            valid = true;
                        }
                        valid = true;
                        mask = false;
                        break;
                    }
                    case 32: {
                        if (mask || quote) {
                            arg.append((char)var7_6);
                            valid = true;
                            mask = false;
                            break;
                        }
                        if (!valid) continue block6;
                        valid = false;
                        args.add(arg.toString());
                        arg.setLength(0);
                        break;
                    }
                    case 35: {
                        if (valid || mask || quote) {
                            arg.append((char)var7_6);
                            valid = true;
                            mask = false;
                            break;
                        }
                        this.pos = this.s.length();
                        break;
                    }
                    default: {
                        arg.append((char)var7_6);
                        valid = true;
                        mask = false;
                    }
                }
            }
            if (!this.end() && this.cur() == ';') {
                this.next();
            }
            args.trimToSize();
            if (valid) {
                args.add(arg.toString());
            }
            if (args.size() > 0) {
                sargs = new String[args.size()];
                int i = 0;
                while (i < args.size()) {
                    sargs[i] = (String)args.elementAt(i);
                    ++i;
                }
            } else {
                sargs = null;
            }
            return sargs;
        }
    }

    public static class CmdReader
    extends BufferedReader {
        boolean interactive;

        public boolean getInteractive() {
            return this.interactive;
        }

        public CmdReader(Reader r, boolean interactive) {
            super(r);
            this.interactive = interactive;
        }

        public CmdReader(Reader r) {
            this(r, false);
        }

        public CmdReader(InputStream s) {
            this((Reader)new InputStreamReader(s), s == System.in);
        }
    }

    public static class RouteException
    extends RuntimeException {
        private Exception exc;

        public RouteException(Exception e) {
            this.exc = e;
        }

        public String getMessage() {
            return this.exc.getMessage();
        }

        public String toString() {
            return this.exc.toString();
        }

        public void printStackTrace() {
            this.exc.printStackTrace();
        }
    }
}

