/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.io;

import com.sap.ip.basecomps.io.FilesObserver;
import com.sap.ip.basecomps.io.IFilesObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class Files {
    private static IFilesObserver execute = new ExecutionObserver(null);

    public static boolean copyFile(File srcFile, File dstFile) {
        return Files.handleCopyFile(srcFile, dstFile, execute);
    }

    public static boolean copyFile(File srcFile, File dstFile, IFilesObserver observer) {
        return Files.handleCopyFile(srcFile, dstFile, observer == null ? execute : (observer instanceof ExecutionObserver ? observer : new ExecutionObserver(observer)));
    }

    private static boolean handleCopyFile(File srcFile, File dstFile, IFilesObserver observer) {
        observer.onCopyFileInvoke(srcFile, dstFile);
        if (srcFile.exists()) {
            File[] srcFiles;
            if (dstFile.exists()) {
                Files.handleDeleteFile(dstFile, observer);
            }
            if (srcFile.isDirectory() && (srcFiles = srcFile.listFiles()) != null) {
                int i = 0;
                while (i < srcFiles.length) {
                    Files.handleCopyFile(srcFiles[i], new File(dstFile, srcFiles[i].getName()), observer);
                    ++i;
                }
            }
            observer.onCopyFileProcessed(srcFile, dstFile);
            return true;
        }
        return false;
    }

    public static boolean deleteFile(File file) {
        return Files.handleDeleteFile(file, execute);
    }

    public static boolean deleteFile(File file, IFilesObserver observer) {
        return Files.handleDeleteFile(file, observer == null ? execute : (observer instanceof ExecutionObserver ? observer : new ExecutionObserver(observer)));
    }

    private static boolean handleDeleteFile(File file, IFilesObserver observer) {
        observer.onDeleteFileInvoke(file);
        if (file.exists()) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                int i = 0;
                while (i < files.length) {
                    Files.handleDeleteFile(files[i], observer);
                    ++i;
                }
            }
            observer.onDeleteFileProcessed(file);
            return true;
        }
        return false;
    }

    public static boolean syncFileOld(File srcFile, File dstFile) {
        return Files.syncFileOld(srcFile, dstFile, null);
    }

    public static boolean syncFileOld(File srcFile, File dstFile, IFilesObserver observer) {
        if (observer != null) {
            observer.onSyncFileInvoke(srcFile, dstFile);
        }
        if (srcFile.exists()) {
            if (srcFile.isDirectory()) {
                File[] srcFiles = srcFile.listFiles();
                if (dstFile.exists()) {
                    if (dstFile.isFile()) {
                        Files.deleteFile(dstFile, observer);
                    } else {
                        File[] dstFiles = dstFile.listFiles();
                        if (dstFiles != null) {
                            int i = 0;
                            while (i < dstFiles.length) {
                                boolean foundFile = false;
                                int j = 0;
                                while (j < srcFiles.length) {
                                    if (dstFiles[i].getName().equals(srcFiles[j].getName())) {
                                        foundFile = true;
                                    }
                                    ++j;
                                }
                                if (!foundFile) {
                                    Files.deleteFile(dstFiles[i], observer);
                                }
                                ++i;
                            }
                        }
                    }
                }
                dstFile.mkdirs();
                if (srcFiles != null) {
                    int i = 0;
                    while (i < srcFiles.length) {
                        Files.syncFileOld(srcFiles[i], new File(dstFile, srcFiles[i].getName()), observer);
                        ++i;
                    }
                }
            } else {
                if (dstFile.exists()) {
                    if (dstFile.isDirectory()) {
                        Files.deleteFile(dstFile, observer);
                    } else if (dstFile.lastModified() < srcFile.lastModified()) {
                        Files.deleteFile(dstFile, observer);
                    }
                }
                if (!dstFile.exists()) {
                    Files.copyFile(srcFile, dstFile, observer);
                }
            }
            if (observer != null) {
                observer.onSyncFileProcessed(srcFile, dstFile);
            }
            return true;
        }
        if (Files.deleteFile(dstFile, observer)) {
            if (observer != null) {
                observer.onSyncFileProcessed(srcFile, dstFile);
            }
            return true;
        }
        return false;
    }

    public static boolean checkSyncFile(File srcFile, File dstFile, IFilesObserver observer) {
        boolean required = false;
        if (observer != null) {
            observer.onSyncFileInvoke(srcFile, dstFile);
        }
        if (srcFile.exists()) {
            if (srcFile.isDirectory()) {
                File[] srcFiles = srcFile.listFiles();
                if (dstFile.exists()) {
                    if (!dstFile.isDirectory()) {
                        required |= Files.handleDeleteFile(dstFile, observer);
                    } else {
                        File[] dstFiles = dstFile.listFiles();
                        if (dstFiles != null) {
                            int i = 0;
                            while (i < dstFiles.length) {
                                boolean foundFile = false;
                                int j = 0;
                                while (j < srcFiles.length) {
                                    if (dstFiles[i].getName().equals(srcFiles[j].getName())) {
                                        foundFile = true;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!foundFile) {
                                    required |= Files.handleDeleteFile(dstFiles[i], observer);
                                }
                                ++i;
                            }
                        }
                    }
                }
                if (srcFiles != null) {
                    int i = 0;
                    while (i < srcFiles.length) {
                        required |= Files.checkSyncFile(srcFiles[i], new File(dstFile, srcFiles[i].getName()), observer);
                        ++i;
                    }
                }
            } else {
                if (dstFile.exists()) {
                    if (dstFile.isDirectory()) {
                        required |= Files.handleDeleteFile(dstFile, observer);
                    } else if (dstFile.lastModified() < srcFile.lastModified()) {
                        required |= Files.handleDeleteFile(dstFile, observer);
                    }
                }
                if (!dstFile.exists()) {
                    required |= Files.handleCopyFile(srcFile, dstFile, observer);
                }
            }
        } else if (Files.handleDeleteFile(dstFile, observer)) {
            required = true;
        }
        if (observer != null) {
            observer.onSyncFileProcessed(srcFile, dstFile);
        }
        return required;
    }

    public static boolean syncFile(File srcFile, File dstFile) {
        return Files.checkSyncFile(srcFile, dstFile, execute);
    }

    public static boolean syncFile(File srcFile, File dstFile, IFilesObserver observer) {
        return Files.checkSyncFile(srcFile, dstFile, observer == null ? execute : (observer instanceof ExecutionObserver ? observer : new ExecutionObserver(observer)));
    }

    public static Collection checkSyncFile(File srcFile, File dstFile) {
        CollectObserver observer = new CollectObserver();
        Files.checkSyncFile(srcFile, dstFile, observer);
        return observer.operations;
    }

    public static void executeSyncCollection(Collection c) {
        Iterator elems = c.iterator();
        while (elems.hasNext()) {
            ExecutionNode n = (ExecutionNode)elems.next();
            n.execute();
        }
    }

    public static String fixFilePath(String filePath) {
        return Files.fixFilePath(filePath, null);
    }

    public static String fixFilePath(String filePath, String absFilePath) {
        if (filePath != null) {
            int pos = -1;
            filePath = Files.fixFilePathSeparators(filePath);
            if (absFilePath != null) {
                if (filePath.startsWith(".")) {
                    filePath = Files.fixFilePathSeparators(absFilePath) + File.separator + filePath;
                }
                if (filePath.startsWith(File.separatorChar + ".")) {
                    filePath = Files.fixFilePathSeparators(absFilePath) + filePath;
                }
            }
            if (filePath.indexOf(":") != -1) {
                while (filePath.startsWith(File.separator)) {
                    filePath = filePath.substring(File.separator.length());
                }
            }
            while ((pos = filePath.indexOf(File.separator + File.separator)) != -1) {
                filePath = filePath.substring(0, pos) + filePath.substring(pos + 1);
            }
            while ((pos = filePath.indexOf(File.separator + "." + File.separator)) != -1) {
                filePath = filePath.substring(0, pos) + filePath.substring(pos + File.separator.length() + 1);
            }
            while ((pos = filePath.indexOf(File.separator + ".." + File.separator)) != -1) {
                filePath = filePath.substring(0, filePath.lastIndexOf(File.separator, pos - File.separator.length())) + filePath.substring(pos + File.separator.length() + 2);
            }
            while (filePath.endsWith(File.separator)) {
                filePath = filePath.substring(0, filePath.length() - File.separator.length());
            }
        }
        return filePath;
    }

    public static String fixFilePathSeparators(String filePath) {
        if (File.separatorChar == '\\') {
            return filePath.replace('/', '\\');
        }
        if (File.separatorChar == '/') {
            return filePath.replace('\\', '/');
        }
        return filePath;
    }

    public static class DeleteNode
    implements ExecutionNode {
        File file;

        public DeleteNode(File file) {
            this.file = file;
        }

        public void execute() {
            execute.onDeleteFileProcessed(this.file);
        }
    }

    public static class CopyNode
    implements ExecutionNode {
        File srcFile;
        File dstFile;

        public CopyNode(File srcFile, File dstFile) {
            this.srcFile = srcFile;
            this.dstFile = dstFile;
        }

        public void execute() {
            execute.onCopyFileProcessed(this.srcFile, this.dstFile);
        }
    }

    public static interface ExecutionNode {
        public void execute();
    }

    private static class CollectObserver
    extends FilesObserver {
        Vector operations = new Vector();

        CollectObserver() {
        }

        public Collection getOperations() {
            return this.operations;
        }

        public void onCopyFileProcessed(File srcFile, File dstFile) {
            CopyNode n = new CopyNode(srcFile, dstFile);
            this.operations.add(n);
        }

        public void onDeleteFileProcessed(File file) {
            DeleteNode n = new DeleteNode(file);
            this.operations.add(n);
        }
    }

    private static class ExecutionObserver
    implements IFilesObserver {
        private IFilesObserver observer;

        ExecutionObserver() {
            this(null);
        }

        ExecutionObserver(IFilesObserver observer) {
            this.observer = observer;
        }

        public void onCopyFileInvoke(File srcFile, File dstFile) {
            if (this.observer != null) {
                this.observer.onCopyFileInvoke(srcFile, dstFile);
            }
        }

        /*
         * Loose catch block
         */
        public void onCopyFileProcessed(File srcFile, File dstFile) {
            block23: {
                OutputStream destStream;
                FileInputStream srcStream;
                if (srcFile.isDirectory()) {
                    dstFile.mkdirs();
                } else {
                    srcStream = null;
                    destStream = null;
                    dstFile.getParentFile().mkdirs();
                    srcStream = new FileInputStream(srcFile);
                    destStream = new FileOutputStream(dstFile);
                    byte[] data = new byte[4096];
                    int count = 0;
                    while ((count = ((InputStream)srcStream).read(data)) != -1) {
                        destStream.write(data, 0, count);
                    }
                    Object var8_8 = null;
                    try {
                        if (destStream != null) {
                            destStream.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        if (srcStream != null) {
                            ((InputStream)srcStream).close();
                        }
                        break block23;
                    }
                    catch (Exception exception2) {}
                }
                break block23;
                {
                    catch (Exception exception) {
                        Object var8_9 = null;
                        try {
                            if (destStream != null) {
                                destStream.close();
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        try {
                            if (srcStream != null) {
                                ((InputStream)srcStream).close();
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        if (destStream != null) {
                            destStream.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        if (srcStream != null) {
                            ((InputStream)srcStream).close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (this.observer != null) {
                this.observer.onCopyFileProcessed(srcFile, dstFile);
            }
        }

        public void onDeleteFileInvoke(File file) {
            if (this.observer != null) {
                this.observer.onDeleteFileInvoke(file);
            }
        }

        public void onDeleteFileProcessed(File file) {
            if (file.delete() && this.observer != null) {
                this.observer.onDeleteFileProcessed(file);
            }
        }

        public void onSyncFileInvoke(File srcFile, File dstFile) {
            if (this.observer != null) {
                this.observer.onSyncFileInvoke(srcFile, dstFile);
            }
        }

        public void onSyncFileProcessed(File srcFile, File dstFile) {
            if (this.observer != null) {
                this.observer.onSyncFileProcessed(srcFile, dstFile);
            }
        }
    }
}

