/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.io;

import com.sap.ip.basecomps.io.AnnotatedObjectInputStream;
import com.sap.ip.basecomps.io.AnnotatedObjectOutputStream;
import com.sap.ip.basecomps.util.reg.SimpleRegistration;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

public final class AnnotatedObjectStream {
    private static HashMap mappers = new HashMap();
    static /* synthetic */ Class class$com$sap$ip$basecomps$io$AnnotatedObjectStream;

    private AnnotatedObjectStream() {
    }

    private static synchronized ClassMapper getMapper(String name) {
        return (ClassMapper)mappers.get(name);
    }

    private static synchronized void unregisterClassMapper(ClassMapper m) {
        mappers.remove(m.getName());
    }

    public static synchronized void registerClassMapper(String name, IClassMapper mapper) {
        mappers.put(name, new ClassMapper(name, mapper));
    }

    public static void unregisterClassMapper(String name) {
        ClassMapper m = AnnotatedObjectStream.getMapper(name);
        if (m != null) {
            m.unregister();
        }
    }

    static String mapToId(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o instanceof Class ? (Class<?>)o : o.getClass();
        return AnnotatedObjectStream.mapToId(c);
    }

    static synchronized String mapToId(Class c) {
        Iterator i = mappers.keySet().iterator();
        String id = null;
        while (id == null && i.hasNext()) {
            ClassMapper m = (ClassMapper)mappers.get(i.next());
            if (m == null || (id = m.mapClassToId(c)) == null) continue;
            id = id + "@" + m.getName();
        }
        return id;
    }

    static ClassLoader mapToClassLoader(String id) {
        ClassMapper m;
        int index;
        ClassLoader l = (class$com$sap$ip$basecomps$io$AnnotatedObjectStream == null ? (class$com$sap$ip$basecomps$io$AnnotatedObjectStream = AnnotatedObjectStream.class$("com.sap.ip.basecomps.io.AnnotatedObjectStream")) : class$com$sap$ip$basecomps$io$AnnotatedObjectStream).getClassLoader();
        if (id != null && (index = id.indexOf(64)) > 0 && (m = AnnotatedObjectStream.getMapper(id.substring(index + 1))) != null) {
            l = m.mapIdToClassLoader(id.substring(0, index));
        }
        return l;
    }

    public static ObjectInputStream getObjectInputStream(InputStream inp) throws IOException {
        return new AnnotatedObjectInputStream(inp);
    }

    public static ObjectOutputStream getObjectOutputStream(OutputStream inp) throws IOException {
        return new AnnotatedObjectOutputStream(inp);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ClassMapper
    extends SimpleRegistration {
        String name;

        ClassMapper(String name, IClassMapper mapper) {
            super(mapper);
            this.name = name;
        }

        protected void handleUnregister() {
            AnnotatedObjectStream.unregisterClassMapper(this);
        }

        public String getName() {
            return this.name;
        }

        public IClassMapper getMapper() {
            return (IClassMapper)this.getObject();
        }

        public String mapClassToId(Class c) {
            return this.getMapper().mapClassToId(c);
        }

        public ClassLoader mapIdToClassLoader(String id) {
            return this.getMapper().mapIdToClassLoader(id);
        }
    }

    public static interface IClassMapper {
        public String mapClassToId(Class var1);

        public ClassLoader mapIdToClassLoader(String var1);
    }
}

