/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.io;

import com.sap.ip.basecomps.debug.Debug;
import com.sap.ip.basecomps.io.AnnotatedObjectStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;

public class AnnotatedObjectOutputStream
extends ObjectOutputStream {
    private static Debug deb = Debug.getDebug("applmgmt");
    private int mode = 2;
    static final int MODE_STD = 0;
    static final int MODE_CTX = 1;
    static final int MODE_ANC = 2;

    public AnnotatedObjectOutputStream(OutputStream inp) throws IOException, StreamCorruptedException {
        super(inp);
    }

    public void writeApplicationObject(Object o) throws IOException {
        this.writeApplicationObject(o, o);
    }

    public void writeApplicationObject(Object o, Object context) throws IOException {
        this.writeApplicationObject(o, context == null ? null : AnnotatedObjectStream.mapToId(context));
    }

    private synchronized void writeApplicationObject(Object o, String ctx) throws IOException {
        if (ctx != null) {
            if (deb.active()) {
                deb.out(":writing object context: " + ctx);
            }
            this.writeObject("" + this.mode + "/" + ctx);
        } else {
            this.writeObject("" + this.mode + "/");
        }
        if (deb.active()) {
            deb.out(":writing object: " + o);
        }
        this.writeObject(o);
        this.reset();
    }

    protected void annotateClass(Class cl) throws IOException {
        String name = cl.getName();
        if (this.mode == 2 && !name.startsWith("java.")) {
            String anc;
            try {
                anc = AnnotatedObjectStream.mapToId(cl);
            }
            catch (Exception e) {
                anc = null;
            }
            if (deb.active()) {
                deb.out("annotating class " + name);
            }
            this.writeObject(anc == null ? "" : anc);
        }
    }
}

