/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.io;

import com.sap.ip.basecomps.debug.Debug;
import com.sap.ip.basecomps.io.AnnotatedObjectStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;

public class AnnotatedObjectInputStream
extends ObjectInputStream {
    private static Debug deb = Debug.getDebug("applmgmt");
    private ClassLoader loader;
    private int mode = 0;

    public AnnotatedObjectInputStream(InputStream inp) throws IOException, StreamCorruptedException {
        super(inp);
    }

    public AnnotatedObjectInputStream(ClassLoader loader, InputStream inp) throws IOException, StreamCorruptedException {
        super(inp);
        this.loader = loader;
    }

    public void setDefaultLoader(ClassLoader loader) {
        this.loader = loader;
    }

    protected Class resolveClass(ObjectStreamClass oc) throws IOException, ClassNotFoundException {
        String name = oc.getName();
        if (deb.active()) {
            deb.out("resolve class " + name);
        }
        if (this.mode == 2 && !name.startsWith("java.")) {
            String anc = (String)this.readObject();
            ClassLoader l = null;
            if (deb.active()) {
                deb.out("found annotation " + anc);
            }
            if (!anc.equals("")) {
                l = AnnotatedObjectStream.mapToClassLoader(anc);
            }
            if (l != null) {
                try {
                    return l.loadClass(oc.getName());
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        if (this.loader != null) {
            return this.loader.loadClass(oc.getName());
        }
        return super.resolveClass(oc);
    }

    public synchronized Object readApplicationObject() throws IOException, ClassNotFoundException {
        if (deb.active()) {
            deb.out(":reading object...");
        }
        Object o = this.readObject();
        if (deb.active()) {
            deb.out(":object " + o + " read");
        }
        try {
            String context = (String)o;
            int i = context.indexOf(47);
            if (i > 0) {
                try {
                    this.mode = Integer.parseInt(context.substring(0, i));
                }
                catch (Exception e) {
                    this.mode = 1;
                }
                context = context.substring(i + 1);
            } else {
                this.mode = 1;
            }
            if (context.length() > 0) {
                this.setDefaultLoader(AnnotatedObjectStream.mapToClassLoader(context));
            } else {
                this.setDefaultLoader(null);
            }
            if (deb.active()) {
                deb.out("reading object with context " + context);
            }
            o = this.readObject();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        this.mode = 0;
        if (deb.active()) {
            deb.out("object " + o + " read");
        }
        return o;
    }
}

