/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.debug;

import com.sap.ip.basecomps.debug.Debug;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;

public class Log {
    private static boolean initial;
    public static final Category stdout;
    private static Hashtable hash;
    private String name;
    private Location loc;

    public static Log queryLog(String name) {
        return (Log)hash.get(name);
    }

    public static Enumeration getLogKeys() {
        return hash.keys();
    }

    public static synchronized Log getLog(String name) {
        Log d = (Log)hash.get(name);
        if (d == null) {
            d = new Log(name);
            hash.put(name, d);
        }
        return d;
    }

    public static synchronized Log getLog(Location loc) {
        Log l = (Log)hash.get(loc.getName());
        if (l == null) {
            l = new Log(loc);
            hash.put(loc.getName(), l);
        }
        return l;
    }

    public static synchronized Log getLog(Debug deb) {
        Log l = (Log)hash.get(deb.getName());
        if (l == null) {
            l = new Log(deb);
            hash.put(deb.getName(), l);
        }
        return l;
    }

    public Log(String name) {
        this.name = name;
        this.loc = Debug.getDebug(name).getLocation();
    }

    public Log(Location loc) {
        this.name = loc.getName();
        this.loc = loc;
    }

    public Log(Debug deb) {
        this.name = deb.getName();
        this.loc = deb.getLocation();
    }

    public void println(Object o) {
        if (this.loc != null) {
            stdout.infoT(this.loc, o.toString());
        } else {
            System.out.println(o.toString());
        }
    }

    public void println(String fmt, Object[] oa) {
        if (this.loc != null) {
            stdout.infoT(this.loc, fmt, oa);
        } else {
            System.out.println(MessageFormat.format(fmt, oa));
        }
    }

    public void errorLog(Object o, Exception e) {
        if (this.loc != null) {
            this.loc.errorT("ERROR: " + o.toString() + ": " + e);
        } else {
            System.out.println("ERROR: " + o.toString() + ": " + e);
        }
    }

    public void errorLog(Object o) {
        if (this.loc != null) {
            this.loc.errorT("ERROR: " + o.toString());
        } else {
            System.out.println("ERROR: " + o.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    static {
        stdout = Category.getCategory((String)"/System/StdOut");
        hash = new Hashtable();
    }
}

