/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.debug;

import com.sap.ip.basecomps.debug.Log;
import com.sap.tc.logging.Location;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class Debug {
    public static final int OFF = 0;
    public static final int LIGHT = 1;
    public static final int MEDIUM = 2;
    public static final int INTENSE = 3;
    private static boolean initial;
    public static final String basecomp = "com.sap.ip.basecomps";
    Location loc;
    static boolean off;
    private static Hashtable hash;
    private int level = 0;
    private String name;
    static PrintWriter stdout_startup;
    static Log stdout;
    static boolean started;

    static void out(Debug d, Object o) {
        d.out(o.toString());
    }

    public static Debug queryDebug(String name) {
        return (Debug)hash.get(name);
    }

    public static Enumeration getDebugKeys() {
        return hash.keys();
    }

    public static synchronized Debug getDebug(String name) {
        Debug d = (Debug)hash.get(name);
        if (d == null) {
            d = new Debug(name);
            hash.put(name, d);
        }
        return d;
    }

    public Debug(String name) {
        this.name = name;
        if (started || !name.equals("prof")) {
            this.loc = Location.getLocation((String)("com.sap.ip.basecomps." + name));
            if (this.loc.beInfo()) {
                this.level = this.loc.beDebug() ? 3 : (this.loc.bePath() ? 2 : 1);
                this.setActive(this.level);
            }
        }
    }

    private void checkUpgrade() {
        if (started && this.loc == null) {
            this.loc = Location.getLocation((String)("com.sap.ip.basecomps." + this.name));
            if (this.loc.beInfo()) {
                this.level = this.loc.beDebug() ? 3 : (this.loc.bePath() ? 2 : 1);
            } else if (this.level >= 1) {
                this.setActive(this.level);
            }
        }
    }

    public void out(Object o) {
        if (off) {
            return;
        }
        if (this.loc != null) {
            this.loc.infoT(o.toString());
        } else {
            this.checkUpgrade();
            if (this.level >= 1) {
                Debug.println(o.toString());
            }
        }
    }

    public Throwable errorLog(Object o, Throwable e) {
        System.err.println("" + o + ": " + e);
        if (this.loc != null) {
            this.loc.errorT("ERROR: " + o.toString() + ": " + Debug.generateCallStackMessage(e));
        } else {
            this.checkUpgrade();
            if (this.level >= 1) {
                Debug.println("ERROR: " + o.toString() + ": " + Debug.generateCallStackMessage(e));
            }
        }
        return e;
    }

    public void errorLog(Object o) {
        System.err.println(o);
        if (this.loc != null) {
            this.loc.errorT("ERROR: " + o.toString());
        } else {
            this.checkUpgrade();
            if (this.level >= 1) {
                Debug.println("ERROR: " + o.toString());
            }
        }
    }

    public void lightLog(Object o) {
        if (off) {
            return;
        }
        if (this.loc != null) {
            this.loc.infoT(o.toString());
        } else {
            this.checkUpgrade();
            if (this.level >= 1) {
                Debug.println(o.toString());
            }
        }
    }

    public void mediumLog(Object o) {
        if (off) {
            return;
        }
        if (this.loc != null) {
            this.loc.pathT(o.toString());
        } else {
            this.checkUpgrade();
            if (this.level >= 2) {
                Debug.println(o.toString());
            }
        }
    }

    public void intenseLog(Object o) {
        if (off) {
            return;
        }
        if (this.loc != null) {
            this.loc.debugT(o.toString());
        } else {
            this.checkUpgrade();
            if (this.level >= 3) {
                Debug.println(o.toString());
            }
        }
    }

    public boolean active() {
        if (off) {
            return false;
        }
        if (this.loc == null) {
            this.checkUpgrade();
            return this.loc == null ? this.level >= 1 : this.loc.beInfo();
        }
        return this.loc.beInfo();
    }

    public void setActive(boolean on) {
        this.setActive(on ? 1 : 0);
    }

    public void setActive(int level) {
        if (this.loc != null) {
            switch (level) {
                case 0: {
                    this.loc.setEffectiveSeverity(400);
                    break;
                }
                case 1: {
                    this.loc.setEffectiveSeverity(300);
                    break;
                }
                case 2: {
                    this.loc.setEffectiveSeverity(200);
                    break;
                }
                case 3: {
                    this.loc.setEffectiveSeverity(100);
                }
            }
        } else {
            this.checkUpgrade();
        }
        Debug.println("setting debug level for " + this.name + " to " + level);
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    public Location getLocation() {
        this.checkUpgrade();
        return this.loc;
    }

    public Log getLog() {
        return Log.getLog(this);
    }

    static void startup() {
        if (!started) {
            try {
                stdout_startup = new PrintWriter(new FileOutputStream("startup.log"));
            }
            catch (FileNotFoundException e) {
                System.err.println("cannot write startup log file: " + e);
            }
            started = true;
        }
    }

    static void notifyLogReady() {
        Debug.println("switching to standard logging now...");
        stdout = Log.getLog("standard");
    }

    public static void println(Object o) {
        if (stdout != null) {
            stdout.println(o);
        } else {
            if (!started) {
                Debug.startup();
            }
            if (stdout_startup != null) {
                stdout_startup.println(o);
                stdout_startup.flush();
            } else {
                System.out.println(o);
            }
        }
    }

    public static String generateCallStackMessage(Throwable exc) {
        StringWriter outStr = new StringWriter();
        PrintWriter out = new PrintWriter(outStr);
        out.print(" ");
        exc.printStackTrace(out);
        out.flush();
        return outStr.toString();
    }

    static {
        off = false;
        Location l = Location.getLocation((String)basecomp);
        hash = new Hashtable();
        String d = System.getProperty("debug");
        initial = d != null;
        started = false;
    }
}

