/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.consistency.test;

import com.sap.ip.basecomps.consistency.ConsistencyDomain;
import com.sap.ip.basecomps.consistency.ConsistencyDomains;
import com.sap.ip.basecomps.test.CmdInt;
import com.sap.ip.basecomps.test.MainTestEnv;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class TestEnv
extends CmdInt.Interpreter
implements ConsistencyDomain.IEventHandler {
    static final CmdInt.Command[] c = new CmdInt.Command[]{new SetupCmd(), new ListCmd(), new SwitchCmd(), new CreateCmd(), new ReleaseCmd(), new QueryCmd(), new LockCmd(), new UnlockCmd(), new PropagateCmd(), new ConfirmCmd(), new CmdInt.Interpreter.QuitCmd()};
    public static final TestEnv env = new TestEnv();
    public ConsistencyDomain domain = null;
    public ConsistencyDomain.Confirmations conf = new ConsistencyDomain.Confirmations();
    Hashtable locks = new Hashtable();
    Hashtable groups = new Hashtable();

    static Properties getProperties(String[] args, int start) {
        Properties props = new Properties();
        while (start < args.length) {
            String a = args[start];
            int i = a.indexOf(61);
            if (i <= 0) {
                CmdInt.SimpleCommand.Error("illegal assignment");
            }
            String n = a.substring(0, i);
            String v = a.substring(i + 1);
            props.setProperty(n, v);
            ++start;
        }
        return props;
    }

    public TestEnv() {
        super("consistency", "Consistency Layer Test System", c);
        this.domain = ConsistencyDomains.queryDomain("<SYSTEM>");
    }

    public void handleConsistencyEvent(ConsistencyDomain d, int e) {
        System.out.println("****** event " + d.getName() + ":" + e + " ******");
    }

    ConsistencyDomain.Lock getLock(String name) {
        ConsistencyDomain.Lock l = (ConsistencyDomain.Lock)this.locks.get(name);
        if (l == null) {
            CmdInt.SimpleCommand.Error("lock not created");
        }
        return l;
    }

    ConsistencyDomain.LockGroup getLockGroup(String name) {
        ConsistencyDomain.LockGroup l = (ConsistencyDomain.LockGroup)this.groups.get(name);
        if (l == null) {
            CmdInt.SimpleCommand.Error("group not created");
        }
        return l;
    }

    static {
        System.out.println("adding consistency layer test environment");
        MainTestEnv.addTestEnv(env);
    }

    public static class ConfirmCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public ConfirmCmd() {
            super("confirmation", "[-w]", "check confirmations");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            boolean wait = false;
            if (args.length > 1 && args[1].equals("-w")) {
                wait = true;
            }
            if (wait) {
                try {
                    te.conf.waitForConfirmation();
                }
                catch (ConsistencyDomain.Confirmation.AbortedException e) {
                    CmdInt.SimpleCommand.Error("request aborted " + e);
                }
            } else if (te.conf.isConfirmed()) {
                System.out.println("confirmed");
            } else {
                System.out.println("not confirmed");
            }
            return 0;
        }
    }

    public static class PropagateCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public PropagateCmd() {
            super("propagate", "[-c] <id> <msg>", "propagate lock message");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            int arg = 1;
            boolean confirm = false;
            if (args.length > arg && args[arg].equals("-c")) {
                confirm = true;
                ++arg;
            }
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, arg + 2);
            ConsistencyDomain.Lock l = (ConsistencyDomain.Lock)te.locks.get(args[arg]);
            if (l == null) {
                CmdInt.SimpleCommand.Error("lock not created");
            }
            te.conf.add(l.propagate(args[arg + 1], confirm));
            return 0;
        }
    }

    public static class UnlockCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public UnlockCmd() {
            super("unlock", "[-c] [group] <id>", "unlock");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            int arg = 1;
            boolean confirm = false;
            if (args.length > arg && args[arg].equals("-c")) {
                confirm = true;
                ++arg;
            }
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, arg + 1, arg + 2);
            if ("group".startsWith(args[arg])) {
                CmdInt.SimpleCommand.CheckNumberOfArguments(args, 3);
                ConsistencyDomain.LockGroup g = te.getLockGroup(args[arg + 1]);
                te.conf.add(g.unlock(confirm));
            } else {
                CmdInt.SimpleCommand.CheckNumberOfArguments(args, arg + 1);
                ConsistencyDomain.Lock l = te.getLock(args[arg]);
                te.conf.add(l.unlock(confirm));
            }
            return 0;
        }
    }

    public static class LockCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public LockCmd() {
            super("lock", "[-g <group>] <id> [<timeout>]", "request lock");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            ConsistencyDomain.LockGroup g = null;
            long timeout = 0L;
            int arg = 1;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 2, 5);
            if (args[arg].equals("-g")) {
                CmdInt.SimpleCommand.CheckNumberOfArguments(args, 4, 5);
                g = te.getLockGroup(args[2]);
                arg += 2;
            }
            ConsistencyDomain.Lock l = te.getLock(args[arg]);
            if (args.length > arg + 1) {
                timeout = Integer.parseInt(args[arg + 1]);
            }
            try {
                if (timeout == 0L) {
                    if (g == null) {
                        l.lock();
                    } else {
                        l.lock(g);
                    }
                } else if (g == null) {
                    if (!l.lock(timeout)) {
                        System.out.println("timeout");
                    }
                } else if (!l.lock(g, timeout)) {
                    System.out.println("timeout");
                }
            }
            catch (IOException io) {
                CmdInt.SimpleCommand.Error(io.toString());
            }
            return 0;
        }
    }

    public static class QueryCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public QueryCmd() {
            super("query", "<name>", "query lock");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 2);
            ConsistencyDomain.Lock l = te.getLock(args[1]);
            System.out.println("lock info for " + args[1]);
            if (l.isLocked()) {
                System.out.println("  is locked by " + l.getLockHolder());
            } else {
                System.out.println("  is unlocked");
            }
            System.out.println("  is locked by me: " + l.isLockedByMe());
            return 0;
        }
    }

    public static class ReleaseCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public ReleaseCmd() {
            super("release", "<name>", "release lockable object");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 2);
            if (te.locks.get(args[1]) == null) {
                CmdInt.SimpleCommand.Error("lock not created");
            }
            te.locks.remove(args[1]);
            return 0;
        }
    }

    public static class CreateCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public CreateCmd() {
            super("create", "lock|group <name>", "create lock/group in current domain");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 3);
            if (te.domain == null) {
                CmdInt.SimpleCommand.Error("domain not set");
            }
            if ("lock".startsWith(args[1])) {
                if (te.locks.get(args[2]) != null) {
                    CmdInt.SimpleCommand.Error("lock already created");
                }
                ConsistencyDomain.Lock l = te.domain.createLock("testspace", new Lockable(args[2]));
                te.locks.put(args[2], l);
            } else if ("group".startsWith(args[1])) {
                if (te.groups.get(args[1]) != null) {
                    CmdInt.SimpleCommand.Error("group already created");
                }
                ConsistencyDomain.LockGroup l = te.domain.createLockGroup(args[2]);
                te.groups.put(args[2], l);
            } else {
                CmdInt.SimpleCommand.Error("illegal type");
            }
            return 0;
        }
    }

    static class Lockable
    implements ConsistencyDomain.Lockable {
        String id;

        Lockable(String id) {
            this.id = id;
        }

        public void notifyUnlock() {
            System.out.println("*** " + this.id + " unlocked");
        }

        public void notifyAbort() {
            System.out.println("*** lock for " + this.id + " aborted");
        }

        public void notify(String info) {
            System.out.println("*** notification for " + this.id + ": " + info);
        }

        public Object getId() {
            return this.id;
        }
    }

    public static class ListCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public ListCmd() {
            super("list", "[domains|locks]", "list registered domains");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            int sel = 1;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 1, 2);
            if (args.length > 1) {
                if ("domains".startsWith(args[1])) {
                    sel = 0;
                } else if ("locks".startsWith(args[1])) {
                    sel = 1;
                } else if ("groups".startsWith(args[1])) {
                    sel = 2;
                } else {
                    CmdInt.SimpleCommand.Error("illegal selection");
                }
            }
            switch (sel) {
                case 0: {
                    Collection c = ConsistencyDomains.getDomains();
                    Iterator i = c.iterator();
                    while (i.hasNext()) {
                        String name = (String)i.next();
                        ConsistencyDomain d = ConsistencyDomains.queryDomain(name);
                        if (d == null) {
                            System.out.println("  " + name + ": not found");
                            continue;
                        }
                        System.out.println("  " + name + ": " + d.getProperties());
                    }
                    break;
                }
                case 1: {
                    Enumeration e = te.locks.keys();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        ConsistencyDomain.Lock l = (ConsistencyDomain.Lock)te.locks.get(name);
                        System.out.println("  " + name + ": " + l.getDomain().getName() + ", " + l.getNameSpace());
                    }
                    break;
                }
                case 2: {
                    Enumeration e = te.groups.keys();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        ConsistencyDomain.LockGroup l = (ConsistencyDomain.LockGroup)te.groups.get(name);
                        System.out.println("  " + name + ": " + l.getDomain().getName());
                        Collection elems = l.getLocks();
                        if (elems.size() <= 0) continue;
                        Iterator i = elems.iterator();
                        while (i.hasNext()) {
                            ConsistencyDomain.Lock m = (ConsistencyDomain.Lock)i.next();
                            System.out.println("    " + m.getLockable().getId() + ": " + m.getNameSpace());
                        }
                    }
                    break;
                }
            }
            return 0;
        }
    }

    public static class SwitchCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public SwitchCmd() {
            super("switch", "[<domain name>]", "switch domain");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 1, 2);
            if (args.length > 1) {
                te.domain = ConsistencyDomains.queryDomain(args[1]);
                if (te.domain != null) {
                    te.domain.registerEventHandler(te);
                }
            }
            if (te.domain != null) {
                System.out.println("domain is " + te.domain.getName());
            } else {
                System.out.println("no domain set");
            }
            return 0;
        }
    }

    public static class SetupCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public SetupCmd() {
            super("setup", "[ <name> {<attrs>}]", "setup standard consistency domains/create domain");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            if (args.length > 1) {
                String name = args[1];
                Properties props = TestEnv.getProperties(args, 2);
                ConsistencyDomain d = ConsistencyDomains.createDomain(name, props);
                if (d == null) {
                    CmdInt.SimpleCommand.Error("cannot create domain " + name + ": " + props);
                }
                te.domain = d;
            } else {
                Properties props = new Properties();
                if (ConsistencyDomains.queryDomain("<LOCAL>") == null) {
                    System.out.println("creating local domain");
                    props.setProperty("class", "com.sap.ip.basecomps.consistency.impl.Local");
                    if (ConsistencyDomains.createDomain("<LOCAL>", props) == null) {
                        CmdInt.SimpleCommand.Error("cannot create system domain");
                    }
                }
                if (te.domain == null) {
                    te.domain = ConsistencyDomains.queryDomain("<LOCAL>");
                }
            }
            return 0;
        }
    }
}

