/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.consistency.impl;

import com.sap.ip.basecomps.consistency.ConsistencyDomain;
import com.sap.ip.basecomps.consistency.impl.DomainSupport;
import com.sap.ip.basecomps.util.WeakHashTable;
import java.io.IOException;
import java.util.Properties;

public class None
extends DomainSupport {
    private WeakHashTable locks = new WeakHashTable();

    public None(Properties props) {
        super(props);
    }

    private LocalLockImpl getLock(String id) {
        return (LocalLockImpl)this.locks.get(id);
    }

    public void assertConsistency() {
    }

    public synchronized ConsistencyDomain.Lock createLock(String namespace, ConsistencyDomain.Lockable o) {
        String id = namespace + ":" + o.getId();
        LocalLockImpl lock = this.getLock(id);
        if (lock == null) {
            DomainSupport.deb.out("new lock for " + id);
            lock = new LocalLockImpl(namespace, o);
            this.locks.put(id, lock);
        } else {
            lock.setLockable(o);
        }
        return lock;
    }

    public ConsistencyDomain.LockGroup createLockGroup(String id) {
        return new LocalLockGroupImpl(id);
    }

    private class LocalLockGroupImpl
    extends DomainSupport.LockGroupSupport {
        LocalLockGroupImpl(String id) {
            super(id);
        }

        public ConsistencyDomain getDomain() {
            return None.this;
        }

        protected synchronized ConsistencyDomain.Confirmation _unlock(boolean confirm, boolean aborted) {
            if (!this.locks.isEmpty()) {
                DomainSupport.deb.out("unlock group " + this.id);
            }
            if (confirm) {
                return new DomainSupport.DummyConfirmation();
            }
            return null;
        }
    }

    private class LocalLockImpl
    extends DomainSupport.LockSupport {
        public LocalLockImpl(String ns, ConsistencyDomain.Lockable o) {
            super(ns, o);
        }

        public ConsistencyDomain getDomain() {
            return None.this;
        }

        public void assertConsistency() {
        }

        public synchronized boolean lock(boolean nonblocking, ConsistencyDomain.LockGroup grp, long timeout) throws IOException {
            Object o = this.buildOwner(grp);
            DomainSupport.deb.out("lock " + this.object);
            ++this.locked;
            this.owner = o;
            this.group = grp;
            if (this.group != null) {
                this.group.addLock(this);
            }
            return true;
        }

        public synchronized ConsistencyDomain.Confirmation unlock(ConsistencyDomain.LockGroup grp, boolean confirm) {
            DomainSupport.deb.out("unlock " + this.object);
            if (this.locked > 0 && --this.locked == 0) {
                this.notifyUnlock();
            }
            if (confirm) {
                return new DomainSupport.DummyConfirmation();
            }
            return null;
        }

        public boolean isLocalLock() {
            return true;
        }

        public boolean isLocked() {
            return this.isLocallyLocked();
        }

        public ConsistencyDomain.Confirmation propagate(String info, boolean confirm) {
            DomainSupport.deb.out("propagate " + info + " for " + this.object);
            if (confirm) {
                return new DomainSupport.DummyConfirmation();
            }
            return null;
        }
    }
}

