/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.consistency.impl;

import com.sap.ip.basecomps.consistency.ConsistencyDomain;
import com.sap.ip.basecomps.consistency.impl.DomainSupport;
import com.sap.ip.basecomps.util.WeakHashTable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public class Local
extends DomainSupport {
    private WeakHashTable locks = new WeakHashTable();

    public Local(Properties props) {
        super(props);
    }

    private LocalLockImpl getLock(String id) {
        return (LocalLockImpl)this.locks.get(id);
    }

    public void assertConsistency() {
    }

    public synchronized ConsistencyDomain.Lock createLock(String namespace, ConsistencyDomain.Lockable o) {
        String id = namespace + ":" + o.getId();
        LocalLockImpl lock = this.getLock(id);
        if (lock == null) {
            DomainSupport.deb.out("new lock for " + id);
            lock = new LocalLockImpl(namespace, o);
            this.locks.put(id, lock);
        } else {
            lock.setLockable(o);
        }
        return lock;
    }

    public ConsistencyDomain.LockGroup createLockGroup(String id) {
        return new LocalLockGroupImpl(id);
    }

    private class LocalLockGroupImpl
    extends DomainSupport.LockGroupSupport {
        LocalLockGroupImpl(String id) {
            super(id);
        }

        public ConsistencyDomain getDomain() {
            return Local.this;
        }

        protected synchronized ConsistencyDomain.Confirmation _unlock(boolean confirm, boolean aborted) {
            if (!this.locks.isEmpty()) {
                DomainSupport.deb.out("unlock group " + this.id);
                Iterator i = new HashSet(this.locks).iterator();
            }
            if (confirm) {
                return new DomainSupport.DummyConfirmation();
            }
            return null;
        }
    }

    private class LocalLockImpl
    extends DomainSupport.LockSupport {
        public LocalLockImpl(String ns, ConsistencyDomain.Lockable o) {
            super(ns, o);
        }

        public ConsistencyDomain getDomain() {
            return Local.this;
        }

        public void assertConsistency() {
        }

        public synchronized boolean lock(boolean nonblocking, ConsistencyDomain.LockGroup grp, long timeout) throws IOException {
            Object o = this.buildOwner(grp);
            if (this.locked > 0 && nonblocking && o == this.owner) {
                return false;
            }
            DomainSupport.deb.out("lock " + this.namespace + ":" + this.object.getId() + ": " + this.object);
            while (this.locked > 0 && this.owner != o) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (timeout <= 0L) continue;
                return false;
            }
            ++this.locked;
            this.owner = o;
            this.group = grp;
            if (this.group != null) {
                this.group.addLock(this);
            }
            return true;
        }

        public synchronized ConsistencyDomain.Confirmation unlock(ConsistencyDomain.LockGroup grp, boolean confirm) {
            DomainSupport.deb.out("unlock " + this.namespace + ":" + this.object.getId() + ": " + this.object);
            if (this.locked > 0 && this.owner == this.buildOwner(grp) && --this.locked == 0) {
                this.notifyUnlock();
            }
            if (confirm) {
                return new DomainSupport.DummyConfirmation();
            }
            return null;
        }

        public synchronized boolean isLocalLock() {
            return true;
        }

        public boolean isLocked() {
            return this.isLocallyLocked();
        }

        public ConsistencyDomain.Confirmation propagate(String info, boolean confirm) {
            DomainSupport.deb.out("propagate " + info + " for " + this.object);
            if (confirm) {
                return new DomainSupport.DummyConfirmation();
            }
            return null;
        }

        protected void _clearLock() {
            super._clearLock();
            this.notify();
        }
    }
}

