/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.consistency.impl;

import com.sap.ip.basecomps.consistency.ConsistencyDomain;
import com.sap.ip.basecomps.debug.Debug;
import com.sap.ip.basecomps.util.UUID;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public abstract class DomainSupport
implements ConsistencyDomain {
    protected static Debug deb = Debug.getDebug("consistency");
    protected String domain;
    protected Properties props;
    protected HashSet namespaces = new HashSet();
    private HashSet handlers = new HashSet();

    public DomainSupport(Properties props) {
        this.props = props;
        this.domain = props.getProperty("name");
    }

    public Properties getProperties() {
        return (Properties)((Hashtable)this.props).clone();
    }

    public String getName() {
        return this.domain;
    }

    public boolean registerNameSpace(String name) {
        if (this.namespaces.contains(name)) {
            return false;
        }
        this.namespaces.add(name);
        return true;
    }

    public boolean existsNameSpace(String name) {
        return this.namespaces.contains(name);
    }

    public Collection getNameSpaces() {
        return (Collection)this.namespaces.clone();
    }

    public synchronized void registerEventHandler(ConsistencyDomain.IEventHandler h) {
        this.handlers.add(h);
    }

    public synchronized void unregisterEventHandler(ConsistencyDomain.IEventHandler h) {
        this.handlers.remove(h);
    }

    protected synchronized void propagateEvent(int e) {
        Iterator i = this.handlers.iterator();
        while (i.hasNext()) {
            ConsistencyDomain.IEventHandler h = (ConsistencyDomain.IEventHandler)i.next();
            try {
                h.handleConsistencyEvent(this, e);
            }
            catch (Exception ex) {
                System.err.println("handler failed: " + e);
            }
        }
    }

    public abstract ConsistencyDomain.LockGroup createLockGroup(String var1);

    public abstract ConsistencyDomain.Lock createLock(String var1, ConsistencyDomain.Lockable var2);

    public static abstract class LockGroupSupport
    implements ConsistencyDomain.LockGroup {
        protected String id;
        protected HashSet locks = new HashSet();

        public LockGroupSupport(String id) {
            this.setID(id);
        }

        public void setID(String id) {
            if (id == null) {
                UUID guid = new UUID();
                guid.generateUUID();
                id = guid.toString();
            }
            this.id = id;
        }

        public String getID() {
            return this.id;
        }

        public synchronized boolean isMember(ConsistencyDomain.Lock lock) {
            return this.locks.contains(lock);
        }

        public synchronized void addLock(ConsistencyDomain.Lock lock) {
            if (lock != null && lock.getDomain() == this.getDomain()) {
                this.locks.add(lock);
            }
        }

        public synchronized void removeLock(ConsistencyDomain.Lock lock) {
            this.locks.remove(lock);
        }

        public synchronized Collection getLocks() {
            return (Collection)this.locks.clone();
        }

        public String toString() {
            return this.id;
        }

        public void unlock() {
            this.unlock(false);
        }

        public ConsistencyDomain.Confirmation unlock(boolean confirm) {
            return this.unlock(confirm, false);
        }

        protected final synchronized ConsistencyDomain.Confirmation unlock(boolean confirm, boolean aborted) {
            ConsistencyDomain.Confirmation c = this._unlock(confirm, aborted);
            this._notify(aborted);
            return c;
        }

        protected final synchronized void _notify(boolean aborted) {
            Iterator i = ((Collection)this.locks.clone()).iterator();
            while (i.hasNext()) {
                LockSupport l = (LockSupport)i.next();
                if (aborted) {
                    l.notifyAbort();
                    continue;
                }
                l.notifyUnlock();
            }
        }

        protected abstract ConsistencyDomain.Confirmation _unlock(boolean var1, boolean var2);

        public void abort() {
            this.abort(false);
        }

        protected synchronized void abort(boolean lost) {
            deb.errorLog("  aborting lock group " + (lost ? "(lost) " : "") + this);
            if (!lost) {
                this._unlock(false, true);
                this._notify(true);
            }
            this.locks.clear();
        }

        public abstract ConsistencyDomain getDomain();
    }

    public static abstract class LockSupport
    implements ConsistencyDomain.Lock {
        protected String namespace;
        protected int locked;
        protected Object owner;
        protected ConsistencyDomain.LockGroup group;
        protected ConsistencyDomain.Lockable object;

        protected LockSupport(String ns, ConsistencyDomain.Lockable o) {
            this.object = o;
            this.locked = 0;
            this.namespace = ns;
        }

        public String getNameSpace() {
            return this.namespace;
        }

        public ConsistencyDomain.Lockable getLockable() {
            return this.object;
        }

        public Object getLockHolder() {
            return this.owner;
        }

        public void setLockable(ConsistencyDomain.Lockable o) {
            this.object = o;
        }

        public void lock() throws IOException {
            this.lock(false, null, 0L);
        }

        public boolean lock(long timeout) throws IOException {
            return this.lock(false, null, timeout);
        }

        public void lock(ConsistencyDomain.LockGroup grp) throws IOException {
            this.lock(false, grp, 0L);
        }

        public boolean lock(ConsistencyDomain.LockGroup grp, long timeout) throws IOException {
            return this.lock(false, grp, timeout);
        }

        public boolean lock(boolean nonblocking) throws IOException {
            return this.lock(nonblocking, null, 0L);
        }

        public boolean lock(boolean nonblocking, long timeout) throws IOException {
            return this.lock(nonblocking, null, timeout);
        }

        public boolean lock(boolean nonblocking, ConsistencyDomain.LockGroup grp) throws IOException {
            return this.lock(nonblocking, grp, 0L);
        }

        public abstract boolean lock(boolean var1, ConsistencyDomain.LockGroup var2, long var3) throws IOException;

        public void unlock() {
            this.unlock(null);
        }

        public void unlock(ConsistencyDomain.LockGroup grp) {
            this.unlock(grp, false);
        }

        public ConsistencyDomain.Confirmation unlock(boolean confirm) {
            return this.unlock(null, confirm);
        }

        public abstract ConsistencyDomain.Confirmation unlock(ConsistencyDomain.LockGroup var1, boolean var2);

        public abstract boolean isLocalLock();

        public synchronized boolean isLocallyLocked() {
            return this.locked > 0;
        }

        public abstract boolean isLocked();

        public synchronized boolean isLockedByMe() {
            return this.isLocked() && this.owner == Thread.currentThread();
        }

        public synchronized boolean isLockedByGroup(ConsistencyDomain.LockGroup grp) {
            return this.isLocallyLocked() && this.group != null && this.owner == grp;
        }

        public void propagate(String info) {
            this.propagate(info, false);
        }

        public abstract ConsistencyDomain.Confirmation propagate(String var1, boolean var2);

        protected Object buildOwner(ConsistencyDomain.LockGroup grp) {
            return grp == null ? Thread.currentThread() : grp;
        }

        protected String getOwnerId(Object o) {
            if (o instanceof ConsistencyDomain.LockGroup) {
                return ((ConsistencyDomain.LockGroup)o).getID();
            }
            return o.toString();
        }

        protected synchronized void clearLock() {
            if (this.group != null) {
                this.group.removeLock(this);
            }
            this.locked = 0;
            this.owner = null;
            this.group = null;
            this._clearLock();
        }

        protected void _clearLock() {
            deb.out("release lock " + this.namespace + ":" + (this.object == null ? this.object : this.object.getId()));
        }

        protected synchronized void notifyUnlock() {
            this.clearLock();
            this.object.notifyUnlock();
        }

        protected synchronized void notifyAbort() {
            this.clearLock();
            this.object.notifyAbort();
        }

        public void abort() {
            this.abort(false);
        }

        protected synchronized void abort(boolean lost) {
            if (this.locked > 0) {
                deb.errorLog("  aborting lock " + (lost ? "(lost) " : "") + this);
                if (!lost) {
                    this._abort();
                }
                this.notifyAbort();
            }
        }

        protected void _abort() {
        }

        public abstract ConsistencyDomain getDomain();

        public abstract void assertConsistency();
    }

    protected static class DummyConfirmation
    implements ConsistencyDomain.Confirmation {
        public boolean isAborted() {
            return false;
        }

        public boolean isConfirmed() {
            return true;
        }

        public void waitForConfirmation() throws ConsistencyDomain.Confirmation.AbortedException {
        }

        public boolean waitForConfirmation(long timeout) throws ConsistencyDomain.Confirmation.AbortedException {
            return true;
        }

        public boolean cancelConfirmation() {
            return true;
        }
    }
}

