/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.consistency;

import com.sap.ip.basecomps.debug.Debug;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

public interface ConsistencyDomain {
    public static final Debug deb = Debug.getDebug("lock");
    public static final int LOCK_CONTEXT_LOST = 1;
    public static final String ENQUEUE = "ENQUEUE";
    public static final String VOS = "VOS";
    public static final String ASSO = "ASSO";
    public static final String FILE_STORAGE = "FILE_STORAGE";

    public Properties getProperties();

    public String getName();

    public boolean registerNameSpace(String var1);

    public boolean existsNameSpace(String var1);

    public Collection getNameSpaces();

    public void registerEventHandler(IEventHandler var1);

    public void unregisterEventHandler(IEventHandler var1);

    public Lock createLock(String var1, Lockable var2);

    public LockGroup createLockGroup(String var1);

    public static interface LockGroup {
        public String getID();

        public void setID(String var1);

        public ConsistencyDomain getDomain();

        public boolean isMember(Lock var1);

        public void addLock(Lock var1);

        public void removeLock(Lock var1);

        public Collection getLocks();

        public void unlock();

        public Confirmation unlock(boolean var1);

        public void abort();

        public String toString();
    }

    public static abstract class LockableSupport
    implements Lockable {
        public void notifyUnlock() {
        }

        public void notifyAbort() {
        }

        public void notify(String info) {
        }

        public abstract Object getId();
    }

    public static interface Lockable {
        public void notifyUnlock();

        public void notifyAbort();

        public void notify(String var1);

        public Object getId();
    }

    public static class Confirmations
    implements Confirmation {
        private Vector waiting = new Vector();

        public synchronized void add(Confirmation c) {
            this.isConfirmed();
            if (c != null) {
                this.waiting.add(c);
            }
        }

        public synchronized boolean isAborted() {
            return false;
        }

        public synchronized boolean isConfirmed() {
            int i = this.waiting.size() - 1;
            while (i >= 0) {
                Confirmation t = (Confirmation)this.waiting.elementAt(i);
                if (!t.isConfirmed()) break;
                --i;
            }
            return i < 0;
        }

        /*
         * WARNING - void declaration
         */
        public void waitForConfirmation() throws Confirmation.AbortedException {
            int i;
            Confirmation.AbortedException aborted = null;
            while ((i = this.waiting.size() - 1) >= 0) {
                Confirmation c;
                void var1_2;
                try {
                    c = (Confirmation)this.waiting.elementAt((int)var1_2);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    c = null;
                }
                if (c != null && !c.isConfirmed()) {
                    try {
                        deb.out("waiting for " + c);
                        c.waitForConfirmation();
                    }
                    catch (Confirmation.AbortedException a) {
                        aborted = a;
                    }
                }
                try {
                    this.waiting.removeElementAt((int)var1_2);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                if (aborted == null) continue;
                throw aborted;
            }
        }

        /*
         * WARNING - void declaration
         */
        public boolean waitForConfirmation(long timeout) throws Confirmation.AbortedException {
            int i;
            Confirmation.AbortedException aborted = null;
            while ((i = this.waiting.size() - 1) >= 0) {
                Confirmation c;
                void var3_3;
                try {
                    c = (Confirmation)this.waiting.elementAt((int)var3_3);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    c = null;
                }
                if (c != null && !c.isConfirmed()) {
                    try {
                        deb.out("waiting for " + c);
                        if (!c.waitForConfirmation(timeout)) {
                            break;
                        }
                    }
                    catch (Confirmation.AbortedException a) {
                        aborted = a;
                    }
                }
                try {
                    this.waiting.removeElementAt((int)var3_3);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                if (aborted == null) continue;
                throw aborted;
            }
            return this.waiting.size() == 0;
        }

        public synchronized boolean cancelConfirmation() {
            int i = this.waiting.size() - 1;
            boolean result = true;
            while (i >= 0) {
                Confirmation c = (Confirmation)this.waiting.elementAt(i);
                if (c != null && !c.isConfirmed()) {
                    result &= c.cancelConfirmation();
                }
                --i;
            }
            this.waiting.clear();
            return result;
        }
    }

    public static interface Confirmation {
        public boolean isConfirmed();

        public boolean isAborted();

        public void waitForConfirmation() throws AbortedException;

        public boolean waitForConfirmation(long var1) throws AbortedException;

        public boolean cancelConfirmation();

        public static class AbortedException
        extends Exception {
            public AbortedException(Exception e) {
                super(e.toString());
            }
        }
    }

    public static interface Lock {
        public void assertConsistency();

        public void lock() throws IOException;

        public boolean lock(long var1) throws IOException;

        public void lock(LockGroup var1) throws IOException;

        public boolean lock(LockGroup var1, long var2) throws IOException;

        public boolean lock(boolean var1) throws IOException;

        public boolean lock(boolean var1, long var2) throws IOException;

        public boolean lock(boolean var1, LockGroup var2) throws IOException;

        public boolean lock(boolean var1, LockGroup var2, long var3) throws IOException;

        public void unlock();

        public void unlock(LockGroup var1);

        public Confirmation unlock(boolean var1);

        public Confirmation unlock(LockGroup var1, boolean var2);

        public ConsistencyDomain getDomain();

        public String getNameSpace();

        public Lockable getLockable();

        public Object getLockHolder();

        public boolean isLocalLock();

        public boolean isLocallyLocked();

        public boolean isLocked();

        public boolean isLockedByMe();

        public boolean isLockedByGroup(LockGroup var1);

        public void propagate(String var1);

        public Confirmation propagate(String var1, boolean var2);

        public void abort();
    }

    public static interface IEventHandler {
        public void handleConsistencyEvent(ConsistencyDomain var1, int var2);
    }
}

